/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.extension.columnar.offload;

import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.extension.columnar.offload.OffloadJoin;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildRight$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.joins.ShuffledHashJoinExec;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.math.BigInt;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;

public final class OffloadJoin$
implements Serializable {
    public static OffloadJoin$ MODULE$;

    static {
        new OffloadJoin$();
    }

    public BuildSide getShjBuildSide(ShuffledHashJoinExec shj) {
        boolean leftBuildable = BoxesRunTime.unboxToBoolean((Object)BackendsApiManager$.MODULE$.getSettings().supportHashBuildJoinTypeOnLeft().apply((Object)shj.joinType()));
        boolean rightBuildable = BoxesRunTime.unboxToBoolean((Object)BackendsApiManager$.MODULE$.getSettings().supportHashBuildJoinTypeOnRight().apply((Object)shj.joinType()));
        Predef$.MODULE$.assert(leftBuildable || rightBuildable);
        if (!leftBuildable) {
            return BuildRight$.MODULE$;
        }
        if (!rightBuildable) {
            return BuildLeft$.MODULE$;
        }
        if (!GlutenConfig$.MODULE$.get().shuffledHashJoinOptimizeBuildSide()) {
            return shj.buildSide();
        }
        return (BuildSide)shj.logicalLink().flatMap((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            None$ none$;
            LogicalPlan logicalPlan = x0$1;
            if (logicalPlan instanceof Join) {
                Join join = (Join)logicalPlan;
                none$ = new Some((Object)MODULE$.getOptimalBuildSide(join));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> shj.buildSide());
    }

    public BuildSide getOptimalBuildSide(Join join) {
        BigInt leftSize = join.left().stats().sizeInBytes();
        BigInt rightSize = join.right().stats().sizeInBytes();
        Option leftRowCount = join.left().stats().rowCount();
        Option rightRowCount = join.right().stats().rowCount();
        BigInt bigInt = leftSize;
        BigInt bigInt2 = rightSize;
        if (!(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null)) {
            if (rightRowCount.isDefined() && leftRowCount.isDefined()) {
                if (((Ordered)rightRowCount.get()).$less$eq(leftRowCount.get())) {
                    return BuildRight$.MODULE$;
                }
                return BuildLeft$.MODULE$;
            }
        }
        if (rightSize.$less$eq((Object)leftSize)) {
            return BuildRight$.MODULE$;
        }
        return BuildLeft$.MODULE$;
    }

    public OffloadJoin apply() {
        return new OffloadJoin();
    }

    public boolean unapply(OffloadJoin x$0) {
        return x$0 != null;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OffloadJoin$() {
        MODULE$ = this;
    }
}

