/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.GenerateRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import java.io.Serializable;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class GenerateRelNode
implements RelNode,
Serializable {
    private final RelNode input;
    private final ExpressionNode generator;
    private final List<ExpressionNode> childOutput;
    private final AdvancedExtensionNode extensionNode;
    private final boolean outer;

    GenerateRelNode(RelNode input, ExpressionNode generator, List<ExpressionNode> childOutput, boolean outer) {
        this(input, generator, childOutput, null, outer);
    }

    GenerateRelNode(RelNode input, ExpressionNode generator, List<ExpressionNode> childOutput, AdvancedExtensionNode extensionNode, boolean outer) {
        this.input = input;
        this.generator = generator;
        this.childOutput = childOutput;
        this.extensionNode = extensionNode;
        this.outer = outer;
    }

    @Override
    public Rel toProtobuf() {
        GenerateRel.Builder generateRelBuilder = GenerateRel.newBuilder();
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        generateRelBuilder.setCommon(relCommonBuilder.build());
        if (this.input != null) {
            generateRelBuilder.setInput(this.input.toProtobuf());
        }
        if (this.generator != null) {
            generateRelBuilder.setGenerator(this.generator.toProtobuf());
        }
        for (ExpressionNode node : this.childOutput) {
            generateRelBuilder.addChildOutput(node.toProtobuf());
        }
        generateRelBuilder.setOuter(this.outer);
        if (this.extensionNode != null) {
            generateRelBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        Rel.Builder relBuilder = Rel.newBuilder();
        relBuilder.setGenerate(generateRelBuilder.build());
        return relBuilder.build();
    }
}

