/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.NamedStruct;
import io.substrait.proto.ReadRel;
import io.substrait.proto.Rel;
import io.substrait.proto.Type;
import java.util.List;
import org.apache.gluten.expression.ConverterUtils;
import org.apache.gluten.substrait.rel.LocalFilesBuilder;
import org.apache.gluten.substrait.rel.LocalFilesNode;
import org.apache.gluten.substrait.rel.RelNode;
import org.apache.gluten.substrait.type.TypeNode;

public class InputIteratorRelNode
implements RelNode {
    private final List<TypeNode> types;
    private final List<String> names;
    private final Long iteratorIndex;

    public InputIteratorRelNode(List<TypeNode> types, List<String> names, Long iteratorIndex) {
        this.types = types;
        this.names = names;
        this.iteratorIndex = iteratorIndex;
    }

    @Override
    public Rel toProtobuf() {
        Type.Struct.Builder structBuilder = Type.Struct.newBuilder();
        for (TypeNode typeNode : this.types) {
            structBuilder.addTypes(typeNode.toProtobuf());
        }
        NamedStruct.Builder nStructBuilder = NamedStruct.newBuilder();
        nStructBuilder.setStruct(structBuilder.build());
        for (String name : this.names) {
            nStructBuilder.addNames(name);
        }
        ReadRel.Builder builder = ReadRel.newBuilder();
        builder.setBaseSchema(nStructBuilder.build());
        LocalFilesNode iteratorIndexNode = LocalFilesBuilder.makeLocalFiles(ConverterUtils.ITERATOR_PREFIX() + this.iteratorIndex);
        builder.setLocalFiles(iteratorIndexNode.toProtobuf());
        Rel.Builder builder2 = Rel.newBuilder();
        builder2.setRead(builder.build());
        return builder2.build();
    }
}

