/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.udf;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.UdfMethodNameImplementor;
import org.apache.calcite.linq4j.function.Parameter;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.fun.udf.UdfDef;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.util.TimeUtil;

public class KylinOtherUDF {
    public String TO_CHAR(@Parameter(name="date") Timestamp date, @Parameter(name="part") String part) {
        String partOfDate = null;
        switch (part.toUpperCase(Locale.ROOT)) {
            case "YEAR": {
                partOfDate = date.toString().substring(0, 4);
                break;
            }
            case "MONTH": {
                partOfDate = date.toString().substring(5, 7);
                break;
            }
            case "DAY": {
                partOfDate = date.toString().substring(8, 10);
                break;
            }
            case "HOUR": {
                partOfDate = date.toString().substring(11, 13);
                break;
            }
            case "MINUTE": 
            case "MINUTES": {
                partOfDate = date.toString().substring(14, 16);
                break;
            }
            case "SECOND": 
            case "SECONDS": {
                partOfDate = date.toString().substring(17, 19);
                break;
            }
        }
        return partOfDate;
    }

    public String TO_CHAR(@Parameter(name="date") Date date, @Parameter(name="part") String part) {
        return this.TO_CHAR(new Timestamp(date.getTime()), part);
    }

    public String _ymdint_between(@Parameter(name="date1") Object date1, @Parameter(name="date2") Object date2) {
        try {
            long d1 = DateUtils.parseDate((String)date1.toString(), (String[])new String[]{"yyyy-MM-dd"}).getTime();
            long d2 = DateUtils.parseDate((String)date2.toString(), (String[])new String[]{"yyyy-MM-dd"}).getTime();
            return TimeUtil.ymdintBetween((long)d1, (long)d2);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Only dates in yyyy-MM-dd format are supported!", e);
        }
    }

    public Boolean MASSIN(@Parameter(name="col") Object col, @Parameter(name="filterTable") String filterTable) {
        return true;
    }

    public String VERSION() {
        return KylinVersion.getCurrentVersion().toString();
    }

    public String SPLIT_PART(@Parameter(name="str") String str, @Parameter(name="regex") String regex, @Parameter(name="index") int index) {
        String[] parts = str.split(regex);
        if (index - 1 < parts.length && index > 0) {
            return parts[index - 1];
        }
        if (index < 0 && Math.abs(index) <= parts.length) {
            return parts[parts.length + index];
        }
        return null;
    }

    public Integer INSTR(@Parameter(name="str") String s1, @Parameter(name="subStr") String s2) {
        return s1.indexOf(s2) + 1;
    }

    public int INSTR(@Parameter(name="str") String s1, @Parameter(name="subStr") String s2, @Parameter(name="position") int p) {
        return s1.indexOf(s2, p - 1) + 1;
    }

    public int STRPOS(@Parameter(name="str1") String s1, @Parameter(name="str2") String s2) {
        return s1.indexOf(s2) + 1;
    }

    public static class ConcatWithNull
    implements UdfDef {
        private static final String FUNC_NAME = "CONCAT";
        public static final SqlFunction OPERATOR = new SqlFunction(new SqlIdentifier("CONCAT", SqlParserPos.ZERO), ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE, InferTypes.ANY_NULLABLE, OperandTypes.repeat((SqlOperandCountRange)SqlOperandCountRanges.from((int)0), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY}), null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        public static final CallImplementor IMPLEMENTOR = new UdfMethodNameImplementor("CONCAT".toLowerCase(Locale.ROOT), ConcatWithNull.class);

        private ConcatWithNull() {
            throw new IllegalStateException("Utility class");
        }

        public static String concat(Object ... args) {
            if (args == null) {
                return null;
            }
            return Arrays.stream(args).map(String::valueOf).collect(Collectors.joining());
        }
    }
}

