/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cluster;

import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.util.SpringContext;

public interface ClusterManager {
    public String getLocalServer();

    public List<ServerInfoResponse> getQueryServers();

    public List<ServerInfoResponse> getServersFromCache();

    public List<ServerInfoResponse> getJobServers();

    public List<ServerInfoResponse> getServers();

    default public ServerInfoResponse getServerById(String serverId) {
        throw new KylinRuntimeException(String.format(Locale.ROOT, "Method `getServerById` is not supported in class <%s>", this.getClass()));
    }

    public static ClusterManager getInstance() {
        return (ClusterManager)SpringContext.getApplicationContext().getBean(ClusterManager.class);
    }

    default public boolean checkServer(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return true;
        }
        return this.getServers().stream().noneMatch(server -> StringUtils.equals((CharSequence)server.getHost(), (CharSequence)host));
    }
}

