/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon.handler;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.tool.daemon.CheckResult;
import org.apache.kylin.tool.daemon.HandleResult;
import org.apache.kylin.tool.daemon.HandleStateEnum;
import org.apache.kylin.tool.daemon.handler.AbstractCheckStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartStateHandler
extends AbstractCheckStateHandler {
    private static final Logger logger = LoggerFactory.getLogger(RestartStateHandler.class);

    @Override
    public HandleResult doHandle(CheckResult checkResult) {
        logger.info("Start to restart instance port[{}] ...", (Object)RestartStateHandler.getServerPort());
        String cmd = "nohup sh " + KylinConfig.getKylinHome() + "/bin/kylin.sh restart > /dev/null 2>&1 &";
        try {
            RestartStateHandler.getCommandExecutor().execute(cmd, null);
            logger.info("Success to restart instance port[{}] ...", (Object)RestartStateHandler.getServerPort());
        }
        catch (Exception e) {
            logger.error("Failed to restart the instance port [{}], cmd: {}", (Object)RestartStateHandler.getServerPort(), (Object)cmd);
        }
        return new HandleResult(HandleStateEnum.STOP_CHECK);
    }
}

