/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.io.IOException;
import lombok.Generated;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.FileSystemUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogCleaner.class);

    public void cleanUp() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        Path remotePath = new Path(config.getHdfsWorkingDirectory(), "_logs");
        try {
            if (!fs.exists(remotePath) || fs.isFile(remotePath)) {
                log.info("Folder {} not exist, skip cleanUp.", (Object)remotePath);
                return;
            }
            for (FileStatus fileStatus : FileSystemUtil.listStatus((FileSystem)fs, (Path)remotePath)) {
                try {
                    if (System.currentTimeMillis() - fileStatus.getModificationTime() <= config.getInstanceLogRetentionTime()) continue;
                    fs.delete(fileStatus.getPath(), true);
                    log.info("Clean gc & jstack log for instance {} succeed.", (Object)fileStatus.getPath().getName());
                }
                catch (IOException e) {
                    log.error("Clean gc & jstack log for instance {} failed, skip this instance.", (Object)fileStatus.getPath().getName());
                }
            }
        }
        catch (IOException e) {
            log.error("Check folder {} failed, skip cleanUp.", (Object)remotePath);
        }
    }
}

