/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.ElementFacetBuilder;
import springfox.documentation.schema.CollectionElementFacet;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.service.CollectionFormat;

public class CollectionElementFacetBuilder
implements ElementFacetBuilder {
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private CollectionFormat collectionFormat;

    public CollectionElementFacetBuilder collectionFormat(CollectionFormat collectionFormat) {
        this.collectionFormat = BuilderDefaults.defaultIfAbsent(collectionFormat, this.collectionFormat);
        return this;
    }

    public CollectionElementFacetBuilder maxItems(Integer maxItems) {
        this.maxItems = BuilderDefaults.defaultIfAbsent(maxItems, this.maxItems);
        return this;
    }

    public CollectionElementFacetBuilder minItems(Integer minItems) {
        this.minItems = BuilderDefaults.defaultIfAbsent(minItems, this.minItems);
        return this;
    }

    public CollectionElementFacetBuilder uniqueItems(Boolean uniqueItems) {
        this.uniqueItems = BuilderDefaults.defaultIfAbsent(uniqueItems, this.uniqueItems);
        return this;
    }

    @Override
    public ElementFacet build() {
        if (this.maxItems == null && this.minItems == null && this.uniqueItems == null) {
            return null;
        }
        return new CollectionElementFacet(this.maxItems, this.minItems, this.uniqueItems);
    }

    @Override
    public CollectionElementFacetBuilder copyOf(ElementFacet facet) {
        if (!(facet instanceof CollectionElementFacet)) {
            return this;
        }
        CollectionElementFacet other = (CollectionElementFacet)facet;
        return this.maxItems(other.getMaxItems()).minItems(other.getMinItems()).uniqueItems(other.getUniqueItems());
    }
}

