/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.mappers;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import springfox.documentation.oas.mappers.ExamplesMapper;
import springfox.documentation.oas.mappers.LicenseMapper;
import springfox.documentation.oas.mappers.SchemaMapper;
import springfox.documentation.oas.mappers.SecurityMapper;
import springfox.documentation.oas.mappers.SecuritySchemeMapper;
import springfox.documentation.oas.mappers.ServiceModelToOpenApiMapper;
import springfox.documentation.oas.mappers.StyleEnumMapper;
import springfox.documentation.oas.mappers.VendorExtensionsMapper;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.Representation;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Server;
import springfox.documentation.service.ServerVariable;
import springfox.documentation.service.SimpleParameterSpecification;
import springfox.documentation.service.VendorExtension;

@Component
public class ServiceModelToOpenApiMapperImpl
extends ServiceModelToOpenApiMapper {
    @Autowired
    private VendorExtensionsMapper vendorExtensionsMapper;
    @Autowired
    private LicenseMapper licenseMapper;
    @Autowired
    private ExamplesMapper examplesMapper;
    @Autowired
    private SecurityMapper securityMapper;
    @Autowired
    private SchemaMapper schemaMapper;
    @Autowired
    private StyleEnumMapper styleEnumMapper;
    @Autowired
    private SecuritySchemeMapper securitySchemeMapper;

    @Override
    public OpenAPI mapDocumentation(Documentation from) {
        if (from == null) {
            return null;
        }
        OpenAPI openAPI = new OpenAPI();
        if (from.getResourceListing() != null) {
            if (openAPI.getComponents() == null) {
                openAPI.components(new Components());
            }
            this.resourceListingToComponents(from.getResourceListing(), openAPI.getComponents());
        }
        if (openAPI.getComponents() == null) {
            openAPI.components(new Components());
        }
        this.documentationToComponents(from, openAPI.getComponents());
        openAPI.extensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        openAPI.paths(this.mapPaths(from.getApiListings()));
        openAPI.externalDocs(this.mapExternalDocs(from.getExternalDocumentation()));
        openAPI.info(this.mapApiInfo(this.fromResourceListingInfo(from)));
        openAPI.servers(this.serverListToServerList(from.getServers()));
        openAPI.tags(this.tagSetToTagList(from.getTags()));
        openAPI.openapi("3.0.3");
        return openAPI;
    }

    @Override
    Operation mapOperation(springfox.documentation.service.Operation from, ModelNamesRegistry modelNamesRegistry) {
        if (from == null) {
            return null;
        }
        Operation operation = new Operation();
        operation.security(this.securityMapper.mapFrom(from.getSecurityReferences()));
        operation.extensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        operation.requestBody(this.map(from.getBody(), modelNamesRegistry));
        operation.operationId(from.getUniqueId());
        operation.description(from.getNotes());
        operation.parameters(this.requestParameterSortedSetToParameterList(from.getQueryParameters(), modelNamesRegistry));
        Set<String> set = from.getTags();
        if (set != null) {
            operation.tags(new ArrayList<String>(set));
        }
        operation.summary(from.getSummary());
        operation.responses(this.map(from.getResponses(), modelNamesRegistry));
        if (from.getDeprecated() != null) {
            operation.deprecated(Boolean.parseBoolean(from.getDeprecated()));
        }
        return operation;
    }

    @Override
    Parameter mapParameter(RequestParameter from, ModelNamesRegistry modelNamesRegistry) {
        if (from == null) {
            return null;
        }
        Parameter parameter = new Parameter();
        parameter.schema(this.fromSimpleParameter(this.fromParameterSpecificationQuery(from), modelNamesRegistry));
        parameter.in(this.fromInIn(from));
        parameter.name(from.getName());
        parameter.description(from.getDescription());
        parameter.required(from.getRequired());
        parameter.deprecated(from.getDeprecated());
        parameter.examples(this.examplesMapper.mapExamples(from.getExamples()));
        parameter.extensions(this.vendorExtensionsMapper.mapExtensions(from.getExtensions()));
        parameter.allowReserved(from.getParameterSpecification().getQuery().map((? super T q) -> q.getAllowReserved()).orElse(null));
        parameter.explode(from.getParameterSpecification().getQuery().map((? super T q) -> q.getExplode()).orElse(null));
        parameter.allowEmptyValue(from.getParameterSpecification().getQuery().map((? super T q) -> q.getAllowEmptyValue()).orElse(null));
        parameter.style(from.getParameterSpecification().getQuery().map((? super T q) -> this.parameterStyle(q.getStyle())).orElse(null));
        this.afterMappingParameter(from, parameter);
        return parameter;
    }

    @Override
    PathItem.HttpMethod mapHttpMethod(HttpMethod method) {
        PathItem.HttpMethod httpMethod;
        if (method == null) {
            return null;
        }
        switch (method) {
            case GET: {
                httpMethod = PathItem.HttpMethod.GET;
                break;
            }
            case HEAD: {
                httpMethod = PathItem.HttpMethod.HEAD;
                break;
            }
            case POST: {
                httpMethod = PathItem.HttpMethod.POST;
                break;
            }
            case PUT: {
                httpMethod = PathItem.HttpMethod.PUT;
                break;
            }
            case PATCH: {
                httpMethod = PathItem.HttpMethod.PATCH;
                break;
            }
            case DELETE: {
                httpMethod = PathItem.HttpMethod.DELETE;
                break;
            }
            case OPTIONS: {
                httpMethod = PathItem.HttpMethod.OPTIONS;
                break;
            }
            case TRACE: {
                httpMethod = PathItem.HttpMethod.TRACE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + method);
            }
        }
        return httpMethod;
    }

    @Override
    protected MediaType fromRepresentation(Representation each, ModelNamesRegistry modelNamesRegistry) {
        if (each == null) {
            return null;
        }
        MediaType mediaType = new MediaType();
        mediaType.schema(this.schemaMapper.mapModel(each.getModel(), modelNamesRegistry));
        List<VendorExtension> facetExtensions = this.eachModelFacetExtensions(each);
        mediaType.extensions(this.vendorExtensionsMapper.mapExtensions(facetExtensions));
        mediaType.encoding(this.fromEncodings(each.getEncodings(), modelNamesRegistry));
        return mediaType;
    }

    @Override
    protected Encoding mapEncoding(springfox.documentation.service.Encoding from, ModelNamesRegistry modelNamesRegistry) {
        if (from == null) {
            return null;
        }
        Encoding encoding = new Encoding();
        encoding.setStyle(this.styleEnumMapper.encodingStyle(from.getStyle()));
        encoding.setContentType(from.getContentType());
        encoding.setHeaders(this.fromHeaders(from.getHeaders(), modelNamesRegistry));
        encoding.setExplode(from.getExplode());
        encoding.setAllowReserved(from.getAllowReserved());
        encoding.extensions(this.vendorExtensionsMapper.mapExtensions(from.getExtensions()));
        return encoding;
    }

    @Override
    protected Header mapHeader(springfox.documentation.service.Header from, ModelNamesRegistry modelNamesRegistry) {
        if (from == null) {
            return null;
        }
        Header header = new Header();
        header.schema(this.schemaMapper.mapFrom(from.getModelSpecification(), modelNamesRegistry));
        header.required(from.getRequired());
        header.description(from.getDescription());
        return header;
    }

    @Override
    protected Info mapApiInfo(ApiInfo from) {
        if (from == null) {
            return null;
        }
        Info info = new Info();
        info.license(this.licenseMapper.apiInfoToLicense(from));
        info.extensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        info.termsOfService(from.getTermsOfServiceUrl());
        info.contact(this.map(from.getContact()));
        info.title(from.getTitle());
        info.description(from.getDescription());
        info.version(from.getVersion());
        return info;
    }

    @Override
    protected io.swagger.v3.oas.models.info.Contact map(Contact from) {
        if (from == null) {
            return null;
        }
        io.swagger.v3.oas.models.info.Contact contact = new io.swagger.v3.oas.models.info.Contact();
        contact.name(from.getName());
        contact.url(from.getUrl());
        contact.email(from.getEmail());
        return contact;
    }

    @Override
    protected Tag mapTag(springfox.documentation.service.Tag from) {
        if (from == null) {
            return null;
        }
        Tag tag = new Tag();
        tag.extensions(this.vendorExtensionsMapper.mapExtensions(from.getVendorExtensions()));
        tag.name(from.getName());
        tag.description(from.getDescription());
        return tag;
    }

    @Override
    protected io.swagger.v3.oas.models.servers.Server mapServer(Server from) {
        if (from == null) {
            return null;
        }
        io.swagger.v3.oas.models.servers.Server server = new io.swagger.v3.oas.models.servers.Server();
        server.extensions(this.vendorExtensionsMapper.mapExtensions(from.getExtensions()));
        server.url(from.getUrl());
        server.description(from.getDescription());
        server.variables(this.serverVariableMap(from.getVariables()));
        return server;
    }

    @Override
    protected io.swagger.v3.oas.models.servers.ServerVariable mapServerVariable(ServerVariable from) {
        if (from == null) {
            return null;
        }
        io.swagger.v3.oas.models.servers.ServerVariable serverVariable = new io.swagger.v3.oas.models.servers.ServerVariable();
        serverVariable.setDefault(from.getDefaultValue());
        List<String> list = from.getAllowedValues();
        if (list != null) {
            serverVariable.setEnum(new ArrayList<String>(list));
        }
        serverVariable.description(from.getDescription());
        serverVariable.extensions(this.vendorExtensionsMapper.mapExtensions(from.getExtensions()));
        return serverVariable;
    }

    @Override
    protected ExternalDocumentation mapExternalDocs(springfox.documentation.common.ExternalDocumentation from) {
        if (from == null) {
            return null;
        }
        ExternalDocumentation externalDocumentation = new ExternalDocumentation();
        externalDocumentation.description(from.getDescription());
        externalDocumentation.url(from.getUrl());
        externalDocumentation.extensions(this.vendorExtensionsMapper.mapExtensions(from.getExtensions()));
        return externalDocumentation;
    }

    protected void resourceListingToComponents(ResourceListing resourceListing, Components mappingTarget) {
        if (resourceListing == null) {
            return;
        }
        if (mappingTarget.getSecuritySchemes() != null) {
            Map<String, SecurityScheme> map = this.securitySchemeMapper.map(resourceListing.getSecuritySchemes());
            if (map != null) {
                mappingTarget.getSecuritySchemes().clear();
                mappingTarget.getSecuritySchemes().putAll(map);
            } else {
                mappingTarget.securitySchemes(null);
            }
        } else {
            Map<String, SecurityScheme> map = this.securitySchemeMapper.map(resourceListing.getSecuritySchemes());
            if (map != null) {
                mappingTarget.securitySchemes(map);
            }
        }
    }

    protected void documentationToComponents(Documentation documentation, Components mappingTarget) {
        if (documentation == null) {
            return;
        }
        if (mappingTarget.getSchemas() != null) {
            Map<String, Schema> map = this.schemaMapper.modelsFromApiListings(documentation.getApiListings());
            if (map != null) {
                mappingTarget.getSchemas().clear();
                mappingTarget.getSchemas().putAll(map);
            } else {
                mappingTarget.schemas(null);
            }
        } else {
            Map<String, Schema> map = this.schemaMapper.modelsFromApiListings(documentation.getApiListings());
            if (map != null) {
                mappingTarget.schemas(map);
            }
        }
    }

    private ApiInfo fromResourceListingInfo(Documentation documentation) {
        if (documentation == null) {
            return null;
        }
        ResourceListing resourceListing = documentation.getResourceListing();
        if (resourceListing == null) {
            return null;
        }
        ApiInfo info = resourceListing.getInfo();
        if (info == null) {
            return null;
        }
        return info;
    }

    protected List<io.swagger.v3.oas.models.servers.Server> serverListToServerList(List<Server> list) {
        if (list == null) {
            return null;
        }
        ArrayList<io.swagger.v3.oas.models.servers.Server> list1 = new ArrayList<io.swagger.v3.oas.models.servers.Server>(list.size());
        for (Server server : list) {
            list1.add(this.mapServer(server));
        }
        return list1;
    }

    protected List<Tag> tagSetToTagList(Set<springfox.documentation.service.Tag> set) {
        if (set == null) {
            return null;
        }
        ArrayList<Tag> list = new ArrayList<Tag>(set.size());
        for (springfox.documentation.service.Tag tag : set) {
            list.add(this.mapTag(tag));
        }
        return list;
    }

    protected List<Parameter> requestParameterSortedSetToParameterList(SortedSet<RequestParameter> sortedSet, ModelNamesRegistry modelNamesRegistry) {
        if (sortedSet == null) {
            return null;
        }
        ArrayList<Parameter> list = new ArrayList<Parameter>(sortedSet.size());
        for (RequestParameter requestParameter : sortedSet) {
            list.add(this.mapParameter(requestParameter, modelNamesRegistry));
        }
        return list;
    }

    private Optional<SimpleParameterSpecification> fromParameterSpecificationQuery(RequestParameter requestParameter) {
        if (requestParameter == null) {
            return null;
        }
        ParameterSpecification parameterSpecification = requestParameter.getParameterSpecification();
        if (parameterSpecification == null) {
            return null;
        }
        Optional<SimpleParameterSpecification> query = parameterSpecification.getQuery();
        if (query == null) {
            return null;
        }
        return query;
    }

    private String fromInIn(RequestParameter requestParameter) {
        if (requestParameter == null) {
            return null;
        }
        ParameterType in = requestParameter.getIn();
        if (in == null) {
            return null;
        }
        String in1 = in.getIn();
        if (in1 == null) {
            return null;
        }
        return in1;
    }

    private List<VendorExtension> eachModelFacetExtensions(Representation representation) {
        if (representation == null) {
            return null;
        }
        ModelSpecification model = representation.getModel();
        if (model == null) {
            return null;
        }
        List<VendorExtension> facetExtensions = model.getFacetExtensions();
        if (facetExtensions == null) {
            return null;
        }
        return facetExtensions;
    }
}

