/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import springfox.documentation.spi.schema.UniqueTypeNameAdapter;

public class TypeNameIndexingAdapter
implements UniqueTypeNameAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeNameIndexingAdapter.class);
    private final Map<String, String> knownNames = new HashMap<String, String>();

    @Override
    public Map<String, String> getNames() {
        return Collections.unmodifiableMap(this.knownNames);
    }

    @Override
    public Optional<String> getTypeName(String typeId) {
        return Optional.ofNullable(this.knownNames.get(typeId));
    }

    private boolean checkTypeRegistration(String typeName, String typeId) {
        if (this.knownNames.containsKey(typeId)) {
            if (!this.knownNames.get(typeId).equals(typeName)) {
                LOGGER.debug("Rewriting type {} with model id: {} is not allowed, because it is already registered", (Object)typeName, (Object)typeId);
                throw new IllegalStateException("Model already registered with different name.");
            }
            return true;
        }
        return false;
    }

    @Override
    public void registerType(String typeName, String typeId) {
        if (this.checkTypeRegistration(typeName, typeId)) {
            return;
        }
        this.knownNames.put(typeId, typeName);
    }

    @Override
    public void registerUniqueType(String typeName, String typeId) {
        if (this.checkTypeRegistration(typeName, typeId)) {
            return;
        }
        Integer nameIndex = 0;
        String tempName = typeName;
        while (this.knownNames.values().contains(tempName)) {
            nameIndex = nameIndex + 1;
            tempName = typeName + "_" + nameIndex;
        }
        this.knownNames.put(typeId, tempName);
    }

    @Override
    public void setEqualityFor(String typeIdOf, String typeIdTo) {
        if (!this.knownNames.containsKey(typeIdTo)) {
            LOGGER.warn("Model with model id: {} was not found, because it is not registered", (Object)typeIdTo);
            throw new IllegalStateException("Model was not found");
        }
        if (this.knownNames.containsKey(typeIdOf) && !this.knownNames.get(typeIdOf).equals(this.knownNames.get(typeIdTo))) {
            LOGGER.warn("Model with model id: {} already has equality to other model", (Object)typeIdTo);
            throw new IllegalStateException("Model already has equality to other model");
        }
        this.knownNames.put(typeIdOf, this.knownNames.get(typeIdTo));
    }
}

