/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.configure;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.bulkhead.annotation.Bulkhead;
import io.github.resilience4j.bulkhead.configure.BulkheadAspectExt;
import io.github.resilience4j.bulkhead.configure.BulkheadConfigurationProperties;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.fallback.FallbackMethod;
import io.github.resilience4j.spelresolver.SpelResolver;
import io.github.resilience4j.utils.AnnotationExtractor;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

@Aspect
public class BulkheadAspect
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(BulkheadAspect.class);
    private final BulkheadConfigurationProperties bulkheadConfigurationProperties;
    private final BulkheadRegistry bulkheadRegistry;
    private final ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry;
    @Nullable
    private final List<BulkheadAspectExt> bulkheadAspectExts;
    private final FallbackDecorators fallbackDecorators;
    private final SpelResolver spelResolver;

    public BulkheadAspect(BulkheadConfigurationProperties backendMonitorPropertiesRegistry, ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry, BulkheadRegistry bulkheadRegistry, @Autowired(required=false) List<BulkheadAspectExt> bulkheadAspectExts, FallbackDecorators fallbackDecorators, SpelResolver spelResolver) {
        this.bulkheadConfigurationProperties = backendMonitorPropertiesRegistry;
        this.bulkheadRegistry = bulkheadRegistry;
        this.bulkheadAspectExts = bulkheadAspectExts;
        this.fallbackDecorators = fallbackDecorators;
        this.threadPoolBulkheadRegistry = threadPoolBulkheadRegistry;
        this.spelResolver = spelResolver;
    }

    @Pointcut(value="@within(Bulkhead) || @annotation(Bulkhead)", argNames="Bulkhead")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.bulkhead.annotation.Bulkhead Bulkhead2) {
    }

    @Around(value="matchAnnotatedClassOrMethod(bulkheadAnnotation)", argNames="proceedingJoinPoint, bulkheadAnnotation")
    public Object bulkheadAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, @Nullable io.github.resilience4j.bulkhead.annotation.Bulkhead bulkheadAnnotation) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (bulkheadAnnotation == null) {
            bulkheadAnnotation = this.getBulkheadAnnotation(proceedingJoinPoint);
        }
        if (bulkheadAnnotation == null) {
            return proceedingJoinPoint.proceed();
        }
        Class<?> returnType = method.getReturnType();
        String backend = this.spelResolver.resolve(method, proceedingJoinPoint.getArgs(), bulkheadAnnotation.name());
        String fallbackMethodValue = this.spelResolver.resolve(method, proceedingJoinPoint.getArgs(), bulkheadAnnotation.fallbackMethod());
        if (bulkheadAnnotation.type() == Bulkhead.Type.THREADPOOL) {
            if (StringUtils.isEmpty((Object)fallbackMethodValue)) {
                return this.proceedInThreadPoolBulkhead(proceedingJoinPoint, methodName, returnType, backend);
            }
            return this.executeFallBack(proceedingJoinPoint, fallbackMethodValue, method, (CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> this.proceedInThreadPoolBulkhead(proceedingJoinPoint, methodName, returnType, backend));
        }
        Bulkhead bulkhead = this.getOrCreateBulkhead(methodName, backend);
        if (StringUtils.isEmpty((Object)fallbackMethodValue)) {
            return this.proceed(proceedingJoinPoint, methodName, bulkhead, returnType);
        }
        return this.executeFallBack(proceedingJoinPoint, fallbackMethodValue, method, (CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> this.proceed(proceedingJoinPoint, methodName, bulkhead, returnType));
    }

    private Object executeFallBack(ProceedingJoinPoint proceedingJoinPoint, String fallBackMethod, Method method, CheckedFunction0<Object> bulkhead) throws Throwable {
        FallbackMethod fallbackMethod = FallbackMethod.create(fallBackMethod, method, proceedingJoinPoint.getArgs(), proceedingJoinPoint.getTarget());
        return this.fallbackDecorators.decorate(fallbackMethod, bulkhead).apply();
    }

    private Object proceed(ProceedingJoinPoint proceedingJoinPoint, String methodName, Bulkhead bulkhead, Class<?> returnType) throws Throwable {
        if (this.bulkheadAspectExts != null && !this.bulkheadAspectExts.isEmpty()) {
            for (BulkheadAspectExt bulkHeadAspectExt : this.bulkheadAspectExts) {
                if (!bulkHeadAspectExt.canHandleReturnType(returnType)) continue;
                return bulkHeadAspectExt.handle(proceedingJoinPoint, bulkhead, methodName);
            }
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, bulkhead);
        }
        return this.handleJoinPoint(proceedingJoinPoint, bulkhead);
    }

    private Bulkhead getOrCreateBulkhead(String methodName, String backend) {
        Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(backend);
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved bulkhead '{}' with max concurrent call '{}' and max wait time '{}ms' for method: '{}'", new Object[]{backend, bulkhead.getBulkheadConfig().getMaxConcurrentCalls(), bulkhead.getBulkheadConfig().getMaxWaitDuration().toMillis(), methodName});
        }
        return bulkhead;
    }

    @Nullable
    private io.github.resilience4j.bulkhead.annotation.Bulkhead getBulkheadAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug("bulkhead parameter is null");
        }
        if (proceedingJoinPoint.getTarget() instanceof Proxy) {
            logger.debug("The bulkhead annotation is kept on a interface which is acting as a proxy");
            return AnnotationExtractor.extractAnnotationFromProxy(proceedingJoinPoint.getTarget(), io.github.resilience4j.bulkhead.annotation.Bulkhead.class);
        }
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.bulkhead.annotation.Bulkhead.class);
    }

    private Object handleJoinPoint(ProceedingJoinPoint proceedingJoinPoint, Bulkhead bulkhead) throws Throwable {
        return bulkhead.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, Bulkhead bulkhead) {
        return bulkhead.executeCompletionStage(() -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        });
    }

    private Object proceedInThreadPoolBulkhead(ProceedingJoinPoint proceedingJoinPoint, String methodName, Class<?> returnType, String backend) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("ThreadPool bulkhead invocation for method {} in backend {}", (Object)methodName, (Object)backend);
        }
        ThreadPoolBulkhead threadPoolBulkhead = this.threadPoolBulkheadRegistry.bulkhead(backend);
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            try {
                return threadPoolBulkhead.executeSupplier(() -> {
                    try {
                        return ((CompletionStage)proceedingJoinPoint.proceed()).toCompletableFuture().get();
                    }
                    catch (ExecutionException e) {
                        throw new CompletionException(e.getCause());
                    }
                    catch (Throwable e) {
                        throw new CompletionException(e);
                    }
                });
            }
            catch (BulkheadFullException ex) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(ex);
                return future;
            }
        }
        throw new IllegalStateException("ThreadPool bulkhead is only applicable for completable futures ");
    }

    public int getOrder() {
        return this.bulkheadConfigurationProperties.getBulkheadAspectOrder();
    }
}

