/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.aspect;

import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.util.concurrent.RateLimiter;
import org.apache.kylin.rest.aspect.EnableRateLimit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RateLimitAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitAspect.class);
    private Map<String, RateLimiter> limitMap = Maps.newConcurrentMap();

    @Pointcut(value="@annotation(enableRateLimit)")
    public void callAt(EnableRateLimit enableRateLimit) {
    }

    @Around(value="callAt(enableRateLimit)")
    public void around(ProceedingJoinPoint joinPoint, EnableRateLimit enableRateLimit) throws Throwable {
        log.info("ratelimit aspect start");
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getDeclaringTypeName() + "." + signature.getName();
        double permitsPerSecond = KylinConfig.getInstanceFromEnv().getRateLimitPermitsPerMinute().longValue();
        this.limitMap.putIfAbsent(methodName, RateLimiter.create((double)(permitsPerSecond / 60.0)));
        RateLimiter limiter = this.limitMap.get(methodName);
        if (limiter.tryAcquire()) {
            joinPoint.proceed();
        }
    }
}

