/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache.memcached;

public class CacheStats {
    private final long getBytes;
    private final long getTime;
    private final long putBytes;
    private final CacheStatsCounter cacheStatsCounter;

    public CacheStats(long getBytes, long getTime, long putBytes, CacheStatsCounter cacheStatsCounter) {
        this.getBytes = getBytes;
        this.getTime = getTime;
        this.putBytes = putBytes;
        this.cacheStatsCounter = cacheStatsCounter;
    }

    public long getNumHits() {
        return this.cacheStatsCounter.numHits;
    }

    public long getNumMisses() {
        return this.cacheStatsCounter.numMisses;
    }

    public long getNumGet() {
        return this.cacheStatsCounter.numHits + this.cacheStatsCounter.numMisses;
    }

    public long getNumGetBytes() {
        return this.getBytes;
    }

    public long getNumPutBytes() {
        return this.putBytes;
    }

    public long getNumPut() {
        return this.cacheStatsCounter.numPut;
    }

    public long getNumEvictions() {
        return this.cacheStatsCounter.numEvictions;
    }

    public long getNumTimeouts() {
        return this.cacheStatsCounter.numTimeouts;
    }

    public long getNumErrors() {
        return this.cacheStatsCounter.numErrors;
    }

    public long numLookups() {
        return this.cacheStatsCounter.numHits + this.cacheStatsCounter.numMisses;
    }

    public double hitRate() {
        long lookups = this.numLookups();
        return lookups == 0L ? 0.0 : (double)this.cacheStatsCounter.numHits / (double)lookups;
    }

    public long avgGetBytes() {
        return this.getBytes == 0L ? 0L : this.getBytes / this.numLookups();
    }

    public long getAvgGetTime() {
        return this.getTime / this.numLookups();
    }

    static class CacheStatsCounter {
        final long numHits;
        final long numMisses;
        final long numPut;
        final long numEvictions;
        final long numTimeouts;
        final long numErrors;

        CacheStatsCounter(long numPut, long numHits, long numMisses, long numEvictions, long numTimeouts, long numErrors) {
            this.numPut = numPut;
            this.numHits = numHits;
            this.numMisses = numMisses;
            this.numEvictions = numEvictions;
            this.numTimeouts = numTimeouts;
            this.numErrors = numErrors;
        }
    }
}

