/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.time.Clock;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.helper.MetadataToolHelper;
import org.apache.kylin.tool.HDFSMetadataTool;
import org.springframework.stereotype.Service;

@Service
public class MetadataBackupService {
    private final MetadataToolHelper helper = new MetadataToolHelper();

    public Pair<String, String> backupAll() {
        Pair backupPath = Pair.newPair((Object)"", (Object)"");
        try (SetThreadName ignored = new SetThreadName("MetadataBackupWorker", new Object[0]);){
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            HDFSMetadataTool.cleanBeforeBackup((KylinConfig)kylinConfig);
            KylinConfig backupConfig = kylinConfig.getMetadataBackupFromSystem() ? kylinConfig : KylinConfig.createKylinConfig((KylinConfig)kylinConfig);
            backupPath = this.helper.backup(backupConfig, null, this.getBackupDir(kylinConfig), null, true, false);
            this.helper.rotateAuditLog();
        }
        return backupPath;
    }

    public String backupProject(String project) throws Exception {
        String folder = LocalDateTime.now(Clock.systemDefaultZone()).format(MetadataToolHelper.DATE_TIME_FORMATTER) + "_backup";
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        HDFSMetadataTool.cleanBeforeBackup((KylinConfig)kylinConfig);
        KylinConfig backupConfig = kylinConfig.getMetadataBackupFromSystem() ? kylinConfig : KylinConfig.createKylinConfig((KylinConfig)kylinConfig);
        String backupDir = this.getBackupDir(kylinConfig);
        this.helper.backup(backupConfig, project, backupDir, folder, true, false);
        return StringUtils.appendIfMissing((String)backupDir, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + folder;
    }

    private String getBackupDir(KylinConfig kylinConfig) {
        return HadoopUtil.getBackupFolder((KylinConfig)kylinConfig);
    }
}

