/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.session;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.MapSessionRepository;
import org.springframework.session.PrincipalNameIndexResolver;
import org.springframework.session.Session;

public class MapIndexedSessionRepository
extends MapSessionRepository
implements FindByIndexNameSessionRepository<MapSession> {
    private static PrincipalNameIndexResolver nameIndexResolver = new PrincipalNameIndexResolver();
    private Map<String, Map<String, MapSession>> indexesMap;

    public MapIndexedSessionRepository(Map<String, Session> sessions, Map<String, Map<String, MapSession>> indexesMap) {
        super(sessions);
        this.indexesMap = indexesMap;
    }

    public void save(MapSession session) {
        super.save(session);
        String index = nameIndexResolver.resolveIndexValueFor((Session)session);
        if (index != null) {
            Map<String, MapSession> sessionMap = this.indexesMap.get(index);
            if (!session.getId().equals(session.getOriginalId()) && sessionMap != null) {
                sessionMap.remove(session.getOriginalId());
            }
            if (sessionMap == null) {
                sessionMap = new ConcurrentHashMap<String, MapSession>();
                sessionMap.put(session.getId(), this.findById(session.getId()));
                this.indexesMap.put(index, sessionMap);
            } else {
                sessionMap.put(session.getId(), this.findById(session.getId()));
            }
        }
    }

    public void deleteById(String id) {
        super.deleteById(id);
        this.indexesMap.values().forEach(entry -> {
            MapSession cfr_ignored_0 = (MapSession)entry.remove(id);
        });
    }

    public Map<String, MapSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        return this.indexesMap.get(indexValue);
    }

    public Map<String, MapSession> findByPrincipalName(String principalName) {
        return super.findByPrincipalName(principalName);
    }
}

