/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.Model;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;
import org.springframework.http.MediaType;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.MapSpecification;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ScalarModelSpecification;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.schema.StringElementFacet;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.Representation;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.SimpleParameterSpecification;
import springfox.documentation.swagger2.mappers.CollectionSpecificationToPropertyConverter;
import springfox.documentation.swagger2.mappers.EnumMapper;
import springfox.documentation.swagger2.mappers.ModelSpecificationMapper;
import springfox.documentation.swagger2.mappers.PropertyMapper;
import springfox.documentation.swagger2.mappers.ScalarModelToPropertyConverter;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper(componentModel="spring")
public class RequestParameterMapper {
    private static final VendorExtensionsMapper VENDOR_EXTENSIONS_MAPPER = new VendorExtensionsMapper();
    private final PropertyMapper propertyMapper = (PropertyMapper)Mappers.getMapper(PropertyMapper.class);

    Collection<Parameter> mapParameter(RequestParameter from, @Context ModelNamesRegistry modelNamesRegistry) {
        CookieParameter parameter;
        ParameterSpecification parameterSpecification = from.getParameterSpecification();
        Optional query = parameterSpecification.getQuery();
        if (query.isPresent()) {
            switch (from.getIn()) {
                case COOKIE: {
                    parameter = new CookieParameter();
                    break;
                }
                case HEADER: {
                    parameter = new HeaderParameter();
                    break;
                }
                case PATH: {
                    parameter = new PathParameter();
                    break;
                }
                default: {
                    parameter = new QueryParameter();
                }
            }
            SimpleParameterSpecification paramSpecification = (SimpleParameterSpecification)query.get();
            ((AbstractSerializableParameter)parameter).setDefaultValue(paramSpecification.getDefaultValue());
            ((AbstractSerializableParameter)parameter).setAllowEmptyValue((Boolean)query.map(SimpleParameterSpecification::getAllowEmptyValue).orElse(null));
            parameter.setName(from.getName());
            parameter.setDescription(from.getDescription());
            CookieParameter finalParameter = parameter;
            paramSpecification.facetOfType(StringElementFacet.class).ifPresent(arg_0 -> RequestParameterMapper.lambda$mapParameter$0((Parameter)finalParameter, arg_0));
            parameter.setRequired(from.getRequired().booleanValue());
            parameter.getVendorExtensions().putAll(VENDOR_EXTENSIONS_MAPPER.mapExtensions(from.getExtensions()));
            query.ifPresent(arg_0 -> RequestParameterMapper.lambda$mapParameter$1((Parameter)finalParameter, arg_0));
            if (paramSpecification.getModel() == null) {
                ((AbstractSerializableParameter)parameter).setType(ScalarType.STRING.getType());
            } else {
                Optional collection = paramSpecification.getModel().getCollection();
                if (collection.isPresent()) {
                    if (((CollectionSpecification)collection.get()).getModel().getScalar().map(ScalarModelSpecification::getType).orElse(null) == ScalarType.BYTE) {
                        ((AbstractSerializableParameter)parameter).setType(ScalarType.BYTE.getType());
                        ((AbstractSerializableParameter)parameter).setFormat(ScalarType.BYTE.getFormat());
                    } else {
                        ((AbstractSerializableParameter)parameter).setCollectionFormat(((SimpleParameterSpecification)query.get()).getCollectionFormat().getType());
                        ((AbstractSerializableParameter)parameter).setType("array");
                        paramSpecification.getModel().getCollection().map(CollectionSpecification::getModel).ifPresent(arg_0 -> this.lambda$mapParameter$2(modelNamesRegistry, (Parameter)finalParameter, arg_0));
                    }
                } else if (paramSpecification.getModel().getMap().isPresent()) {
                    ModelSpecification value = ((MapSpecification)paramSpecification.getModel().getMap().get()).getValue();
                    Property itemProperty = this.propertyMapper.fromModel(value, modelNamesRegistry);
                    MapProperty mapProperty = new MapProperty(itemProperty);
                    ((AbstractSerializableParameter)parameter).setItems((Property)mapProperty);
                } else {
                    ((AbstractSerializableParameter)parameter).setDefaultValue(paramSpecification.getDefaultValue());
                    if (from.getScalarExample() != null) {
                        ((AbstractSerializableParameter)parameter).setExample(String.valueOf(from.getScalarExample()));
                    }
                    query.map(SimpleParameterSpecification::getModel).flatMap(ModelSpecification::getScalar).ifPresent(arg_0 -> RequestParameterMapper.lambda$mapParameter$3((Parameter)finalParameter, arg_0));
                }
            }
        } else {
            if (from.getIn() == ParameterType.FORMDATA) {
                boolean isMultipartForm = from.getParameterSpecification().getContent().map(c -> c.getRepresentations().stream().anyMatch(r -> r.getMediaType().equals((Object)MediaType.MULTIPART_MIXED) || r.getMediaType().equals((Object)MediaType.MULTIPART_FORM_DATA))).orElse(false);
                if (isMultipartForm) {
                    return this.multipartFormParameters(from, modelNamesRegistry);
                }
                return this.formParameter(from, modelNamesRegistry);
            }
            boolean isUrlEncodedForm = from.getParameterSpecification().getContent().map(c -> c.getRepresentations().stream().anyMatch(r -> r.getMediaType().equals((Object)MediaType.APPLICATION_FORM_URLENCODED))).orElse(false);
            if (isUrlEncodedForm) {
                return this.formParameter(from, modelNamesRegistry);
            }
            parameter = this.bodyParameter(from, modelNamesRegistry);
        }
        return Collections.singleton(parameter);
    }

    private Collection<Parameter> multipartFormParameters(RequestParameter from, ModelNamesRegistry namesRegistry) {
        return from.getParameterSpecification().getContent().map(c -> c.getRepresentations().stream().filter(r -> r.getMediaType().equals((Object)MediaType.MULTIPART_MIXED) || r.getMediaType().equals((Object)MediaType.MULTIPART_FORM_DATA)).flatMap(r -> ((Collection)r.getModel().getCompound().map(CompoundModelSpecification::getProperties).orElse(new ArrayList())).stream()).filter(prop -> prop.getType().getScalar().isPresent() || prop.getType().getCollection().isPresent() && ((CollectionSpecification)prop.getType().getCollection().get()).getModel().getScalar().isPresent()).map(prop -> {
            FormParameter param = (FormParameter)new FormParameter().name(prop.getName());
            prop.getType().getScalar().ifPresent(scalar -> param.property(new ScalarModelToPropertyConverter().convert((ScalarModelSpecification)scalar)));
            prop.getType().getFacets().flatMap(mf -> mf.elementFacet(StringElementFacet.class)).ifPresent(sf -> param.setPattern(sf.getPattern()));
            prop.getType().getCollection().ifPresent(collection -> {
                Property collectionProperty = new CollectionSpecificationToPropertyConverter(namesRegistry).convert((CollectionSpecification)collection);
                param.property(collectionProperty);
            });
            param.setAllowEmptyValue(prop.getAllowEmptyValue());
            param.setDefault(prop.getDefaultValue());
            param.setIn("formData");
            param.setRequired(from.getRequired().booleanValue());
            param.getVendorExtensions().putAll(VENDOR_EXTENSIONS_MAPPER.mapExtensions(from.getExtensions()));
            if (from.getScalarExample() != null) {
                param.setExample(String.valueOf(from.getScalarExample()));
            }
            for (Example example : from.getExamples()) {
                if (example.getValue() == null) continue;
                param.example(String.valueOf(example.getValue()));
                break;
            }
            return param;
        })).orElse(Stream.of(new FormParameter[0])).collect(Collectors.toList());
    }

    private List<Parameter> formParameter(RequestParameter source, ModelNamesRegistry namesRegistry) {
        return source.getParameterSpecification().getContent().map(c -> c.getRepresentations().stream().filter(r -> r.getMediaType().equals((Object)MediaType.APPLICATION_FORM_URLENCODED)).flatMap(r -> ((Collection)r.getModel().getCompound().map(CompoundModelSpecification::getProperties).orElse(new ArrayList())).stream()).filter(prop -> prop.getType().getScalar().isPresent() || prop.getType().getCollection().isPresent() && ((CollectionSpecification)prop.getType().getCollection().get()).getModel().getScalar().isPresent()).map(prop -> {
            FormParameter param = (FormParameter)((FormParameter)new FormParameter().description(source.getDescription())).name(prop.getName());
            prop.getType().getScalar().ifPresent(scalar -> param.property(new ScalarModelToPropertyConverter().convert((ScalarModelSpecification)scalar)));
            prop.getType().getFacets().flatMap(mf -> mf.elementFacet(StringElementFacet.class)).ifPresent(sf -> param.setPattern(sf.getPattern()));
            prop.getType().getCollection().ifPresent(collection -> {
                Property collectionProperty = new CollectionSpecificationToPropertyConverter(namesRegistry).convert((CollectionSpecification)collection);
                param.property(collectionProperty);
            });
            param.setAllowEmptyValue(prop.getAllowEmptyValue());
            param.setDefault(prop.getDefaultValue());
            param.setIn("formData");
            param.setRequired(source.getRequired().booleanValue());
            param.getVendorExtensions().putAll(VENDOR_EXTENSIONS_MAPPER.mapExtensions(source.getExtensions()));
            if (source.getScalarExample() != null) {
                param.setExample(String.valueOf(source.getScalarExample()));
            }
            for (Example example : source.getExamples()) {
                if (example.getValue() == null) continue;
                param.example(String.valueOf(example.getValue()));
                break;
            }
            return param;
        })).orElse(Stream.of(new FormParameter[0])).collect(Collectors.toList());
    }

    private Parameter bodyParameter(RequestParameter source, ModelNamesRegistry namesRegistry) {
        Model schema = this.toSchema(source, namesRegistry);
        if (schema != null && source.getScalarExample() != null) {
            schema.setExample((Object)String.valueOf(source.getScalarExample().getValue()));
        }
        BodyParameter parameter = new BodyParameter().description(source.getDescription()).name(source.getName()).schema(schema);
        parameter.setIn(source.getIn().getIn());
        parameter.setRequired(source.getRequired().booleanValue());
        parameter.getVendorExtensions().putAll(VENDOR_EXTENSIONS_MAPPER.mapExtensions(source.getExtensions()));
        for (Example example : source.getExamples()) {
            if (example.getValue() == null) continue;
            parameter.example(example.getMediaType().orElse("default"), String.valueOf(example.getValue()));
            break;
        }
        return parameter;
    }

    private Model toSchema(RequestParameter source, ModelNamesRegistry namesRegistry) {
        return source.getParameterSpecification().getContent().map(c -> ((ModelSpecificationMapper)Mappers.getMapper(ModelSpecificationMapper.class)).mapModels((ModelSpecification)c.getRepresentations().stream().findFirst().map(Representation::getModel).orElse(null), namesRegistry)).orElse(null);
    }

    private static /* synthetic */ void lambda$mapParameter$3(Parameter finalParameter, ScalarModelSpecification scalar) {
        Property property = new ScalarModelToPropertyConverter().convert(scalar);
        ((AbstractSerializableParameter)finalParameter).setType(property.getType());
        ((AbstractSerializableParameter)finalParameter).setFormat(property.getFormat());
    }

    private /* synthetic */ void lambda$mapParameter$2(ModelNamesRegistry modelNamesRegistry, Parameter finalParameter, ModelSpecification model) {
        Property property = this.propertyMapper.fromModel(model, modelNamesRegistry);
        Property itemProperty = EnumMapper.maybeAddFacets(property, model.getFacets().orElse(null));
        ((AbstractSerializableParameter)finalParameter).setItems(itemProperty);
        EnumMapper.maybeAddFacets(itemProperty, model.getFacets().orElse(null));
    }

    private static /* synthetic */ void lambda$mapParameter$1(Parameter finalParameter, SimpleParameterSpecification q) {
        EnumMapper.maybeAddAllowableValuesToParameter((SerializableParameter)((AbstractSerializableParameter)finalParameter), q);
    }

    private static /* synthetic */ void lambda$mapParameter$0(Parameter finalParameter, StringElementFacet sf) {
        finalParameter.setPattern(sf.getPattern());
    }
}

