/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/admin"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class NAdminController
extends NBasicController {
    @ApiOperation(value="getPublicConfig", tags={"MID"}, notes="Update Param: project_name")
    @GetMapping(value={"/public_config"})
    @ResponseBody
    public EnvelopeResponse<String> getPublicConfig() throws IOException {
        String whiteListProperties = KylinConfig.getInstanceFromEnv().getPropertiesWhiteList();
        ArrayList propertyKeys = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)whiteListProperties)) {
            propertyKeys.addAll(Arrays.asList(whiteListProperties.split(",")));
        }
        propertyKeys.add("kylin.env.smart-mode-enabled");
        propertyKeys.add("kylin.source.load-hive-tablename-enabled");
        propertyKeys.add("kylin.kerberos.project-level-enabled");
        propertyKeys.add("kylin.web.stack-trace.enabled");
        propertyKeys.add("kylin.metadata.random-admin-password.enabled");
        propertyKeys.add("kylin.model.recommendation-page-size");
        propertyKeys.add("kylin.model.dimension-measure-name.max-length");
        propertyKeys.add("kylin.favorite.import-sql-max-size");
        propertyKeys.add("kylin.model.suggest-model-sql-limit");
        propertyKeys.add("kylin.query.query-history-download-max-size");
        propertyKeys.add("kylin.model.measure-name-check-enabled");
        propertyKeys.add("kylin.security.remove-ldap-custom-security-limit-enabled");
        propertyKeys.add("kylin.source.ddl.logical-view.enabled");
        propertyKeys.add("kylin.source.ddl.hive.enabled");
        propertyKeys.add("kylin.source.ddl.logical-view.database");
        propertyKeys.add("kylin.storage.check-quota-enabled");
        propertyKeys.add("kylin.table.load-threshold-enabled");
        propertyKeys.add("kylin.index.enable-operator-design");
        if (!KylinConfig.getInstanceFromEnv().isAllowedNonAdminGenerateQueryDiagPackage()) {
            propertyKeys.add("kylin.security.allow-non-admin-generate-query-diag-package");
        }
        String config = KylinConfig.getInstanceFromEnv().exportToString((Collection)propertyKeys) + this.addPropertyWithKylinInfoCheck() + this.addPropertyInMetadata();
        return new EnvelopeResponse("000", (Object)config, "");
    }

    @ApiOperation(value="health APIs", tags={"SM"})
    @GetMapping(value={"/instance_info"})
    @ResponseBody
    public EnvelopeResponse<Map<String, String>> getInstanceConfig() {
        HashMap data = Maps.newHashMap();
        ZoneId zoneId = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getTimeZone()).toZoneId();
        data.put("instance.timezone", zoneId.toString());
        return new EnvelopeResponse("000", (Object)data, "");
    }

    private String addPropertyInMetadata() {
        Properties properties = new Properties();
        ResourceGroupManager manager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        properties.put("resource_group_enabled", (Object)manager.isResourceGroupEnabled());
        return this.getPropertyString(properties);
    }

    private String getPropertyString(Properties properties) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    private String addPropertyWithKylinInfoCheck() {
        Properties properties = new Properties();
        properties.put("kylin.streaming.enabled", (Object)KylinConfig.getInstanceFromEnv().isStreamingEnabled());
        return this.getPropertyString(properties);
    }
}

