/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupManager;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.metadata.streaming.KafkaConfigManager;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.exception.UnauthorizedException;
import org.apache.kylin.rest.request.Validation;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ErrorResponse;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.PagingUtil;
import org.apache.kylin.util.DataRangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public class NBasicController {
    private static final Logger logger = LoggerFactory.getLogger(NBasicController.class);
    public static final int MAX_NAME_LENGTH = 50;
    public static final long FIVE_MINUTE_MILLISECOND = TimeUnit.MINUTES.toMillis(5L);
    public static final long THIRTY_DAYS_MILLISECOND = TimeUnit.DAYS.toMillis(30L);
    @Autowired
    @Qualifier(value="normalRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private ProjectService projectService;
    @Autowired
    protected UserService userService;
    @Autowired
    protected ClusterManager clusterManager;

    protected Logger getLogger() {
        return logger;
    }

    public ProjectInstance getProject(String project) {
        List projectInstanceList;
        if (null != project && CollectionUtils.isNotEmpty((Collection)(projectInstanceList = this.projectService.getReadableProjects(project, true)))) {
            return (ProjectInstance)projectInstanceList.get(0);
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    ErrorResponse handleError(HttpServletRequest req, Throwable ex) {
        Throwable cause;
        this.getLogger().error("", ex);
        Message msg = MsgPicker.getMsg();
        KylinException kylinException = null;
        for (cause = ex; cause != null && cause.getCause() != null; cause = cause.getCause()) {
            if (cause instanceof CannotCreateTransactionException) {
                kylinException = new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CONNECT_CATALOG, msg.getConnectDatabaseError(), false);
            }
            if (cause instanceof InvalidPropertyException && cause.getCause() instanceof IndexOutOfBoundsException) {
                kylinException = new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_DATA_BINDER_AUTO_GROW_COLLECTION_LIMIT, msg.getInvalidDataBinderAutoGrowCollectionLimit(), false);
            }
            if (!(cause instanceof KylinException)) continue;
            kylinException = (KylinException)cause;
        }
        if (kylinException != null) {
            cause = kylinException;
        }
        return new ErrorResponse(req.getRequestURL().toString(), cause);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={ForbiddenException.class})
    @ResponseBody
    ErrorResponse handleForbidden(HttpServletRequest req, Exception ex) {
        this.getLogger().error("", (Throwable)ex);
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)ex);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundException.class})
    @ResponseBody
    ErrorResponse handleNotFound(HttpServletRequest req, Exception ex) {
        this.getLogger().error("", (Throwable)ex);
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)ex);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={TransactionException.class})
    @ResponseBody
    ErrorResponse handleTransaction(HttpServletRequest req, Throwable ex) {
        Throwable root;
        this.getLogger().error("", ex);
        Throwable throwable = root = ExceptionUtils.getRootCause((Throwable)ex) == null ? ex : ExceptionUtils.getRootCause((Throwable)ex);
        if (root instanceof AccessDeniedException) {
            return this.handleAccessDenied(req, root);
        }
        if (root instanceof KylinException) {
            return this.handleErrorCode(req, root);
        }
        return this.handleError(req, ex);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    ErrorResponse handleAccessDenied(HttpServletRequest req, Throwable ex) {
        this.getLogger().error("", ex);
        KylinException e = new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, MsgPicker.getMsg().getAccessDeny());
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, MissingServletRequestParameterException.class, IllegalArgumentException.class})
    @ResponseBody
    ErrorResponse handleInvalidRequestParam(HttpServletRequest req, Throwable ex) {
        KylinException e = new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, ex);
        this.getLogger().error("", (Throwable)e);
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={KylinException.class})
    @ResponseBody
    ErrorResponse handleErrorCode(HttpServletRequest req, Throwable ex) {
        this.getLogger().error("", ex);
        KylinException cause = (KylinException)ex;
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)cause);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    ErrorResponse handleInvalidArgument(HttpServletRequest request, MethodArgumentNotValidException ex) {
        ErrorResponse response = new ErrorResponse(request.getRequestURL().toString(), (Throwable)ex);
        Object target = ex.getBindingResult().getTarget();
        if (target instanceof Validation) {
            response.setMsg(((Validation)target).getErrorMessage(ex.getBindingResult().getFieldErrors()));
        } else {
            response.setMsg(ex.getBindingResult().getFieldErrors().stream().map(e -> e.getField() + ":" + e.getDefaultMessage()).collect(Collectors.joining(",")));
        }
        return response;
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseBody
    ErrorResponse handleUnauthorized(HttpServletRequest req, Throwable ex) {
        KylinException e = new KylinException((ErrorCodeProducer)ErrorCodeServer.USER_UNAUTHORIZED, ex, new Object[0]);
        this.getLogger().error("", (Throwable)e);
        return new ErrorResponse(req.getRequestURL().toString(), ex);
    }

    protected void checkRequiredArg(String fieldName, Object fieldValue) {
        if (fieldValue == null || StringUtils.isEmpty((CharSequence)String.valueOf(fieldValue))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{fieldName});
        }
    }

    protected void checkListRequiredArg(String fieldName, Collection<?> fieldValue) {
        if (CollectionUtils.isEmpty(fieldValue)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{fieldName});
        }
    }

    public String makeUserNameCaseInSentive(String userName) {
        UserDetails userDetails = this.userService.loadUserByUsername(userName);
        if (userDetails == null) {
            return userName;
        }
        return userDetails.getUsername();
    }

    public List<String> makeUserNameCaseInSentive(List<String> userNames) {
        if (CollectionUtils.isNotEmpty(userNames)) {
            return userNames.stream().map(this::makeUserNameCaseInSentive).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected void checkNonNegativeIntegerArg(String fieldName, Object fieldValue) {
        this.checkRequiredArg(fieldName, fieldValue);
        try {
            int i = Integer.parseInt(String.valueOf(fieldValue));
            if (i < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.INTEGER_NON_NEGATIVE_CHECK, new Object[]{fieldName});
        }
    }

    protected void checkBooleanArg(String fieldName, Object fieldValue) {
        this.checkRequiredArg(fieldName, fieldValue);
        String booleanString = String.valueOf(fieldValue);
        if (!"true".equalsIgnoreCase(booleanString) && !"false".equalsIgnoreCase(booleanString)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ARGS_TYPE_CHECK, new Object[]{booleanString, "Boolean"});
        }
    }

    protected void setDownloadResponse(File file, String fileName, String contentType, HttpServletResponse response) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.setDownloadResponse(fileInputStream, fileName, contentType, response);
            response.setContentLength((int)file.length());
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, (Throwable)e);
        }
    }

    protected void setDownloadResponse(InputStream inputStream, String fileName, String contentType, HttpServletResponse response) {
        try (ServletOutputStream output = response.getOutputStream();){
            response.reset();
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)output);
            output.flush();
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void setDownloadResponse(String downloadFile, String contentType, HttpServletResponse response) {
        File file = new File(downloadFile);
        this.setDownloadResponse(file, file.getName(), contentType, response);
    }

    public static boolean isAdmin() {
        boolean isAdmin = false;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            for (GrantedAuthority auth : authentication.getAuthorities()) {
                if (!auth.getAuthority().equals("ROLE_ADMIN")) continue;
                isAdmin = true;
                break;
            }
        }
        return isAdmin;
    }

    public Map<String, Object> getDataResponse(String name, List<?> result, int offset, int limit) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(name, PagingUtil.cutPage(result, (int)offset, (int)limit));
        data.put("size", result.size());
        return data;
    }

    public Map<String, Object> setCustomDataResponse(String name, Pair<List<TableDesc>, Integer> result, int offset, int limit) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(name, PagingUtil.cutPage((List)((List)result.getFirst()), (int)offset, (int)limit));
        data.put("size", result.getSecond());
        return data;
    }

    public String getHost(String serverHost, String serverName) {
        String host = KylinConfig.getInstanceFromEnv().getModelExportHost();
        return Optional.ofNullable(Optional.ofNullable(host).orElse(serverHost)).orElse(serverName);
    }

    public int getPort(Integer serverPort, Integer requestServerPort) {
        Integer port = KylinConfig.getInstanceFromEnv().getModelExportPort() == -1 ? null : Integer.valueOf(KylinConfig.getInstanceFromEnv().getModelExportPort());
        return Optional.ofNullable(Optional.ofNullable(port).orElse(serverPort)).orElse(requestServerPort);
    }

    public String checkProjectName(String project) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PROJECT_NAME, MsgPicker.getMsg().getEmptyProjectName());
        }
        return this.getProjectNameFromEnv(project);
    }

    public void checkParamLength(String paramName, Object param, int length) {
        if (param == null) {
            return;
        }
        String paramStr = JsonUtil.writeValueAsString((Object)param);
        if (paramStr.length() * 2 > length) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getParamTooLarge(), paramName, length));
        }
    }

    public static void checkSqlIsNotNull(List<String> rawSqls) {
        if (CollectionUtils.isEmpty(rawSqls)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getSqlListIsEmpty());
        }
    }

    protected void checkSegmentParms(String[] ids, String[] names) {
        if (ArrayUtils.isNotEmpty((Object[])ids) && ArrayUtils.isNotEmpty((Object[])names)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_CONFLICT_PARAMETER, new Object[0]);
        }
        if (ArrayUtils.isEmpty((Object[])ids) && ArrayUtils.isEmpty((Object[])names)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_EMPTY_PARAMETER, new Object[0]);
        }
    }

    public void checkProjectNotSemiAuto(String project) {
        if (!NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).isSemiAutoMode()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INCORRECT_PROJECT_MODE, MsgPicker.getMsg().getProjectUnmodifiableReason());
        }
    }

    public void checkProjectUnmodifiable(String project) {
        if (NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).isExpertMode()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INCORRECT_PROJECT_MODE, MsgPicker.getMsg().getProjectUnmodifiableReason());
        }
    }

    public <T extends Enum> List<String> formatStatus(List<String> status, Class<T> enumClass) {
        if (status == null) {
            return Lists.newArrayList();
        }
        Set enumStrSet = Arrays.stream(enumClass.getEnumConstants()).map(Objects::toString).collect(Collectors.toSet());
        List<String> formattedStatus = status.stream().filter(Objects::nonNull).map(item -> item.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
        List illegalStatus = formattedStatus.stream().filter(item -> !enumStrSet.contains(item)).collect(Collectors.toList());
        if (!illegalStatus.isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"status", "ONLINE, OFFLINE, WARNING, BROKEN"});
        }
        return formattedStatus;
    }

    public static void checkId(String uuid) {
        if (StringUtils.isEmpty((CharSequence)uuid)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_ID, MsgPicker.getMsg().getIdCannotEmpty());
        }
    }

    public static void validatePriority(int priority) {
        if (!ExecutablePO.isPriorityValid((int)priority)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"priority", "0, 1, 2, 3, 4"});
        }
    }

    public void validateRange(String start, String end) {
        this.validateRange(Long.parseLong(start), Long.parseLong(end));
    }

    private void validateRange(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_LESS_THAN_ZERO, new Object[0]);
        }
        if (start >= end) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_END_LESS_THAN_EQUALS_START, new Object[0]);
        }
    }

    public void validateDataRange(String start, String end) {
        long differenceMillisecond;
        DataRangeUtils.validateDataRange((String)start, (String)end, null);
        if (StringUtils.isNotEmpty((CharSequence)start) && StringUtils.isNotEmpty((CharSequence)end) && ((differenceMillisecond = Long.parseLong(end) - Long.parseLong(start)) < FIVE_MINUTE_MILLISECOND || differenceMillisecond > THIRTY_DAYS_MILLISECOND)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_IN_RANGE, new Object[0]);
        }
    }

    public void validateDateTimeFormatPattern(String pattern) {
        if (pattern.isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.DATETIME_FORMAT_EMPTY, new Object[0]);
        }
        try {
            new SimpleDateFormat(pattern, Locale.getDefault(Locale.Category.FORMAT));
        }
        catch (IllegalArgumentException e) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.DATETIME_FORMAT_PARSE_ERROR, (Throwable)e, new Object[]{pattern});
        }
    }

    public void checkStreamingOperation(String project, String table) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        KafkaConfig kafkaConf = KafkaConfigManager.getInstance((KylinConfig)config, (String)project).getKafkaConfig(table);
        if (kafkaConf != null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_STREAMING_OPERATION, MsgPicker.getMsg().getStreamingOperationNotSupport());
        }
    }

    private ResponseEntity<byte[]> getHttpResponse(HttpServletRequest request, String url) throws IOException {
        byte[] body = IOUtils.toByteArray((InputStream)request.getInputStream());
        HttpHeaders headers = new HttpHeaders();
        Collections.list(request.getHeaderNames()).forEach(k -> headers.put(k, Collections.list(request.getHeaders(k))));
        headers.remove((Object)"Accept-Encoding");
        return this.restTemplate.exchange(url, HttpMethod.valueOf((String)request.getMethod()), new HttpEntity((Object)body, (MultiValueMap)headers), byte[].class, new Object[0]);
    }

    public <T> EnvelopeResponse<T> generateTaskForRemoteHost(HttpServletRequest request, String url) throws Exception {
        ResponseEntity<byte[]> response = this.getHttpResponse(request, url);
        return (EnvelopeResponse)JsonUtil.readValue((byte[])((byte[])response.getBody()), EnvelopeResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void downloadFromRemoteHost(HttpServletRequest request, String url, HttpServletResponse servletResponse) throws IOException {
        File temporaryZipFile = KylinConfigBase.getDiagFileName();
        temporaryZipFile.getParentFile().mkdirs();
        Preconditions.checkState((boolean)temporaryZipFile.createNewFile(), (Object)"create temporary zip file failed");
        RequestCallback requestCallback = x -> {
            Collections.list(request.getHeaderNames()).forEach(k -> x.getHeaders().put(k, Collections.list(request.getHeaders(k))));
            x.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL));
            x.getHeaders().remove((Object)"Accept-Encoding");
        };
        ResponseExtractor responseExtractor = x -> {
            try (FileOutputStream fout = new FileOutputStream(temporaryZipFile);){
                StreamUtils.copy((InputStream)x.getBody(), (OutputStream)fout);
            }
            List name = x.getHeaders().get((Object)"Content-Disposition");
            return name == null ? "error" : (String)name.get(0);
        };
        String fileName = (String)this.restTemplate.execute(url, HttpMethod.GET, requestCallback, responseExtractor, new Object[0]);
        try (InputStream in = Files.newInputStream(temporaryZipFile.toPath(), new OpenOption[0]);
             ServletOutputStream out = servletResponse.getOutputStream();){
            servletResponse.reset();
            servletResponse.setContentLengthLong(temporaryZipFile.length());
            servletResponse.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
            servletResponse.setHeader("Content-Disposition", fileName);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
        finally {
            FileUtils.deleteQuietly((File)temporaryZipFile);
        }
    }

    public void checkStreamingEnabled() {
        if (!KylinConfig.getInstanceFromEnv().isStreamingEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_STREAMING_OPERATION, MsgPicker.getMsg().getStreamingDisabled());
        }
    }

    protected void checkSegmentParams(String[] ids, String[] names) {
        if (ArrayUtils.isNotEmpty((Object[])ids) && ArrayUtils.isNotEmpty((Object[])names)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_CONFLICT_PARAMETER, new Object[0]);
        }
        if (ArrayUtils.isEmpty((Object[])ids) && ArrayUtils.isEmpty((Object[])names)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_EMPTY_PARAMETER, new Object[0]);
        }
    }

    public static void checkNotEmpty(List<String> sqls) {
        if (CollectionUtils.isEmpty(sqls)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_SQL_EXPRESSION, MsgPicker.getMsg().getNullEmptySql());
        }
    }

    public String getInsensitiveProject(String project) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            return "";
        }
        return this.getProjectNameFromEnv(project);
    }

    public String getProjectNameFromEnv(String project) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance projectInstance = projectManager.getProject(project);
        if (projectInstance == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        return projectInstance.getName();
    }

    public String getInsensitiveProjectModelName(String project, String modelAlias) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataModel dataModel = modelManager.getDataModelDescByAlias(modelAlias);
        return dataModel != null ? dataModel.getAlias() : modelAlias;
    }

    public void checkStreamingJobsStatus(List<String> statuses) {
        if (CollectionUtils.isEmpty(statuses)) {
            return;
        }
        List<String> streamingJobsStatus = Arrays.asList(JobStatusEnum.STARTING.name(), JobStatusEnum.RUNNING.name(), JobStatusEnum.STOPPING.name(), JobStatusEnum.ERROR.name(), JobStatusEnum.STOPPED.name());
        for (String status : statuses) {
            if (streamingJobsStatus.contains(status)) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"statuses", StringUtils.join(streamingJobsStatus, (String)", ")});
        }
    }

    public void checkStreamingJobTypeStatus(List<String> statuses) {
        if (CollectionUtils.isEmpty(statuses)) {
            return;
        }
        List<String> streamingJobTypeStatus = Arrays.asList(JobTypeEnum.STREAMING_BUILD.name(), JobTypeEnum.STREAMING_MERGE.name());
        for (String status : statuses) {
            if (streamingJobTypeStatus.contains(status)) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"job_types", StringUtils.join(streamingJobTypeStatus, (String)", ")});
        }
    }

    protected void checkCollectionRequiredArg(String fieldName, Collection<?> fieldValue) {
        if (CollectionUtils.isEmpty(fieldValue)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{fieldName});
        }
    }

    public String decodeHost(String host) {
        try {
            if (StringUtils.isBlank((CharSequence)host) || host.startsWith("http://")) {
                return host;
            }
            String decryptValue = EncryptUtil.decrypt((String)new String(Base64.decodeBase64((String)host), Charset.defaultCharset()));
            return StringUtils.isBlank((CharSequence)decryptValue) ? host : decryptValue;
        }
        catch (Exception e) {
            logger.error("Failed to decode host, will use the original host name");
            return host;
        }
    }

    public String encodeHost(String host) {
        try {
            if (StringUtils.isBlank((CharSequence)host)) {
                return host;
            }
            if (!(host = host.trim()).toLowerCase().startsWith("http")) {
                host = "http://" + host;
            }
            return Base64.encodeBase64String((byte[])EncryptUtil.encrypt((String)host).getBytes(Charset.defaultCharset()));
        }
        catch (Exception e) {
            logger.error("Failed to encode host, will use the original host name");
            return host;
        }
    }

    @InitBinder
    private void initBinder(WebDataBinder binder) {
        int autoGrowCollectionLimit = KylinConfig.getInstanceFromEnv().getDataBinderAutoGrowCollectionLimit();
        binder.setAutoGrowCollectionLimit(autoGrowCollectionLimit);
    }

    public void checkServer(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new KylinRuntimeException("Server cannot be null or empty");
        }
        ResourceGroupManager rgManager = ResourceGroupManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        boolean serverNotFoundInCluster = this.clusterManager.checkServer(host);
        if (rgManager.isResourceGroupEnabled()) {
            boolean serverNotFoundInResourceGroup = rgManager.checkServer(host);
            if (serverNotFoundInCluster && serverNotFoundInResourceGroup) {
                throw new KylinRuntimeException(String.format(Locale.ROOT, "Server <%s> not found", host));
            }
        } else if (serverNotFoundInCluster) {
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Server <%s> not found", host));
        }
    }
}

