/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.org.influxdb.dto;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.shaded.influxdb.org.influxdb.BuilderException;
import org.apache.kylin.shaded.influxdb.org.influxdb.annotation.Column;
import org.apache.kylin.shaded.influxdb.org.influxdb.annotation.Measurement;
import org.apache.kylin.shaded.influxdb.org.influxdb.impl.Preconditions;

public class Point {
    private String measurement;
    private Map<String, String> tags;
    private Long time;
    private TimeUnit precision = TimeUnit.NANOSECONDS;
    private Map<String, Object> fields;
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = ThreadLocal.withInitial(() -> {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(340);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat;
    });
    private static final int DEFAULT_STRING_BUILDER_SIZE = 1024;
    private static final ThreadLocal<StringBuilder> CACHED_STRINGBUILDERS = ThreadLocal.withInitial(() -> new StringBuilder(1024));

    Point() {
    }

    public static Builder measurement(String measurement) {
        return new Builder(measurement);
    }

    public static Builder measurementByPOJO(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        Point.throwExceptionIfMissingAnnotation(clazz, Measurement.class);
        String measurementName = Point.findMeasurementName(clazz);
        return new Builder(measurementName);
    }

    private static void throwExceptionIfMissingAnnotation(Class<?> clazz, Class<? extends Annotation> expectedClass) {
        if (!clazz.isAnnotationPresent(expectedClass)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with @" + Measurement.class.getSimpleName());
        }
    }

    void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    void setTime(Long time) {
        this.time = time;
    }

    void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    Map<String, String> getTags() {
        return this.tags;
    }

    void setPrecision(TimeUnit precision) {
        this.precision = precision;
    }

    Map<String, Object> getFields() {
        return this.fields;
    }

    void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        return Objects.equals(this.measurement, point.measurement) && Objects.equals(this.tags, point.tags) && Objects.equals(this.time, point.time) && this.precision == point.precision && Objects.equals(this.fields, point.fields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.measurement, this.tags, this.time, this.precision, this.fields});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Point [name=");
        builder.append(this.measurement);
        if (this.time != null) {
            builder.append(", time=");
            builder.append(this.time);
        }
        builder.append(", tags=");
        builder.append(this.tags);
        if (this.precision != null) {
            builder.append(", precision=");
            builder.append((Object)this.precision);
        }
        builder.append(", fields=");
        builder.append(this.fields);
        builder.append("]");
        return builder.toString();
    }

    public String lineProtocol() {
        return this.lineProtocol(null);
    }

    public String lineProtocol(TimeUnit precision) {
        StringBuilder sb = CACHED_STRINGBUILDERS.get();
        sb.setLength(0);
        Point.escapeKey(sb, this.measurement);
        this.concatenatedTags(sb);
        this.concatenatedFields(sb);
        this.formatedTime(sb, precision);
        return sb.toString();
    }

    private void concatenatedTags(StringBuilder sb) {
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            sb.append(',');
            Point.escapeKey(sb, tag.getKey());
            sb.append('=');
            Point.escapeKey(sb, tag.getValue());
        }
        sb.append(' ');
    }

    private void concatenatedFields(StringBuilder sb) {
        for (Map.Entry<String, Object> field : this.fields.entrySet()) {
            Object value = field.getValue();
            if (value == null) continue;
            Point.escapeKey(sb, field.getKey());
            sb.append('=');
            if (value instanceof Number) {
                if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                    sb.append(NUMBER_FORMATTER.get().format(value));
                } else {
                    sb.append(value).append('i');
                }
            } else if (value instanceof String) {
                String stringValue = (String)value;
                sb.append('\"');
                Point.escapeField(sb, stringValue);
                sb.append('\"');
            } else {
                sb.append(value);
            }
            sb.append(',');
        }
        int lengthMinusOne = sb.length() - 1;
        if (sb.charAt(lengthMinusOne) == ',') {
            sb.setLength(lengthMinusOne);
        }
    }

    static void escapeKey(StringBuilder sb, String key) {
        for (int i = 0; i < key.length(); ++i) {
            switch (key.charAt(i)) {
                case ' ': 
                case ',': 
                case '=': {
                    sb.append('\\');
                }
            }
            sb.append(key.charAt(i));
        }
    }

    static void escapeField(StringBuilder sb, String field) {
        for (int i = 0; i < field.length(); ++i) {
            switch (field.charAt(i)) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(field.charAt(i));
        }
    }

    private void formatedTime(StringBuilder sb, TimeUnit precision) {
        if (this.time == null) {
            return;
        }
        if (precision == null) {
            sb.append(" ").append(TimeUnit.NANOSECONDS.convert(this.time, this.precision));
            return;
        }
        sb.append(" ").append(precision.convert(this.time, this.precision));
    }

    private static String findMeasurementName(Class<?> clazz) {
        return clazz.getAnnotation(Measurement.class).name();
    }

    public static final class Builder {
        private final String measurement;
        private final Map<String, String> tags = new TreeMap<String, String>();
        private Long time;
        private TimeUnit precision;
        private final Map<String, Object> fields = new TreeMap<String, Object>();

        Builder(String measurement) {
            this.measurement = measurement;
        }

        public Builder tag(String tagName, String value) {
            Objects.requireNonNull(tagName, "tagName");
            Objects.requireNonNull(value, "value");
            if (!tagName.isEmpty() && !value.isEmpty()) {
                this.tags.put(tagName, value);
            }
            return this;
        }

        public Builder tag(Map<String, String> tagsToAdd) {
            for (Map.Entry<String, String> tag : tagsToAdd.entrySet()) {
                this.tag(tag.getKey(), tag.getValue());
            }
            return this;
        }

        @Deprecated
        public Builder field(String field, Object value) {
            if (value instanceof Number) {
                if (value instanceof Byte) {
                    value = ((Byte)value).doubleValue();
                } else if (value instanceof Short) {
                    value = ((Short)value).doubleValue();
                } else if (value instanceof Integer) {
                    value = ((Integer)value).doubleValue();
                } else if (value instanceof Long) {
                    value = ((Long)value).doubleValue();
                } else if (value instanceof BigInteger) {
                    value = ((BigInteger)value).doubleValue();
                }
            }
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, boolean value) {
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, long value) {
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, double value) {
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, Number value) {
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, String value) {
            Objects.requireNonNull(value, "value");
            this.fields.put(field, value);
            return this;
        }

        public Builder fields(Map<String, Object> fieldsToAdd) {
            this.fields.putAll(fieldsToAdd);
            return this;
        }

        public Builder time(long timeToSet, TimeUnit precisionToSet) {
            Objects.requireNonNull(precisionToSet, "precisionToSet");
            this.time = timeToSet;
            this.precision = precisionToSet;
            return this;
        }

        public boolean hasFields() {
            return !this.fields.isEmpty();
        }

        public Builder addFieldsFromPOJO(Object pojo) {
            Class<?> clazz = pojo.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String fieldName = column.name();
                this.addFieldByAttribute(pojo, field, column, fieldName);
            }
            if (this.fields.isEmpty()) {
                throw new BuilderException("Class " + pojo.getClass().getName() + " has no @" + Column.class.getSimpleName() + " annotation");
            }
            return this;
        }

        private void addFieldByAttribute(Object pojo, Field field, Column column, String fieldName) {
            try {
                Object fieldValue = field.get(pojo);
                if (column.tag()) {
                    this.tags.put(fieldName, (String)fieldValue);
                } else {
                    this.fields.put(fieldName, fieldValue);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new BuilderException("Field " + fieldName + " could not found on class " + pojo.getClass().getSimpleName());
            }
        }

        public Point build() {
            Preconditions.checkNonEmptyString(this.measurement, "measurement");
            Preconditions.checkPositiveNumber(this.fields.size(), "fields size");
            Point point = new Point();
            point.setFields(this.fields);
            point.setMeasurement(this.measurement);
            if (this.time != null) {
                point.setTime(this.time);
                point.setPrecision(this.precision);
            }
            point.setTags(this.tags);
            return point;
        }
    }
}

