/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication.ldap;

import java.io.Serializable;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.ldap.Query;
import org.apache.kyuubi.service.authentication.ldap.Query$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q4A\u0001F\u000b\u0003E!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u00046\u0001\t\u0007I\u0011\u0002\u001c\t\r\t\u0003\u0001\u0015!\u00038\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Caa\u0014\u0001!\u0002\u0013)\u0005b\u0002)\u0001\u0005\u0004%I\u0001\u0012\u0005\u0007#\u0002\u0001\u000b\u0011B#\t\u000fI\u0003!\u0019!C\u0005\t\"11\u000b\u0001Q\u0001\n\u0015Cq\u0001\u0016\u0001C\u0002\u0013%Q\u000b\u0003\u0004Z\u0001\u0001\u0006IA\u0016\u0005\u00065\u0002!\ta\u0017\u0005\u0006C\u0002!\tA\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\u0006S\u0002!\tA\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0006q\u0002!\t!\u001f\u0002\r#V,'/\u001f$bGR|'/\u001f\u0006\u0003-]\tA\u0001\u001c3ba*\u0011\u0001$G\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\tQ2$A\u0004tKJ4\u0018nY3\u000b\u0005qi\u0012AB6zkV\u0014\u0017N\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017\u0001B2p]\u001a\u0004\"a\u000b\u0018\u000e\u00031R!!L\u000e\u0002\r\r|gNZ5h\u0013\tyCF\u0001\u0006LsV,(-[\"p]\u001a\fa\u0001P5oSRtDC\u0001\u001a5!\t\u0019\u0004!D\u0001\u0016\u0011\u0015I#\u00011\u0001+\u0003M)6+\u0012*`\u001f\nSUi\u0011+`\u00072\u000b5kU#T+\u00059\u0004c\u0001\u00139u%\u0011\u0011(\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0019\u0019FO]5oO\u0006!RkU#S?>\u0013%*R\"U?\u000ec\u0015iU*F'\u0002\n\u0001bZ;jI\u0006#HO]\u000b\u0002\u000bB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001S\u0013\u000e\u0003%S!AS\u0011\u0002\rq\u0012xn\u001c;?\u0013\taU%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003:S!\u0001T\u0013\u0002\u0013\u001d,\u0018\u000eZ!uiJ\u0004\u0013AD4s_V\u00048\t\\1tg\u0006#HO]\u0001\u0010OJ|W\u000f]\"mCN\u001c\u0018\t\u001e;sA\u0005\u0019rM]8va6+WNY3sg\"L\u0007/\u0011;ue\u0006!rM]8va6+WNY3sg\"L\u0007/\u0011;ue\u0002\nQ#^:fe6+WNY3sg\"L\u0007/\u0011;ue>\u0003H/F\u0001W!\r!s+R\u0005\u00031\u0016\u0012aa\u00149uS>t\u0017AF;tKJlU-\u001c2feND\u0017\u000e]!uiJ|\u0005\u000f\u001e\u0011\u0002\u001f\u0019Lg\u000eZ$s_V\u0004HI\u001c\"z\u0013\u0012$\"\u0001X0\u0011\u0005Mj\u0016B\u00010\u0016\u0005\u0015\tV/\u001a:z\u0011\u0015\u0001W\u00021\u0001F\u0003\u001d9'o\\;q\u0013\u0012\fqBZ5oIV\u001bXM\u001d#o\u0005f\u0014FM\u001c\u000b\u00039\u000eDQ\u0001\u001a\bA\u0002\u0015\u000bq!^:feJ#g.A\bgS:$GI\u001c\"z!\u0006$H/\u001a:o)\tav\rC\u0003i\u001f\u0001\u0007Q)A\u0002sI:\f\u0001CZ5oIV\u001bXM\u001d#o\u0005ft\u0015-\\3\u0015\u0005q[\u0007\"\u00027\u0011\u0001\u0004)\u0015\u0001C;tKJt\u0015-\\3\u0002#\u0019Lg\u000eZ$s_V\u00048OR8s+N,'\u000fF\u0002]_BDQ\u0001\\\tA\u0002\u0015CQ!]\tA\u0002\u0015\u000ba!^:fe\u0012s\u0017aE5t+N,'/T3nE\u0016\u0014xJZ$s_V\u0004Hc\u0001/um\")QO\u0005a\u0001\u000b\u00061Qo]3s\u0013\u0012DQa\u001e\nA\u0002\u0015\u000bqa\u001a:pkB$e.A\u0006dkN$x.\\)vKJLHC\u0001/{\u0011\u0015Y8\u00031\u0001F\u00031\u0019X-\u0019:dQ\u001aKG\u000e^3s\u0001")
public final class QueryFactory {
    private final String[] USER_OBJECT_CLASSES = (String[])((Object[])new String[]{"person", "user", "inetOrgPerson"});
    private final String guidAttr;
    private final String groupClassAttr;
    private final String groupMembershipAttr;
    private final Option<String> userMembershipAttrOpt;

    private String[] USER_OBJECT_CLASSES() {
        return this.USER_OBJECT_CLASSES;
    }

    private String guidAttr() {
        return this.guidAttr;
    }

    private String groupClassAttr() {
        return this.groupClassAttr;
    }

    private String groupMembershipAttr() {
        return this.groupMembershipAttr;
    }

    private Option<String> userMembershipAttrOpt() {
        return this.userMembershipAttrOpt;
    }

    public Query findGroupDnById(String groupId) {
        return Query$.MODULE$.builder().filter("(&(objectClass=<groupClassAttr>)(<guidAttr>=<groupID>))").map("guidAttr", this.guidAttr()).map("groupClassAttr", this.groupClassAttr()).map("groupID", groupId).limit(2).build();
    }

    public Query findUserDnByRdn(String userRdn) {
        return Query$.MODULE$.builder().filter("(&(|<classes:{ class |(objectClass=<class>)}>)(<userRdn>))").limit(2).map("classes", this.USER_OBJECT_CLASSES()).map("userRdn", userRdn).build();
    }

    public Query findDnByPattern(String rdn) {
        return Query$.MODULE$.builder().filter("(<rdn>)").map("rdn", rdn).limit(2).build();
    }

    public Query findUserDnByName(String userName) {
        return Query$.MODULE$.builder().filter("(&(|<classes:{ class |(objectClass=<class>)}>)(|(uid=<userName>)(sAMAccountName=<userName>)))").map("classes", this.USER_OBJECT_CLASSES()).map("userName", userName).limit(2).build();
    }

    public Query findGroupsForUser(String userName, String userDn) {
        return Query$.MODULE$.builder().filter("(&(objectClass=<groupClassAttr>)(|(<groupMembershipAttr>=<userDn>)(<groupMembershipAttr>=<userName>)))").map("groupClassAttr", this.groupClassAttr()).map("groupMembershipAttr", this.groupMembershipAttr()).map("userName", userName).map("userDn", userDn).build();
    }

    public Query isUserMemberOfGroup(String userId, String groupDn) {
        Predef$.MODULE$.require(this.userMembershipAttrOpt().isDefined(), (Function0 & Serializable)() -> new StringBuilder(19).append(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_USER_MEMBERSHIP_KEY().key()).append(" is not configured.").toString());
        return Query$.MODULE$.builder().filter("(&(|<classes:{ class |(objectClass=<class>)}>)(<userMembershipAttr>=<groupDn>)(<guidAttr>=<userId>))").map("classes", this.USER_OBJECT_CLASSES()).map("guidAttr", this.guidAttr()).map("userMembershipAttr", (String)this.userMembershipAttrOpt().get()).map("userId", userId).map("groupDn", groupDn).limit(2).build();
    }

    public Query customQuery(String searchFilter) {
        Query.QueryBuilder builder = Query$.MODULE$.builder();
        builder.filter(searchFilter);
        builder.returnAttribute(this.groupMembershipAttr());
        return builder.build();
    }

    public QueryFactory(KyuubiConf conf) {
        this.guidAttr = conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_GUID_KEY());
        this.groupClassAttr = conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_GROUP_CLASS_KEY());
        this.groupMembershipAttr = conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_GROUP_MEMBERSHIP_KEY());
        this.userMembershipAttrOpt = (Option)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_USER_MEMBERSHIP_KEY());
    }
}

