/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kyuubi;

import java.io.Serializable;
import org.apache.hadoop.security.Credentials;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.ui.SparkUI;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.runtime.BoxedUnit;

public final class SparkContextHelper$
implements Logging {
    public static final SparkContextHelper$ MODULE$ = new SparkContextHelper$();
    private static transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public void postEventToSparkListenerBus(KyuubiEvent event, SparkContext sc) {
        KyuubiEvent kyuubiEvent = event;
        if (kyuubiEvent instanceof SparkListenerEvent) {
            KyuubiEvent kyuubiEvent2 = kyuubiEvent;
            sc.listenerBus().post((SparkListenerEvent)kyuubiEvent2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ElementTrackingStore getKvStore(SparkContext sc) {
        return (ElementTrackingStore)sc.statusStore().store();
    }

    public Option<SparkUI> getSparkUI(SparkContext sc) {
        return sc.ui();
    }

    public void updateDelegationTokens(SparkContext sc, Credentials creds) {
        byte[] bytes = SparkHadoopUtil$.MODULE$.get().serialize(creds);
        SchedulerBackend schedulerBackend = sc.schedulerBackend();
        if (schedulerBackend instanceof LocalSchedulerBackend) {
            SparkHadoopUtil$.MODULE$.get().addDelegationTokens(bytes, sc.conf());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (schedulerBackend instanceof CoarseGrainedSchedulerBackend) {
            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = (CoarseGrainedSchedulerBackend)schedulerBackend;
            coarseGrainedSchedulerBackend.driverEndpoint().send((Object)new CoarseGrainedClusterMessages.UpdateDelegationTokens(bytes));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (schedulerBackend != null) {
            SchedulerBackend schedulerBackend2 = schedulerBackend;
            this.warn((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(0).append("Failed to update delegation tokens due to unsupported SchedulerBackend ").append(new StringBuilder(1).append(schedulerBackend2.getClass().getName()).append(".").toString()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)schedulerBackend);
        }
    }

    private String getLocalProperty(SparkContext sc, String propertyKey) {
        return sc.getLocalProperty(propertyKey);
    }

    public String getCurrentStatementId(SparkContext sc) {
        return this.getLocalProperty(sc, "kyuubi.statement.id");
    }

    private SparkContextHelper$() {
    }
}

