/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http.authentication;

import java.io.IOException;
import java.io.Serializable;
import javax.security.sasl.AuthenticationException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.http.authentication.AuthenticationAuditLogger$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.AuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.BasicAuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.KerberosAuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.KyuubiInternalAuthenticationHandler;
import org.apache.kyuubi.server.http.util.HttpAuthUtils$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u000e\u001d\u0001%B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\u000b\u0002!\tA\u0012\u0005\t\u0015\u0002\u0011\r\u0011\"\u0001\u001d\u0017\"1\u0001\r\u0001Q\u0001\n1Ca!\u0019\u0001\u0005\u0002q\u0011\u0007BB5\u0001\t\u0003\u0011#\u000eC\u0003l\u0001\u0011\u0005C\u000e\u0003\u0004s\u0001\u0011\u0005!e\u001d\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\tI\u0001\u0001C\t\u0003WAa!!)\u0001\t\u0003RwaBAR9!\u0005\u0011Q\u0015\u0004\u00077qA\t!a*\t\r\u0015kA\u0011AAX\u0011%\t\t,\u0004b\u0001\n\u000b\t\u0019\f\u0003\u0005\u0002<6\u0001\u000bQBA[\u0011%\ti,\u0004b\u0001\n\u000b\t\u0019\f\u0003\u0005\u0002@6\u0001\u000bQBA[\u0011%\t\t-\u0004b\u0001\n\u000b\t\u0019\f\u0003\u0005\u0002D6\u0001\u000bQBA[\u0011%\t)-\u0004b\u0001\n\u000b\t\u0019\f\u0003\u0005\u0002H6\u0001\u000bQBA[\u0011\u001d\tI-\u0004C\u0001\u0003/Bq!a3\u000e\t\u0003\t9\u0006C\u0004\u0002N6!\t!a\u0016\t\u000f\u0005=W\u0002\"\u0001\u0002X\t!\u0012)\u001e;iK:$\u0018nY1uS>tg)\u001b7uKJT!!\b\u0010\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011q\u0004I\u0001\u0005QR$\bO\u0003\u0002\"E\u000511/\u001a:wKJT!a\t\u0013\u0002\r-LX/\u001e2j\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M!\u0001A\u000b\u001a;!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0003mC:<'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c1\u0012aa\u00142kK\u000e$\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u001d\u0019XM\u001d<mKRT\u0011aN\u0001\u0006U\u00064\u0018\r_\u0005\u0003sQ\u0012aAR5mi\u0016\u0014\bCA\u001e=\u001b\u0005\u0011\u0013BA\u001f#\u0005\u001daunZ4j]\u001e\fAaY8oMB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!II\u0001\u0007G>tg-[4\n\u0005\u0011\u000b%AC&zkV\u0014\u0017nQ8oM\u00061A(\u001b8jiz\"\"aR%\u0011\u0005!\u0003Q\"\u0001\u000f\t\u000by\u0012\u0001\u0019A \u0002%\u0005,H\u000f[*dQ\u0016lW\rS1oI2,'o]\u000b\u0002\u0019B!Q\n\u0016,^\u001b\u0005q%BA(Q\u0003\u001diW\u000f^1cY\u0016T!!\u0015*\u0002\u0015\r|G\u000e\\3di&|gNC\u0001T\u0003\u0015\u00198-\u00197b\u0013\t)fJA\u0004ICNDW*\u00199\u0011\u0005]SfB\u0001%Y\u0013\tIF$A\u0006BkRD7k\u00195f[\u0016\u001c\u0018BA.]\u0005)\tU\u000f\u001e5TG\",W.\u001a\u0006\u00033r\u0001\"\u0001\u00130\n\u0005}c\"!F!vi\",g\u000e^5dCRLwN\u001c%b]\u0012dWM]\u0001\u0014CV$\bnU2iK6,\u0007*\u00198eY\u0016\u00148\u000fI\u0001\u000fC\u0012$\u0017)\u001e;i\u0011\u0006tG\r\\3s)\t\u0019w\r\u0005\u0002eK6\t!+\u0003\u0002g%\n!QK\\5u\u0011\u0015AW\u00011\u0001^\u0003-\tW\u000f\u001e5IC:$G.\u001a:\u0002!%t\u0017\u000e^!vi\"D\u0015M\u001c3mKJ\u001cH#A2\u0002\t%t\u0017\u000e\u001e\u000b\u0003G6DQA\\\u0004A\u0002=\fABZ5mi\u0016\u00148i\u001c8gS\u001e\u0004\"a\r9\n\u0005E$$\u0001\u0004$jYR,'oQ8oM&<\u0017!E4fi6\u000bGo\u00195fI\"\u000bg\u000e\u001a7feR\u0011Ao\u001e\t\u0004IVl\u0016B\u0001<S\u0005\u0019y\u0005\u000f^5p]\")\u0001\u0010\u0003a\u0001s\u0006i\u0011-\u001e;i_JL'0\u0019;j_:\u00042A_A\u0002\u001d\tYx\u0010\u0005\u0002}%6\tQP\u0003\u0002\u007fQ\u00051AH]8pizJ1!!\u0001S\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0001*\u0002\u0011\u0011|g)\u001b7uKJ$raYA\u0007\u0003/\t\t\u0003C\u0004\u0002\u0010%\u0001\r!!\u0005\u0002\u000fI,\u0017/^3tiB\u00191'a\u0005\n\u0007\u0005UAG\u0001\bTKJ4H.\u001a;SKF,Xm\u001d;\t\u000f\u0005e\u0011\u00021\u0001\u0002\u001c\u0005A!/Z:q_:\u001cX\rE\u00024\u0003;I1!a\b5\u0005=\u0019VM\u001d<mKR\u0014Vm\u001d9p]N,\u0007bBA\u0012\u0013\u0001\u0007\u0011QE\u0001\fM&dG/\u001a:DQ\u0006Lg\u000eE\u00024\u0003OI1!!\u000b5\u0005-1\u0015\u000e\u001c;fe\u000eC\u0017-\u001b8\u0015\u000f\r\fi#a\f\u0002<!9\u00111\u0005\u0006A\u0002\u0005\u0015\u0002bBA\b\u0015\u0001\u0007\u0011\u0011\u0007\t\u0005\u0003g\t9$\u0004\u0002\u00026)\u0011q\u0004N\u0005\u0005\u0003s\t)D\u0001\nIiR\u00048+\u001a:wY\u0016$(+Z9vKN$\bbBA\r\u0015\u0001\u0007\u0011Q\b\t\u0005\u0003g\ty$\u0003\u0003\u0002B\u0005U\"a\u0005%uiB\u001cVM\u001d<mKR\u0014Vm\u001d9p]N,\u0007&\u0002\u0006\u0002F\u0005E\u0003#\u00023\u0002H\u0005-\u0013bAA%%\n1A\u000f\u001b:poN\u00042aMA'\u0013\r\ty\u0005\u000e\u0002\u0011'\u0016\u0014h\u000f\\3u\u000bb\u001cW\r\u001d;j_:\fdAH=\u0002T\u0005\u0015\u0015'C\u0012\u0002V\u0005u\u00131PA0+\u0011\t9&!\u0017\u0016\u0003e$q!a\u0017)\u0005\u0004\t)GA\u0001U\u0013\u0011\ty&!\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\t\u0019GU\u0001\u0007i\"\u0014xn^:\u0012\t\u0005\u001d\u0014Q\u000e\t\u0004I\u0006%\u0014bAA6%\n9aj\u001c;iS:<\u0007\u0003BA8\u0003kr1\u0001ZA9\u0013\r\t\u0019HU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9(!\u001f\u0003\u0013QC'o\\<bE2,'bAA:%FJ1%! \u0002\u0000\u0005\u0005\u00151\r\b\u0004I\u0006}\u0014bAA2%F*!\u0005\u001a*\u0002\u0004\n)1oY1mCF\u001aa%a\u0013)\u000b)\tI)a&\u0011\u000b\u0011\f9%a#\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%/\u0003\tIw.\u0003\u0003\u0002\u0016\u0006=%aC%P\u000bb\u001cW\r\u001d;j_:\fdAH=\u0002\u001a\u0006}\u0015'C\u0012\u0002V\u0005u\u00131TA0c%\u0019\u0013QPA@\u0003;\u000b\u0019'M\u0003#IJ\u000b\u0019)M\u0002'\u0003\u0017\u000bq\u0001Z3tiJ|\u00170\u0001\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8GS2$XM\u001d\t\u0003\u00116\u00192!DAU!\r!\u00171V\u0005\u0004\u0003[\u0013&AB!osJ+g\r\u0006\u0002\u0002&\u00061\u0002\n\u0016+Q?\u000ec\u0015*\u0012(U?&\u0003v,\u0011#E%\u0016\u001b6+\u0006\u0002\u00026B!1&a.z\u0013\r\tI\f\f\u0002\f)\"\u0014X-\u00193M_\u000e\fG.A\fI)R\u0003vl\u0011'J\u000b:#v,\u0013)`\u0003\u0012#%+R*TA\u0005\u0019\u0003\n\u0016+Q?B\u0013v\nW-`\u0011\u0016\u000bE)\u0012*`\u00072KUI\u0014+`\u0013B{\u0016\t\u0012#S\u000bN\u001b\u0016\u0001\n%U)B{\u0006KU(Y3~CU)\u0011#F%~\u001bE*S#O)~K\u0005kX!E\tJ+5k\u0015\u0011\u0002+!#F\u000bU0D\u0019&+e\nV0V'\u0016\u0013vLT!N\u000b\u00061\u0002\n\u0016+Q?\u000ec\u0015*\u0012(U?V\u001bVIU0O\u00036+\u0005%\u0001\bI)R\u0003v,Q+U\u0011~#\u0016\fU#\u0002\u001f!#F\u000bU0B+RCu\fV-Q\u000b\u0002\n\u0001cZ3u+N,'/\u00139BI\u0012\u0014Xm]:\u00027\u001d,G/V:feB\u0013x\u000e_=IK\u0006$WM]%q\u0003\u0012$'/Z:t\u0003-9W\r^+tKJt\u0015-\\3\u0002\u0017\u001d,G/Q;uQRK\b/\u001a")
public class AuthenticationFilter
implements Filter,
Logging {
    private final KyuubiConf conf;
    private final HashMap<Enumeration.Value, AuthenticationHandler> authSchemeHandlers;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static String getAuthType() {
        return AuthenticationFilter$.MODULE$.getAuthType();
    }

    public static String getUserName() {
        return AuthenticationFilter$.MODULE$.getUserName();
    }

    public static String getUserProxyHeaderIpAddress() {
        return AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress();
    }

    public static String getUserIpAddress() {
        return AuthenticationFilter$.MODULE$.getUserIpAddress();
    }

    public static ThreadLocal<String> HTTP_AUTH_TYPE() {
        return AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE();
    }

    public static ThreadLocal<String> HTTP_CLIENT_USER_NAME() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME();
    }

    public static ThreadLocal<String> HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS() {
        return AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS();
    }

    public static ThreadLocal<String> HTTP_CLIENT_IP_ADDRESS() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public HashMap<Enumeration.Value, AuthenticationHandler> authSchemeHandlers() {
        return this.authSchemeHandlers;
    }

    public void addAuthHandler(AuthenticationHandler authHandler) {
        authHandler.init(this.conf);
        if (authHandler.authenticationSupported()) {
            if (this.authSchemeHandlers().contains((Object)authHandler.authScheme())) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Authentication handler has been defined for scheme ").append(authHandler.authScheme()).toString());
                return;
            }
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Add authentication handler ").append(authHandler.getClass().getSimpleName()).append(" for scheme ").append(authHandler.authScheme()).toString());
            this.authSchemeHandlers().put((Object)authHandler.authScheme(), (Object)authHandler);
            return;
        }
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("The authentication handler ").append(authHandler.getClass().getSimpleName()).append(" for scheme ").append(authHandler.authScheme()).append(" is not supported").toString());
    }

    public void initAuthHandlers() {
        Option basicAuthTypeOpt;
        Seq authTypes = (Seq)((TraversableLike)this.conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
        boolean spnegoKerberosEnabled = authTypes.contains((Object)AuthTypes$.MODULE$.KERBEROS());
        Set set = authTypes.toSet();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{AuthTypes$.MODULE$.NOSASL()}));
        Option option = !(set != null ? !set.equals(genTraversable) : genTraversable != null) ? authTypes.headOption() : (basicAuthTypeOpt = ((TraversableLike)((TraversableLike)authTypes.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals((Object)AuthTypes$.MODULE$.KERBEROS())))).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals((Object)AuthTypes$.MODULE$.NOSASL())))).headOption());
        if (spnegoKerberosEnabled) {
            KerberosAuthenticationHandler kerberosHandler = new KerberosAuthenticationHandler();
            this.addAuthHandler(kerberosHandler);
        }
        basicAuthTypeOpt.foreach((Function1 & Serializable & scala.Serializable)basicAuthType -> {
            AuthenticationFilter.$anonfun$initAuthHandlers$4(this, basicAuthType);
            return BoxedUnit.UNIT;
        });
        if (InternalSecurityAccessor$.MODULE$.get() != null) {
            KyuubiInternalAuthenticationHandler internalHandler = new KyuubiInternalAuthenticationHandler();
            this.addAuthHandler(internalHandler);
            return;
        }
    }

    public void init(FilterConfig filterConfig) {
        this.initAuthHandlers();
    }

    public Option<AuthenticationHandler> getMatchedHandler(String authorization) {
        return this.authSchemeHandlers().values().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.matchAuthScheme(authorization)));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authorization = httpRequest.getHeader(HttpAuthUtils$.MODULE$.AUTHORIZATION_HEADER());
        AuthenticationHandler matchedHandler = (AuthenticationHandler)this.getMatchedHandler(authorization).orNull(Predef$.MODULE$.$conforms());
        AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().set(httpRequest.getRemoteAddr());
        AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().set(httpRequest.getHeader((String)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_PROXY_HTTP_CLIENT_IP_HEADER())));
        try {
            try {
                if (matchedHandler == null) {
                    this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("No auth scheme matched for url: ").append(httpRequest.getRequestURL()).toString());
                    httpResponse.setStatus(401);
                    httpResponse.sendError(401, new StringBuilder(27).append("No auth scheme matched for ").append(authorization).toString());
                } else {
                    AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE().set(matchedHandler.authScheme().toString());
                    String authUser = matchedHandler.authenticate(httpRequest, httpResponse);
                    if (authUser != null) {
                        AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME().set(authUser);
                        this.doFilter(filterChain, httpRequest, httpResponse);
                    }
                }
            }
            catch (AuthenticationException e) {
                httpResponse.setStatus(403);
                AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME().remove();
                AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().remove();
                AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().remove();
                AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE().remove();
                httpResponse.sendError(403, e.getMessage());
            }
        }
        finally {
            AuthenticationAuditLogger$.MODULE$.audit(httpRequest, httpResponse);
        }
    }

    public void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        if (this.authSchemeHandlers().nonEmpty()) {
            this.authSchemeHandlers().values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.destroy();
                return BoxedUnit.UNIT;
            });
            this.authSchemeHandlers().clear();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initAuthHandlers$4(AuthenticationFilter $this, Enumeration.Value basicAuthType) {
        BasicAuthenticationHandler basicHandler = new BasicAuthenticationHandler(basicAuthType);
        $this.addAuthHandler(basicHandler);
    }

    public AuthenticationFilter(KyuubiConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.authSchemeHandlers = new HashMap();
    }
}

