/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.schema;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.util.Collections;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.types.Row;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TColumnDesc;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeDesc;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeQualifiers;
import org.apache.kyuubi.util.RowSetUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class RowSet$ {
    public static RowSet$ MODULE$;
    private DateTimeFormatter TIMESTAMP_LZT_FORMATTER;

    static {
        new RowSet$();
    }

    public TColumnDesc toTColumnDesc(Column field, int pos) {
        TColumnDesc tColumnDesc = new TColumnDesc();
        tColumnDesc.setColumnName(field.getName());
        tColumnDesc.setTypeDesc(this.toTTypeDesc(field.getDataType().getLogicalType()));
        tColumnDesc.setComment(field.getComment().orElse(""));
        tColumnDesc.setPosition(pos);
        return tColumnDesc;
    }

    public TTypeDesc toTTypeDesc(LogicalType typ) {
        TPrimitiveTypeEntry typeEntry = new TPrimitiveTypeEntry(this.toTTypeId(typ));
        typeEntry.setTypeQualifiers(this.toTTypeQualifiers(typ));
        TTypeDesc tTypeDesc = new TTypeDesc();
        tTypeDesc.addToTypes(TTypeEntry.primitiveEntry(typeEntry));
        return tTypeDesc;
    }

    public TTypeQualifiers toTTypeQualifiers(LogicalType typ) {
        java.util.Map map;
        TTypeQualifiers ret = new TTypeQualifiers();
        LogicalType logicalType = typ;
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)TTypeQualifierValue.i32Value(decimalType.getPrecision())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)TTypeQualifierValue.i32Value(decimalType.getScale()))}))).asJava();
        } else if (logicalType instanceof VarCharType) {
            VarCharType varCharType = (VarCharType)logicalType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"characterMaximumLength"), (Object)TTypeQualifierValue.i32Value(varCharType.getLength()))}))).asJava();
        } else if (logicalType instanceof CharType) {
            CharType charType = (CharType)logicalType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"characterMaximumLength"), (Object)TTypeQualifierValue.i32Value(charType.getLength()))}))).asJava();
        } else {
            map = Collections.emptyMap();
        }
        java.util.Map qualifiers = map;
        ret.setQualifiers(qualifiers);
        return ret;
    }

    public TTypeId toTTypeId(LogicalType typ) {
        LogicalType logicalType = typ;
        if (logicalType instanceof NullType) {
            return TTypeId.NULL_TYPE;
        }
        if (logicalType instanceof BooleanType) {
            return TTypeId.BOOLEAN_TYPE;
        }
        if (logicalType instanceof FloatType) {
            return TTypeId.FLOAT_TYPE;
        }
        if (logicalType instanceof DoubleType) {
            return TTypeId.DOUBLE_TYPE;
        }
        if (logicalType instanceof VarCharType) {
            return TTypeId.VARCHAR_TYPE;
        }
        if (logicalType instanceof CharType) {
            return TTypeId.CHAR_TYPE;
        }
        if (logicalType instanceof TinyIntType) {
            return TTypeId.TINYINT_TYPE;
        }
        if (logicalType instanceof SmallIntType) {
            return TTypeId.SMALLINT_TYPE;
        }
        if (logicalType instanceof IntType) {
            return TTypeId.INT_TYPE;
        }
        if (logicalType instanceof BigIntType) {
            return TTypeId.BIGINT_TYPE;
        }
        if (logicalType instanceof DecimalType) {
            return TTypeId.DECIMAL_TYPE;
        }
        if (logicalType instanceof DateType) {
            return TTypeId.DATE_TYPE;
        }
        if (logicalType instanceof TimestampType) {
            return TTypeId.TIMESTAMP_TYPE;
        }
        if (logicalType instanceof LocalZonedTimestampType) {
            return TTypeId.TIMESTAMPLOCALTZ_TYPE;
        }
        if (logicalType instanceof ArrayType) {
            return TTypeId.ARRAY_TYPE;
        }
        if (logicalType instanceof MapType) {
            return TTypeId.MAP_TYPE;
        }
        if (logicalType instanceof RowType) {
            return TTypeId.STRUCT_TYPE;
        }
        if (logicalType instanceof BinaryType) {
            return TTypeId.BINARY_TYPE;
        }
        if (logicalType instanceof VarBinaryType) {
            return TTypeId.BINARY_TYPE;
        }
        if (logicalType instanceof TimeType) {
            return TTypeId.STRING_TYPE;
        }
        if (logicalType instanceof ZonedTimestampType ? true : (logicalType instanceof MultisetType ? true : (logicalType instanceof YearMonthIntervalType ? true : logicalType instanceof DayTimeIntervalType))) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Flink data type `%s` is not supported currently")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalType.asSummaryString()})), null);
        }
        throw new IllegalArgumentException(new StringBuilder(24).append("Unrecognized type name: ").append(logicalType.asSummaryString()).toString());
    }

    public String toHiveString(Tuple2<Object, LogicalType> dataWithType) {
        Object bin;
        Object s;
        Object decimal;
        Object ts;
        Object ldt;
        Object d;
        Object ld;
        Object d2;
        Object object;
        Tuple2<Object, LogicalType> tuple2 = dataWithType;
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "null";
        }
        if (tuple2 != null && (d2 = tuple2._1()) instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)d2);
            if (tuple2._2() instanceof DateType) {
                return RowSetUtils$.MODULE$.formatLocalDate(LocalDate.ofEpochDay(n));
            }
        }
        if (tuple2 != null && (ld = tuple2._1()) instanceof LocalDate) {
            LocalDate localDate = (LocalDate)ld;
            if (tuple2._2() instanceof DateType) {
                return RowSetUtils$.MODULE$.formatLocalDate(localDate);
            }
        }
        if (tuple2 != null && (d = tuple2._1()) instanceof Date) {
            Date date = (Date)d;
            if (tuple2._2() instanceof DateType) {
                return RowSetUtils$.MODULE$.formatInstant(date.toInstant(), RowSetUtils$.MODULE$.formatInstant$default$2());
            }
        }
        if (tuple2 != null && (ldt = tuple2._1()) instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)ldt;
            if (tuple2._2() instanceof TimestampType) {
                return RowSetUtils$.MODULE$.formatLocalDateTime(localDateTime);
            }
        }
        if (tuple2 != null && (ts = tuple2._1()) instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)ts;
            if (tuple2._2() instanceof TimestampType) {
                return RowSetUtils$.MODULE$.formatInstant(timestamp.toInstant(), RowSetUtils$.MODULE$.formatInstant$default$2());
            }
        }
        if (tuple2 != null && (decimal = tuple2._1()) instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)decimal;
            if (tuple2._2() instanceof DecimalType) {
                return bigDecimal.toPlainString();
            }
        }
        if (tuple2 != null) {
            Object a = tuple2._1();
            LogicalType t = (LogicalType)tuple2._2();
            if (ScalaRunTime$.MODULE$.isArray(a, 1)) {
                Object object2 = a;
                if (t instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)t;
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(object2).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(v, (Object)arrayType.getElementType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq().mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object m = tuple2._1();
            LogicalType t = (LogicalType)tuple2._2();
            if (m instanceof scala.collection.immutable.Map) {
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)m;
                if (t instanceof MapType) {
                    MapType mapType = (MapType)t;
                    return ((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            return new StringBuilder(1).append(MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(k, (Object)mapType.getKeyType()))).append(":").append(MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(v, (Object)mapType.getValueType()))).toString();
                        }
                        throw new MatchError((Object)tuple2);
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object r = tuple2._1();
            LogicalType t = (LogicalType)tuple2._2();
            if (r instanceof Row) {
                Row row = (Row)r;
                if (t instanceof RowType) {
                    RowType rowType = (RowType)t;
                    ListBuffer lb = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.getArity()).foreach((Function1 & Serializable & scala.Serializable)i -> lb.$plus$eq((Object)new StringBuilder(1).append(rowType.getTypeAt(BoxesRunTime.unboxToInt((Object)i)).toString()).append(":").append(RowSet$.MODULE$.toHiveString((Tuple2<Object, LogicalType>)new Tuple2(row.getField(BoxesRunTime.unboxToInt((Object)i)), (Object)rowType.getTypeAt(BoxesRunTime.unboxToInt((Object)i))))).toString()));
                    return lb.toList().mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null && (s = tuple2._1()) instanceof String) {
            String string = (String)s;
            if (tuple2._2() instanceof VarCharType ? true : tuple2._2() instanceof CharType) {
                return new StringBuilder(2).append("\"").append(string).append("\"").toString();
            }
        }
        if (tuple2 != null && (bin = tuple2._1()) instanceof byte[]) {
            byte[] byArray = (byte[])bin;
            if (tuple2._2() instanceof BinaryType ? true : tuple2._2() instanceof VarBinaryType) {
                return new String(byArray, StandardCharsets.UTF_8);
            }
        }
        if (tuple2 != null) {
            Object other = tuple2._1();
            return other.toString();
        }
        throw new MatchError(tuple2);
    }

    public DateTimeFormatter TIMESTAMP_LZT_FORMATTER() {
        return this.TIMESTAMP_LZT_FORMATTER;
    }

    public void TIMESTAMP_LZT_FORMATTER_$eq(DateTimeFormatter x$1) {
        this.TIMESTAMP_LZT_FORMATTER = x$1;
    }

    private RowSet$() {
        MODULE$ = this;
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        builder.optionalStart().appendLiteral(" ").append(DateTimeFormatter.ofPattern("HH:mm:ss")).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd();
        builder.optionalStart().appendLiteral(" ").optionalEnd();
        builder.optionalStart().appendZoneText(TextStyle.NARROW).optionalEnd();
        this.TIMESTAMP_LZT_FORMATTER = builder.toFormatter();
    }
}

