/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.schema;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SchemaHelper$ {
    public static SchemaHelper$ MODULE$;

    static {
        new SchemaHelper$();
    }

    public String[] getSchemasWithPattern(Catalog flinkCatalog, String schemaNamePattern) {
        Pattern p = new StringOps(Predef$.MODULE$.augmentString(schemaNamePattern)).r().pattern();
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(flinkCatalog.listDatabases()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)))).filter((Function1 & Serializable & scala.Serializable)schemaName -> BoxesRunTime.boxToBoolean((boolean)SchemaHelper$.$anonfun$getSchemasWithPattern$1(p, schemaName)));
    }

    public String[] getTablesWithPattern(Catalog flinkCatalog, String schemaName, String tableNamePattern) {
        Pattern p = new StringOps(Predef$.MODULE$.augmentString(tableNamePattern)).r().pattern();
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(flinkCatalog.listTables(schemaName)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)))).filter((Function1 & Serializable & scala.Serializable)tableName -> BoxesRunTime.boxToBoolean((boolean)SchemaHelper$.$anonfun$getTablesWithPattern$1(p, tableName)));
    }

    public Tuple2<String, Option<CatalogBaseTable>>[] getFlinkTablesWithPattern(Catalog flinkCatalog, String catalogName, String schemaName, String tableNamePattern) {
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTablesWithPattern(flinkCatalog, schemaName, tableNamePattern))).map((Function1 & Serializable & scala.Serializable)tableName -> MODULE$.getFlinkTable(flinkCatalog, catalogName, schemaName, (String)tableName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public Tuple2<String, Option<CatalogBaseTable>> getFlinkTable(Catalog flinkCatalog, String catalogName, String schemaName, String tableName) {
        ObjectPath objPath = ObjectIdentifier.of((String)catalogName, (String)schemaName, (String)tableName).toObjectPath();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> flinkCatalog.getTable(objPath));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            CatalogBaseTable flinkTable = (CatalogBaseTable)success.value();
            return new Tuple2((Object)tableName, (Object)new Some((Object)flinkTable));
        }
        if (try_ instanceof Failure) {
            return new Tuple2((Object)tableName, (Object)None$.MODULE$);
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$getSchemasWithPattern$1(Pattern p$1, String schemaName) {
        return p$1.matcher(schemaName).matches();
    }

    public static final /* synthetic */ boolean $anonfun$getTablesWithPattern$1(Pattern p$2, String tableName) {
        return p$2.matcher(tableName).matches();
    }

    private SchemaHelper$() {
        MODULE$ = this;
    }
}

