/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.security.UserGroupInformation;

public class ClientHAProxyFactory<T>
implements HAProxyFactory<T> {
    private AlignmentContext alignmentContext;

    @Override
    public void setAlignmentContext(AlignmentContext alignmentContext) {
        this.alignmentContext = alignmentContext;
    }

    @Override
    public T createProxy(Configuration conf, InetSocketAddress nnAddr, Class<T> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
        if (this.alignmentContext != null) {
            return (T)NameNodeProxiesClient.createProxyWithAlignmentContext(nnAddr, conf, ugi, false, fallbackToSimpleAuth, this.alignmentContext);
        }
        return (T)NameNodeProxiesClient.createNonHAProxyWithClientProtocol(nnAddr, conf, ugi, false, fallbackToSimpleAuth);
    }

    @Override
    public T createProxy(Configuration conf, InetSocketAddress nnAddr, Class<T> xface, UserGroupInformation ugi, boolean withRetries) throws IOException {
        return this.createProxy(conf, nnAddr, xface, ugi, withRetries, null);
    }
}

