﻿/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

using System.Text;

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class KpStemmer : SnowballProgram
    {
        private readonly static KpStemmer methodObject = new KpStemmer();

        private readonly static Among[] a_0 = {
                    new Among ( "nde", -1, 7, "", methodObject ),
                    new Among ( "en", -1, 6, "", methodObject ),
                    new Among ( "s", -1, 2, "", methodObject ),
                    new Among ( "'s", 2, 1, "", methodObject ),
                    new Among ( "es", 2, 4, "", methodObject ),
                    new Among ( "ies", 4, 3, "", methodObject ),
                    new Among ( "aus", 2, 5, "", methodObject )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "de", -1, 5, "", methodObject ),
                    new Among ( "ge", -1, 2, "", methodObject ),
                    new Among ( "ische", -1, 4, "", methodObject ),
                    new Among ( "je", -1, 1, "", methodObject ),
                    new Among ( "lijke", -1, 3, "", methodObject ),
                    new Among ( "le", -1, 9, "", methodObject ),
                    new Among ( "ene", -1, 10, "", methodObject ),
                    new Among ( "re", -1, 8, "", methodObject ),
                    new Among ( "se", -1, 7, "", methodObject ),
                    new Among ( "te", -1, 6, "", methodObject ),
                    new Among ( "ieve", -1, 11, "", methodObject )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "heid", -1, 3, "", methodObject ),
                    new Among ( "fie", -1, 7, "", methodObject ),
                    new Among ( "gie", -1, 8, "", methodObject ),
                    new Among ( "atie", -1, 1, "", methodObject ),
                    new Among ( "isme", -1, 5, "", methodObject ),
                    new Among ( "ing", -1, 5, "", methodObject ),
                    new Among ( "arij", -1, 6, "", methodObject ),
                    new Among ( "erij", -1, 5, "", methodObject ),
                    new Among ( "sel", -1, 3, "", methodObject ),
                    new Among ( "rder", -1, 4, "", methodObject ),
                    new Among ( "ster", -1, 3, "", methodObject ),
                    new Among ( "iteit", -1, 2, "", methodObject ),
                    new Among ( "dst", -1, 10, "", methodObject ),
                    new Among ( "tst", -1, 9, "", methodObject )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "end", -1, 10, "", methodObject ),
                    new Among ( "atief", -1, 2, "", methodObject ),
                    new Among ( "erig", -1, 10, "", methodObject ),
                    new Among ( "achtig", -1, 9, "", methodObject ),
                    new Among ( "ioneel", -1, 1, "", methodObject ),
                    new Among ( "baar", -1, 3, "", methodObject ),
                    new Among ( "laar", -1, 5, "", methodObject ),
                    new Among ( "naar", -1, 4, "", methodObject ),
                    new Among ( "raar", -1, 6, "", methodObject ),
                    new Among ( "eriger", -1, 10, "", methodObject ),
                    new Among ( "achtiger", -1, 9, "", methodObject ),
                    new Among ( "lijker", -1, 8, "", methodObject ),
                    new Among ( "tant", -1, 7, "", methodObject ),
                    new Among ( "erigst", -1, 10, "", methodObject ),
                    new Among ( "achtigst", -1, 9, "", methodObject ),
                    new Among ( "lijkst", -1, 8, "", methodObject )
                };

        private readonly static Among[] a_4 = {
                    new Among ( "ig", -1, 1, "", methodObject ),
                    new Among ( "iger", -1, 1, "", methodObject ),
                    new Among ( "igst", -1, 1, "", methodObject )
                };

        private readonly static Among[] a_5 = {
                    new Among ( "ft", -1, 2, "", methodObject ),
                    new Among ( "kt", -1, 1, "", methodObject ),
                    new Among ( "pt", -1, 3, "", methodObject )
                };

        private readonly static Among[] a_6 = {
                    new Among ( "bb", -1, 1, "", methodObject ),
                    new Among ( "cc", -1, 2, "", methodObject ),
                    new Among ( "dd", -1, 3, "", methodObject ),
                    new Among ( "ff", -1, 4, "", methodObject ),
                    new Among ( "gg", -1, 5, "", methodObject ),
                    new Among ( "hh", -1, 6, "", methodObject ),
                    new Among ( "jj", -1, 7, "", methodObject ),
                    new Among ( "kk", -1, 8, "", methodObject ),
                    new Among ( "ll", -1, 9, "", methodObject ),
                    new Among ( "mm", -1, 10, "", methodObject ),
                    new Among ( "nn", -1, 11, "", methodObject ),
                    new Among ( "pp", -1, 12, "", methodObject ),
                    new Among ( "qq", -1, 13, "", methodObject ),
                    new Among ( "rr", -1, 14, "", methodObject ),
                    new Among ( "ss", -1, 15, "", methodObject ),
                    new Among ( "tt", -1, 16, "", methodObject ),
                    new Among ( "v", -1, 21, "", methodObject ),
                    new Among ( "vv", 16, 17, "", methodObject ),
                    new Among ( "ww", -1, 18, "", methodObject ),
                    new Among ( "xx", -1, 19, "", methodObject ),
                    new Among ( "z", -1, 22, "", methodObject ),
                    new Among ( "zz", 20, 20, "", methodObject )
                };

        private readonly static Among[] a_7 = {
                    new Among ( "d", -1, 1, "", methodObject ),
                    new Among ( "t", -1, 2, "", methodObject )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16, (char)1 };

        private static readonly char[] g_v_WX = { (char)17, (char)65, (char)208, (char)1 };

        private static readonly char[] g_AOU = { (char)1, (char)64, (char)16 };

        private static readonly char[] g_AIOU = { (char)1, (char)65, (char)16 };

        private bool B_GE_removed;
        private bool B_stemmed;
        private bool B_Y_found;
        private int I_p2;
        private int I_p1;
        private int I_x;
        private StringBuilder S_ch = new StringBuilder();

        private void copy_from(KpStemmer other)
        {
            B_GE_removed = other.B_GE_removed;
            B_stemmed = other.B_stemmed;
            B_Y_found = other.B_Y_found;
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            I_x = other.I_x;
            S_ch = other.S_ch;
            base.CopyFrom(other);
        }

        private bool r_R1()
        {
            // (, line 32
            // setmark x, line 32
            I_x = m_cursor;
            if (!(I_x >= I_p1))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            // (, line 33
            // setmark x, line 33
            I_x = m_cursor;
            if (!(I_x >= I_p2))
            {
                return false;
            }
            return true;
        }

        private bool r_V()
        {
            int v_1;
            int v_2;
            // test, line 35
            v_1 = m_limit - m_cursor;
            // (, line 35
            // or, line 35
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    if (!(InGroupingB(g_v, 97, 121)))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                // literal, line 35
                if (!(Eq_S_B(2, "ij")))
                {
                    return false;
                }
            } while (false);
            lab0:
            m_cursor = m_limit - v_1;
            return true;
        }

        private bool r_VX()
        {
            int v_1;
            int v_2;
            // test, line 36
            v_1 = m_limit - m_cursor;
            // (, line 36
            // next, line 36
            if (m_cursor <= m_limit_backward)
            {
                return false;
            }
            m_cursor--;
            // or, line 36
            do
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    if (!(InGroupingB(g_v, 97, 121)))
                    {
                        goto lab1;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_2;
                // literal, line 36
                if (!(Eq_S_B(2, "ij")))
                {
                    return false;
                }
            } while (false);
            lab0:
            m_cursor = m_limit - v_1;
            return true;
        }

        private bool r_C()
        {
            int v_1;
            int v_2;
            // test, line 37
            v_1 = m_limit - m_cursor;
            // (, line 37
            // not, line 37
            {
                v_2 = m_limit - m_cursor;
                do
                {
                    // literal, line 37
                    if (!(Eq_S_B(2, "ij")))
                    {
                        goto lab0;
                    }
                    return false;
                } while (false);
                lab0:
                m_cursor = m_limit - v_2;
            }
            if (!(OutGroupingB(g_v, 97, 121)))
            {
                return false;
            }
            m_cursor = m_limit - v_1;
            return true;
        }

        private bool r_lengthen_V()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            // do, line 39
            v_1 = m_limit - m_cursor;
            do
            {
                // (, line 39
                if (!(OutGroupingB(g_v_WX, 97, 121)))
                {
                    goto lab0;
                }
                // [, line 40
                m_ket = m_cursor;
                // or, line 40
                do
                {
                    v_2 = m_limit - m_cursor;
                    do
                    {
                        // (, line 40
                        if (!(InGroupingB(g_AOU, 97, 117)))
                        {
                            goto lab2;
                        }
                        // ], line 40
                        m_bra = m_cursor;
                        // test, line 40
                        v_3 = m_limit - m_cursor;
                        // (, line 40
                        // or, line 40
                        do
                        {
                            v_4 = m_limit - m_cursor;
                            do
                            {
                                if (!(OutGroupingB(g_v, 97, 121)))
                                {
                                    goto lab4;
                                }
                                goto lab3;
                            } while (false);
                            lab4:
                            m_cursor = m_limit - v_4;
                            // atlimit, line 40
                            if (m_cursor > m_limit_backward)
                            {
                                goto lab2;
                            }
                        } while (false);
                        lab3:
                        m_cursor = m_limit - v_3;
                        goto lab1;
                    } while (false);
                    lab2:
                    m_cursor = m_limit - v_2;
                    // (, line 41
                    // literal, line 41
                    if (!(Eq_S_B(1, "e")))
                    {
                        goto lab0;
                    }
                    // ], line 41
                    m_bra = m_cursor;
                    // test, line 41
                    v_5 = m_limit - m_cursor;
                    // (, line 41
                    // or, line 41
                    do
                    {
                        v_6 = m_limit - m_cursor;
                        do
                        {
                            if (!(OutGroupingB(g_v, 97, 121)))
                            {
                                goto lab6;
                            }
                            goto lab5;
                        } while (false);
                        lab6:
                        m_cursor = m_limit - v_6;
                        // atlimit, line 41
                        if (m_cursor > m_limit_backward)
                        {
                            goto lab0;
                        }
                    } while (false);
                    lab5:
                    // not, line 42
                    {
                        v_7 = m_limit - m_cursor;
                        do
                        {
                            if (!(InGroupingB(g_AIOU, 97, 117)))
                            {
                                goto lab7;
                            }
                            goto lab0;
                        } while (false);
                        lab7:
                        m_cursor = m_limit - v_7;
                    }
                    // not, line 43
                    {
                        v_8 = m_limit - m_cursor;
                        do
                        {
                            // (, line 43
                            // next, line 43
                            if (m_cursor <= m_limit_backward)
                            {
                                goto lab8;
                            }
                            m_cursor--;
                            if (!(InGroupingB(g_AIOU, 97, 117)))
                            {
                                goto lab8;
                            }
                            if (!(OutGroupingB(g_v, 97, 121)))
                            {
                                goto lab8;
                            }
                            goto lab0;
                        } while (false);
                        lab8:
                        m_cursor = m_limit - v_8;
                    }
                    m_cursor = m_limit - v_5;
                } while (false);
                lab1:
                // -> ch, line 44
                S_ch = SliceTo(S_ch);
                // <+ ch, line 44
                {
                    int c = m_cursor;
                    Insert(m_cursor, m_cursor, S_ch.ToString());
                    m_cursor = c;
                }
            } while (false);
            lab0:
            m_cursor = m_limit - v_1;
            return true;
        }

        private bool r_Step_1()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            // (, line 48
            // [, line 49
            m_ket = m_cursor;
            // among, line 49
            among_var = FindAmongB(a_0, 7);
            if (among_var == 0)
            {
                return false;
            }
            // (, line 49
            // ], line 49
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 51
                    // delete, line 51
                    SliceDel();
                    break;
                case 2:
                    // (, line 52
                    // call R1, line 52
                    if (!r_R1())
                    {
                        return false;
                    }
                    // not, line 52
                    {
                        v_1 = m_limit - m_cursor;
                        do
                        {
                            // (, line 52
                            // literal, line 52
                            if (!(Eq_S_B(1, "t")))
                            {
                                goto lab0;
                            }
                            // call R1, line 52
                            if (!r_R1())
                            {
                                goto lab0;
                            }
                            return false;
                        } while (false);
                        lab0:
                        m_cursor = m_limit - v_1;
                    }
                    // call C, line 52
                    if (!r_C())
                    {
                        return false;
                    }
                    // delete, line 52
                    SliceDel();
                    break;
                case 3:
                    // (, line 53
                    // call R1, line 53
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 53
                    SliceFrom("ie");
                    break;
                case 4:
                    // (, line 55
                    // or, line 55
                    do
                    {
                        v_2 = m_limit - m_cursor;
                        do
                        {
                            // (, line 55
                            // literal, line 55
                            if (!(Eq_S_B(2, "ar")))
                            {
                                goto lab2;
                            }
                            // call R1, line 55
                            if (!r_R1())
                            {
                                goto lab2;
                            }
                            // call C, line 55
                            if (!r_C())
                            {
                                goto lab2;
                            }
                            // ], line 55
                            m_bra = m_cursor;
                            // delete, line 55
                            SliceDel();
                            // call lengthen_V, line 55
                            if (!r_lengthen_V())
                            {
                                goto lab2;
                            }
                            goto lab1;
                        } while (false);
                        lab2:
                        m_cursor = m_limit - v_2;
                        do
                        {
                            // (, line 56
                            // literal, line 56
                            if (!(Eq_S_B(2, "er")))
                            {
                                goto lab3;
                            }
                            // call R1, line 56
                            if (!r_R1())
                            {
                                goto lab3;
                            }
                            // call C, line 56
                            if (!r_C())
                            {
                                goto lab3;
                            }
                            // ], line 56
                            m_bra = m_cursor;
                            // delete, line 56
                            SliceDel();
                            goto lab1;
                        } while (false);
                        lab3:
                        m_cursor = m_limit - v_2;
                        // (, line 57
                        // call R1, line 57
                        if (!r_R1())
                        {
                            return false;
                        }
                        // call C, line 57
                        if (!r_C())
                        {
                            return false;
                        }
                        // <-, line 57
                        SliceFrom("e");
                    } while (false);
                    lab1:
                    break;
                case 5:
                    // (, line 59
                    // call R1, line 59
                    if (!r_R1())
                    {
                        return false;
                    }
                    // call V, line 59
                    if (!r_V())
                    {
                        return false;
                    }
                    // <-, line 59
                    SliceFrom("au");
                    break;
                case 6:
                    // (, line 60
                    // or, line 60
                    do
                    {
                        v_3 = m_limit - m_cursor;
                        do
                        {
                            // (, line 60
                            // literal, line 60
                            if (!(Eq_S_B(3, "hed")))
                            {
                                goto lab5;
                            }
                            // call R1, line 60
                            if (!r_R1())
                            {
                                goto lab5;
                            }
                            // ], line 60
                            m_bra = m_cursor;
                            // <-, line 60
                            SliceFrom("heid");
                            goto lab4;
                        } while (false);
                        lab5:
                        m_cursor = m_limit - v_3;
                        do
                        {
                            // (, line 61
                            // literal, line 61
                            if (!(Eq_S_B(2, "nd")))
                            {
                                goto lab6;
                            }
                            // delete, line 61
                            SliceDel();
                            goto lab4;
                        } while (false);
                        lab6:
                        m_cursor = m_limit - v_3;
                        do
                        {
                            // (, line 62
                            // literal, line 62
                            if (!(Eq_S_B(1, "d")))
                            {
                                goto lab7;
                            }
                            // call R1, line 62
                            if (!r_R1())
                            {
                                goto lab7;
                            }
                            // call C, line 62
                            if (!r_C())
                            {
                                goto lab7;
                            }
                            // ], line 62
                            m_bra = m_cursor;
                            // delete, line 62
                            SliceDel();
                            goto lab4;
                        } while (false);
                        lab7:
                        m_cursor = m_limit - v_3;
                        do
                        {
                            // (, line 63
                            // or, line 63
                            do
                            {
                                v_4 = m_limit - m_cursor;
                                do
                                {
                                    // literal, line 63
                                    if (!(Eq_S_B(1, "i")))
                                    {
                                        goto lab10;
                                    }
                                    goto lab9;
                                } while (false);
                                lab10:
                                m_cursor = m_limit - v_4;
                                // literal, line 63
                                if (!(Eq_S_B(1, "j")))
                                {
                                    goto lab8;
                                }
                            } while (false);
                            lab9:
                            // call V, line 63
                            if (!r_V())
                            {
                                goto lab8;
                            }
                            // delete, line 63
                            SliceDel();
                            goto lab4;
                        } while (false);
                        lab8:
                        m_cursor = m_limit - v_3;
                        // (, line 64
                        // call R1, line 64
                        if (!r_R1())
                        {
                            return false;
                        }
                        // call C, line 64
                        if (!r_C())
                        {
                            return false;
                        }
                        // delete, line 64
                        SliceDel();
                        // call lengthen_V, line 64
                        if (!r_lengthen_V())
                        {
                            return false;
                        }
                    } while (false);
                    lab4:
                    break;
                case 7:
                    // (, line 65
                    // <-, line 65
                    SliceFrom("nd");
                    break;
            }
            return true;
        }

        private bool r_Step_2()
        {
            int among_var;
            int v_1;
            // (, line 70
            // [, line 71
            m_ket = m_cursor;
            // among, line 71
            among_var = FindAmongB(a_1, 11);
            if (among_var == 0)
            {
                return false;
            }
            // (, line 71
            // ], line 71
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 72
                    // or, line 72
                    do
                    {
                        v_1 = m_limit - m_cursor;
                        do
                        {
                            // (, line 72
                            // literal, line 72
                            if (!(Eq_S_B(2, "'t")))
                            {
                                goto lab1;
                            }
                            // ], line 72
                            m_bra = m_cursor;
                            // delete, line 72
                            SliceDel();
                            goto lab0;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_1;
                        do
                        {
                            // (, line 73
                            // literal, line 73
                            if (!(Eq_S_B(2, "et")))
                            {
                                goto lab2;
                            }
                            // ], line 73
                            m_bra = m_cursor;
                            // call R1, line 73
                            if (!r_R1())
                            {
                                goto lab2;
                            }
                            // call C, line 73
                            if (!r_C())
                            {
                                goto lab2;
                            }
                            // delete, line 73
                            SliceDel();
                            goto lab0;
                        } while (false);
                        lab2:
                        m_cursor = m_limit - v_1;
                        do
                        {
                            // (, line 74
                            // literal, line 74
                            if (!(Eq_S_B(3, "rnt")))
                            {
                                goto lab3;
                            }
                            // ], line 74
                            m_bra = m_cursor;
                            // <-, line 74
                            SliceFrom("rn");
                            goto lab0;
                        } while (false);
                        lab3:
                        m_cursor = m_limit - v_1;
                        do
                        {
                            // (, line 75
                            // literal, line 75
                            if (!(Eq_S_B(1, "t")))
                            {
                                goto lab4;
                            }
                            // ], line 75
                            m_bra = m_cursor;
                            // call R1, line 75
                            if (!r_R1())
                            {
                                goto lab4;
                            }
                            // call VX, line 75
                            if (!r_VX())
                            {
                                goto lab4;
                            }
                            // delete, line 75
                            SliceDel();
                            goto lab0;
                        } while (false);
                        lab4:
                        m_cursor = m_limit - v_1;
                        do
                        {
                            // (, line 76
                            // literal, line 76
                            if (!(Eq_S_B(3, "ink")))
                            {
                                goto lab5;
                            }
                            // ], line 76
                            m_bra = m_cursor;
                            // <-, line 76
                            SliceFrom("ing");
                            goto lab0;
                        } while (false);
                        lab5:
                        m_cursor = m_limit - v_1;
                        do
                        {
                            // (, line 77
                            // literal, line 77
                            if (!(Eq_S_B(2, "mp")))
                            {
                                goto lab6;
                            }
                            // ], line 77
                            m_bra = m_cursor;
                            // <-, line 77
                            SliceFrom("m");
                            goto lab0;
                        } while (false);
                        lab6:
                        m_cursor = m_limit - v_1;
                        do
                        {
                            // (, line 78
                            // literal, line 78
                            if (!(Eq_S_B(1, "'")))
                            {
                                goto lab7;
                            }
                            // ], line 78
                            m_bra = m_cursor;
                            // call R1, line 78
                            if (!r_R1())
                            {
                                goto lab7;
                            }
                            // delete, line 78
                            SliceDel();
                            goto lab0;
                        } while (false);
                        lab7:
                        m_cursor = m_limit - v_1;
                        // (, line 79
                        // ], line 79
                        m_bra = m_cursor;
                        // call R1, line 79
                        if (!r_R1())
                        {
                            return false;
                        }
                        // call C, line 79
                        if (!r_C())
                        {
                            return false;
                        }
                        // delete, line 79
                        SliceDel();
                    } while (false);
                    lab0:
                    break;
                case 2:
                    // (, line 80
                    // call R1, line 80
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 80
                    SliceFrom("g");
                    break;
                case 3:
                    // (, line 81
                    // call R1, line 81
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 81
                    SliceFrom("lijk");
                    break;
                case 4:
                    // (, line 82
                    // call R1, line 82
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 82
                    SliceFrom("isch");
                    break;
                case 5:
                    // (, line 83
                    // call R1, line 83
                    if (!r_R1())
                    {
                        return false;
                    }
                    // call C, line 83
                    if (!r_C())
                    {
                        return false;
                    }
                    // delete, line 83
                    SliceDel();
                    break;
                case 6:
                    // (, line 84
                    // call R1, line 84
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 84
                    SliceFrom("t");
                    break;
                case 7:
                    // (, line 85
                    // call R1, line 85
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 85
                    SliceFrom("s");
                    break;
                case 8:
                    // (, line 86
                    // call R1, line 86
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 86
                    SliceFrom("r");
                    break;
                case 9:
                    // (, line 87
                    // call R1, line 87
                    if (!r_R1())
                    {
                        return false;
                    }
                    // delete, line 87
                    SliceDel();
                    // attach, line 87
                    Insert(m_cursor, m_cursor, "l");
                    // call lengthen_V, line 87
                    if (!r_lengthen_V())
                    {
                        return false;
                    }
                    break;
                case 10:
                    // (, line 88
                    // call R1, line 88
                    if (!r_R1())
                    {
                        return false;
                    }
                    // call C, line 88
                    if (!r_C())
                    {
                        return false;
                    }
                    // delete, line 88
                    SliceDel();
                    // attach, line 88
                    Insert(m_cursor, m_cursor, "en");
                    // call lengthen_V, line 88
                    if (!r_lengthen_V())
                    {
                        return false;
                    }
                    break;
                case 11:
                    // (, line 89
                    // call R1, line 89
                    if (!r_R1())
                    {
                        return false;
                    }
                    // call C, line 89
                    if (!r_C())
                    {
                        return false;
                    }
                    // <-, line 89
                    SliceFrom("ief");
                    break;
            }
            return true;
        }

        private bool r_Step_3()
        {
            int among_var;
            // (, line 94
            // [, line 95
            m_ket = m_cursor;
            // among, line 95
            among_var = FindAmongB(a_2, 14);
            if (among_var == 0)
            {
                return false;
            }
            // (, line 95
            // ], line 95
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 96
                    // call R1, line 96
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 96
                    SliceFrom("eer");
                    break;
                case 2:
                    // (, line 97
                    // call R1, line 97
                    if (!r_R1())
                    {
                        return false;
                    }
                    // delete, line 97
                    SliceDel();
                    // call lengthen_V, line 97
                    if (!r_lengthen_V())
                    {
                        return false;
                    }
                    break;
                case 3:
                    // (, line 100
                    // call R1, line 100
                    if (!r_R1())
                    {
                        return false;
                    }
                    // delete, line 100
                    SliceDel();
                    break;
                case 4:
                    // (, line 101
                    // <-, line 101
                    SliceFrom("r");
                    break;
                case 5:
                    // (, line 104
                    // call R1, line 104
                    if (!r_R1())
                    {
                        return false;
                    }
                    // delete, line 104
                    SliceDel();
                    // call lengthen_V, line 104
                    if (!r_lengthen_V())
                    {
                        return false;
                    }
                    break;
                case 6:
                    // (, line 105
                    // call R1, line 105
                    if (!r_R1())
                    {
                        return false;
                    }
                    // call C, line 105
                    if (!r_C())
                    {
                        return false;
                    }
                    // <-, line 105
                    SliceFrom("aar");
                    break;
                case 7:
                    // (, line 106
                    // call R2, line 106
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 106
                    SliceDel();
                    // attach, line 106
                    Insert(m_cursor, m_cursor, "f");
                    // call lengthen_V, line 106
                    if (!r_lengthen_V())
                    {
                        return false;
                    }
                    break;
                case 8:
                    // (, line 107
                    // call R2, line 107
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 107
                    SliceDel();
                    // attach, line 107
                    Insert(m_cursor, m_cursor, "g");
                    // call lengthen_V, line 107
                    if (!r_lengthen_V())
                    {
                        return false;
                    }
                    break;
                case 9:
                    // (, line 108
                    // call R1, line 108
                    if (!r_R1())
                    {
                        return false;
                    }
                    // call C, line 108
                    if (!r_C())
                    {
                        return false;
                    }
                    // <-, line 108
                    SliceFrom("t");
                    break;
                case 10:
                    // (, line 109
                    // call R1, line 109
                    if (!r_R1())
                    {
                        return false;
                    }
                    // call C, line 109
                    if (!r_C())
                    {
                        return false;
                    }
                    // <-, line 109
                    SliceFrom("d");
                    break;
            }
            return true;
        }

        private bool r_Step_4()
        {
            int among_var;
            int v_1;
            // (, line 114
            // or, line 134
            do
            {
                v_1 = m_limit - m_cursor;
                do
                {
                    // (, line 115
                    // [, line 115
                    m_ket = m_cursor;
                    // among, line 115
                    among_var = FindAmongB(a_3, 16);
                    if (among_var == 0)
                    {
                        goto lab1;
                    }
                    // (, line 115
                    // ], line 115
                    m_bra = m_cursor;
                    switch (among_var)
                    {
                        case 0:
                            goto lab1;
                        case 1:
                            // (, line 116
                            // call R1, line 116
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // <-, line 116
                            SliceFrom("ie");
                            break;
                        case 2:
                            // (, line 117
                            // call R1, line 117
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // <-, line 117
                            SliceFrom("eer");
                            break;
                        case 3:
                            // (, line 118
                            // call R1, line 118
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // delete, line 118
                            SliceDel();
                            break;
                        case 4:
                            // (, line 119
                            // call R1, line 119
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // call V, line 119
                            if (!r_V())
                            {
                                goto lab1;
                            }
                            // <-, line 119
                            SliceFrom("n");
                            break;
                        case 5:
                            // (, line 120
                            // call R1, line 120
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // call V, line 120
                            if (!r_V())
                            {
                                goto lab1;
                            }
                            // <-, line 120
                            SliceFrom("l");
                            break;
                        case 6:
                            // (, line 121
                            // call R1, line 121
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // call V, line 121
                            if (!r_V())
                            {
                                goto lab1;
                            }
                            // <-, line 121
                            SliceFrom("r");
                            break;
                        case 7:
                            // (, line 122
                            // call R1, line 122
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // <-, line 122
                            SliceFrom("teer");
                            break;
                        case 8:
                            // (, line 124
                            // call R1, line 124
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // <-, line 124
                            SliceFrom("lijk");
                            break;
                        case 9:
                            // (, line 127
                            // call R1, line 127
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // delete, line 127
                            SliceDel();
                            break;
                        case 10:
                            // (, line 131
                            // call R1, line 131
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            // call C, line 131
                            if (!r_C())
                            {
                                goto lab1;
                            }
                            // delete, line 131
                            SliceDel();
                            // call lengthen_V, line 131
                            if (!r_lengthen_V())
                            {
                                goto lab1;
                            }
                            break;
                    }
                    goto lab0;
                } while (false);
                lab1:
                m_cursor = m_limit - v_1;
                // (, line 135
                // [, line 135
                m_ket = m_cursor;
                // among, line 135
                among_var = FindAmongB(a_4, 3);
                if (among_var == 0)
                {
                    return false;
                }
                // (, line 135
                // ], line 135
                m_bra = m_cursor;
                switch (among_var)
                {
                    case 0:
                        return false;
                    case 1:
                        // (, line 138
                        // call R1, line 138
                        if (!r_R1())
                        {
                            return false;
                        }
                        // call C, line 138
                        if (!r_C())
                        {
                            return false;
                        }
                        // delete, line 138
                        SliceDel();
                        // call lengthen_V, line 138
                        if (!r_lengthen_V())
                        {
                            return false;
                        }
                        break;
                }
            } while (false);
            lab0:
            return true;
        }

        private bool r_Step_7()
        {
            int among_var;
            // (, line 144
            // [, line 145
            m_ket = m_cursor;
            // among, line 145
            among_var = FindAmongB(a_5, 3);
            if (among_var == 0)
            {
                return false;
            }
            // (, line 145
            // ], line 145
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 146
                    // <-, line 146
                    SliceFrom("k");
                    break;
                case 2:
                    // (, line 147
                    // <-, line 147
                    SliceFrom("f");
                    break;
                case 3:
                    // (, line 148
                    // <-, line 148
                    SliceFrom("p");
                    break;
            }
            return true;
        }

        private bool r_Step_6()
        {
            int among_var;
            // (, line 153
            // [, line 154
            m_ket = m_cursor;
            // among, line 154
            among_var = FindAmongB(a_6, 22);
            if (among_var == 0)
            {
                return false;
            }
            // (, line 154
            // ], line 154
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 155
                    // <-, line 155
                    SliceFrom("b");
                    break;
                case 2:
                    // (, line 156
                    // <-, line 156
                    SliceFrom("c");
                    break;
                case 3:
                    // (, line 157
                    // <-, line 157
                    SliceFrom("d");
                    break;
                case 4:
                    // (, line 158
                    // <-, line 158
                    SliceFrom("f");
                    break;
                case 5:
                    // (, line 159
                    // <-, line 159
                    SliceFrom("g");
                    break;
                case 6:
                    // (, line 160
                    // <-, line 160
                    SliceFrom("h");
                    break;
                case 7:
                    // (, line 161
                    // <-, line 161
                    SliceFrom("j");
                    break;
                case 8:
                    // (, line 162
                    // <-, line 162
                    SliceFrom("k");
                    break;
                case 9:
                    // (, line 163
                    // <-, line 163
                    SliceFrom("l");
                    break;
                case 10:
                    // (, line 164
                    // <-, line 164
                    SliceFrom("m");
                    break;
                case 11:
                    // (, line 165
                    // <-, line 165
                    SliceFrom("n");
                    break;
                case 12:
                    // (, line 166
                    // <-, line 166
                    SliceFrom("p");
                    break;
                case 13:
                    // (, line 167
                    // <-, line 167
                    SliceFrom("q");
                    break;
                case 14:
                    // (, line 168
                    // <-, line 168
                    SliceFrom("r");
                    break;
                case 15:
                    // (, line 169
                    // <-, line 169
                    SliceFrom("s");
                    break;
                case 16:
                    // (, line 170
                    // <-, line 170
                    SliceFrom("t");
                    break;
                case 17:
                    // (, line 171
                    // <-, line 171
                    SliceFrom("v");
                    break;
                case 18:
                    // (, line 172
                    // <-, line 172
                    SliceFrom("w");
                    break;
                case 19:
                    // (, line 173
                    // <-, line 173
                    SliceFrom("x");
                    break;
                case 20:
                    // (, line 174
                    // <-, line 174
                    SliceFrom("z");
                    break;
                case 21:
                    // (, line 175
                    // <-, line 175
                    SliceFrom("f");
                    break;
                case 22:
                    // (, line 176
                    // <-, line 176
                    SliceFrom("s");
                    break;
            }
            return true;
        }

        private bool r_Step_1c()
        {
            int among_var;
            int v_1;
            int v_2;
            // (, line 181
            // [, line 182
            m_ket = m_cursor;
            // among, line 182
            among_var = FindAmongB(a_7, 2);
            if (among_var == 0)
            {
                return false;
            }
            // (, line 182
            // ], line 182
            m_bra = m_cursor;
            // call R1, line 182
            if (!r_R1())
            {
                return false;
            }
            // call C, line 182
            if (!r_C())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 183
                    // not, line 183
                    {
                        v_1 = m_limit - m_cursor;
                        do
                        {
                            // (, line 183
                            // literal, line 183
                            if (!(Eq_S_B(1, "n")))
                            {
                                goto lab0;
                            }
                            // call R1, line 183
                            if (!r_R1())
                            {
                                goto lab0;
                            }
                            return false;
                        } while (false);
                        lab0:
                        m_cursor = m_limit - v_1;
                    }
                    // delete, line 183
                    SliceDel();
                    break;
                case 2:
                    // (, line 184
                    // not, line 184
                    {
                        v_2 = m_limit - m_cursor;
                        do
                        {
                            // (, line 184
                            // literal, line 184
                            if (!(Eq_S_B(1, "h")))
                            {
                                goto lab1;
                            }
                            // call R1, line 184
                            if (!r_R1())
                            {
                                goto lab1;
                            }
                            return false;
                        } while (false);
                        lab1:
                        m_cursor = m_limit - v_2;
                    }
                    // delete, line 184
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_Lose_prefix()
        {
            int v_1;
            int v_2;
            int v_3;
            // (, line 189
            // [, line 190
            m_bra = m_cursor;
            // literal, line 190
            if (!(Eq_S(2, "ge")))
            {
                return false;
            }
            // ], line 190
            m_ket = m_cursor;
            // test, line 190
            v_1 = m_cursor;
            // hop, line 190
            {
                int c = m_cursor + 3;
                if (0 > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = v_1;
            // (, line 190
            // goto, line 190
            while (true)
            {
                v_2 = m_cursor;
                do
                {
                    if (!(InGrouping(g_v, 97, 121)))
                    {
                        goto lab1;
                    }
                    m_cursor = v_2;
                    goto golab0;
                } while (false);
                lab1:
                m_cursor = v_2;
                if (m_cursor >= m_limit)
                {
                    return false;
                }
                m_cursor++;
            }
            golab0:
            // goto, line 190
            while (true)
            {
                v_3 = m_cursor;
                do
                {
                    if (!(OutGrouping(g_v, 97, 121)))
                    {
                        goto lab3;
                    }
                    m_cursor = v_3;
                    goto golab2;
                } while (false);
                lab3:
                m_cursor = v_3;
                if (m_cursor >= m_limit)
                {
                    return false;
                }
                m_cursor++;
            }
            golab2:
            // set GE_removed, line 191
            B_GE_removed = true;
            // delete, line 192
            SliceDel();
            return true;
        }

        private bool r_Lose_infix()
        {
            int v_2;
            int v_3;
            int v_4;
            // (, line 195
            // next, line 196
            if (m_cursor >= m_limit)
            {
                return false;
            }
            m_cursor++;
            // gopast, line 197
            while (true)
            {
                do
                {
                    // (, line 197
                    // [, line 197
                    m_bra = m_cursor;
                    // literal, line 197
                    if (!(Eq_S(2, "ge")))
                    {
                        goto lab1;
                    }
                    // ], line 197
                    m_ket = m_cursor;
                    goto golab0;
                } while (false);
                lab1:
                if (m_cursor >= m_limit)
                {
                    return false;
                }
                m_cursor++;
            }
            golab0:
            // test, line 197
            v_2 = m_cursor;
            // hop, line 197
            {
                int c = m_cursor + 3;
                if (0 > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            m_cursor = v_2;
            // (, line 197
            // goto, line 197
            while (true)
            {
                v_3 = m_cursor;
                do
                {
                    if (!(InGrouping(g_v, 97, 121)))
                    {
                        goto lab3;
                    }
                    m_cursor = v_3;
                    goto golab2;
                } while (false);
                lab3:
                m_cursor = v_3;
                if (m_cursor >= m_limit)
                {
                    return false;
                }
                m_cursor++;
            }
            golab2:
            // goto, line 197
            while (true)
            {
                v_4 = m_cursor;
                do
                {
                    if (!(OutGrouping(g_v, 97, 121)))
                    {
                        goto lab5;
                    }
                    m_cursor = v_4;
                    goto golab4;
                } while (false);
                lab5:
                m_cursor = v_4;
                if (m_cursor >= m_limit)
                {
                    return false;
                }
                m_cursor++;
            }
            golab4:
            // set GE_removed, line 198
            B_GE_removed = true;
            // delete, line 199
            SliceDel();
            return true;
        }

        private bool r_measure()
        {
            int v_1;
            int v_2;
            int v_5;
            int v_6;
            int v_9;
            int v_10;
            // (, line 202
            // do, line 203
            v_1 = m_cursor;
            do
            {
                // (, line 203
                // tolimit, line 204
                m_cursor = m_limit;
                // setmark p1, line 205
                I_p1 = m_cursor;
                // setmark p2, line 206
                I_p2 = m_cursor;
            } while (false);
            //lab0: // not referenced
            m_cursor = v_1;
            // do, line 208
            v_2 = m_cursor;
            do
            {
                // (, line 208
                // repeat, line 209
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 121)))
                        {
                            goto lab3;
                        }
                        // LUCENENET NOTE: continue label is not supported directly in .NET,
                        // so we just need to add another goto to get to the end of the outer loop.
                        // See: http://stackoverflow.com/a/359449/181087

                        // Original code:
                        //continue replab2;

                        goto end_of_outer_loop;

                    } while (false);
                    lab3:
                    goto replab2;
                    end_of_outer_loop: { }
                }
                replab2:
                // atleast, line 209
                {
                    int v_4 = 1;
                    // atleast, line 209
                    while (true)
                    {
                        v_5 = m_cursor;
                        do
                        {
                            // (, line 209
                            // or, line 209
                            do
                            {
                                v_6 = m_cursor;
                                do
                                {
                                    // literal, line 209
                                    if (!(Eq_S(2, "ij")))
                                    {
                                        goto lab7;
                                    }
                                    goto lab6;
                                } while (false);
                                lab7:
                                m_cursor = v_6;
                                if (!(InGrouping(g_v, 97, 121)))
                                {
                                    goto lab5;
                                }
                            } while (false);
                            lab6:
                            v_4--;
                            // LUCENENET NOTE: continue label is not supported directly in .NET,
                            // so we just need to add another goto to get to the end of the outer loop.
                            // See: http://stackoverflow.com/a/359449/181087

                            // Original code:
                            //continue replab4;

                            goto end_of_outer_loop_2;

                        } while (false);
                        lab5:
                        m_cursor = v_5;
                        goto replab4;
                        end_of_outer_loop_2: { }
                    }
                    replab4:
                    if (v_4 > 0)
                    {
                        goto lab1;
                    }
                }
                if (!(OutGrouping(g_v, 97, 121)))
                {
                    goto lab1;
                }
                // setmark p1, line 209
                I_p1 = m_cursor;
                // repeat, line 210
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 121)))
                        {
                            goto lab9;
                        }
                        // LUCENENET NOTE: continue label is not supported directly in .NET,
                        // so we just need to add another goto to get to the end of the outer loop.
                        // See: http://stackoverflow.com/a/359449/181087

                        // Original code:
                        //continue replab8;

                        goto end_of_outer_loop;

                    } while (false);
                    lab9:
                    goto replab8;
                    end_of_outer_loop: { }
                }
                replab8:
                // atleast, line 210
                {
                    int v_8 = 1;
                    // atleast, line 210
                    while (true)
                    {
                        v_9 = m_cursor;
                        do
                        {
                            // (, line 210
                            // or, line 210
                            do
                            {
                                v_10 = m_cursor;
                                do
                                {
                                    // literal, line 210
                                    if (!(Eq_S(2, "ij")))
                                    {
                                        goto lab13;
                                    }
                                    goto lab12;
                                } while (false);
                                lab13:
                                m_cursor = v_10;
                                if (!(InGrouping(g_v, 97, 121)))
                                {
                                    goto lab11;
                                }
                            } while (false);
                            lab12:
                            v_8--;
                            // LUCENENET NOTE: continue label is not supported directly in .NET,
                            // so we just need to add another goto to get to the end of the outer loop.
                            // See: http://stackoverflow.com/a/359449/181087

                            // Original code:
                            //continue replab10;

                            goto end_of_outer_loop_2;

                        } while (false);
                        lab11:
                        m_cursor = v_9;
                        goto replab10;
                        end_of_outer_loop_2: { }
                    }
                    replab10:
                    if (v_8 > 0)
                    {
                        goto lab1;
                    }
                }
                if (!(OutGrouping(g_v, 97, 121)))
                {
                    goto lab1;
                }
                // setmark p2, line 210
                I_p2 = m_cursor;
            } while (false);
            lab1:
            m_cursor = v_2;
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            int v_11;
            int v_12;
            int v_13;
            int v_14;
            int v_15;
            int v_16;
            int v_18;
            int v_19;
            int v_20;
            // (, line 214
            // unset Y_found, line 216
            B_Y_found = false;
            // unset stemmed, line 217
            B_stemmed = false;
            // do, line 218
            v_1 = m_cursor;
            do
            {
                // (, line 218
                // [, line 218
                m_bra = m_cursor;
                // literal, line 218
                if (!(Eq_S(1, "y")))
                {
                    goto lab0;
                }
                // ], line 218
                m_ket = m_cursor;
                // <-, line 218
                SliceFrom("Y");
                // set Y_found, line 218
                B_Y_found = true;
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 219
            v_2 = m_cursor;
            do
            {
                // repeat, line 219
                while (true)
                {
                    v_3 = m_cursor;
                    do
                    {
                        // (, line 219
                        // goto, line 219
                        while (true)
                        {
                            v_4 = m_cursor;
                            do
                            {
                                // (, line 219
                                if (!(InGrouping(g_v, 97, 121)))
                                {
                                    goto lab5;
                                }
                                // [, line 219
                                m_bra = m_cursor;
                                // literal, line 219
                                if (!(Eq_S(1, "y")))
                                {
                                    goto lab5;
                                }
                                // ], line 219
                                m_ket = m_cursor;
                                m_cursor = v_4;
                                goto golab4;
                            } while (false);
                            lab5:
                            m_cursor = v_4;
                            if (m_cursor >= m_limit)
                            {
                                goto lab3;
                            }
                            m_cursor++;
                        }
                        golab4:
                        // <-, line 219
                        SliceFrom("Y");
                        // set Y_found, line 219
                        B_Y_found = true;
                        // LUCENENET NOTE: continue label is not supported directly in .NET,
                        // so we just need to add another goto to get to the end of the outer loop.
                        // See: http://stackoverflow.com/a/359449/181087

                        // Original code:
                        //continue replab2;

                        goto end_of_outer_loop;

                    } while (false);
                    lab3:
                    m_cursor = v_3;
                    goto replab2;
                    end_of_outer_loop: { }
                }
                replab2:;
            } while (false);
            //lab1: // not referenced
            m_cursor = v_2;
            // call measure, line 221
            if (!r_measure())
            {
                return false;
            }
            // backwards, line 223
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 223
            // do, line 224
            v_5 = m_limit - m_cursor;
            do
            {
                // (, line 224
                // call Step_1, line 224
                if (!r_Step_1())
                {
                    goto lab6;
                }
                // set stemmed, line 224
                B_stemmed = true;
            } while (false);
            lab6:
            m_cursor = m_limit - v_5;
            // do, line 225
            v_6 = m_limit - m_cursor;
            do
            {
                // (, line 225
                // call Step_2, line 225
                if (!r_Step_2())
                {
                    goto lab7;
                }
                // set stemmed, line 225
                B_stemmed = true;
            } while (false);
            lab7:
            m_cursor = m_limit - v_6;
            // do, line 226
            v_7 = m_limit - m_cursor;
            do
            {
                // (, line 226
                // call Step_3, line 226
                if (!r_Step_3())
                {
                    goto lab8;
                }
                // set stemmed, line 226
                B_stemmed = true;
            } while (false);
            lab8:
            m_cursor = m_limit - v_7;
            // do, line 227
            v_8 = m_limit - m_cursor;
            do
            {
                // (, line 227
                // call Step_4, line 227
                if (!r_Step_4())
                {
                    goto lab9;
                }
                // set stemmed, line 227
                B_stemmed = true;
            } while (false);
            lab9:
            m_cursor = m_limit - v_8;
            m_cursor = m_limit_backward;                    // unset GE_removed, line 229
            B_GE_removed = false;
            // do, line 230
            v_9 = m_cursor;
            do
            {
                // (, line 230
                // and, line 230
                v_10 = m_cursor;
                // call Lose_prefix, line 230
                if (!r_Lose_prefix())
                {
                    goto lab10;
                }
                m_cursor = v_10;
                // call measure, line 230
                if (!r_measure())
                {
                    goto lab10;
                }
            } while (false);
            lab10:
            m_cursor = v_9;
            // backwards, line 231
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 231
            // do, line 232
            v_11 = m_limit - m_cursor;
            do
            {
                // (, line 232
                // bool test GE_removed, line 232
                if (!(B_GE_removed))
                {
                    goto lab11;
                }
                // call Step_1c, line 232
                if (!r_Step_1c())
                {
                    goto lab11;
                }
            } while (false);
            lab11:
            m_cursor = m_limit - v_11;
            m_cursor = m_limit_backward;                    // unset GE_removed, line 234
            B_GE_removed = false;
            // do, line 235
            v_12 = m_cursor;
            do
            {
                // (, line 235
                // and, line 235
                v_13 = m_cursor;
                // call Lose_infix, line 235
                if (!r_Lose_infix())
                {
                    goto lab12;
                }
                m_cursor = v_13;
                // call measure, line 235
                if (!r_measure())
                {
                    goto lab12;
                }
            } while (false);
            lab12:
            m_cursor = v_12;
            // backwards, line 236
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 236
            // do, line 237
            v_14 = m_limit - m_cursor;
            do
            {
                // (, line 237
                // bool test GE_removed, line 237
                if (!(B_GE_removed))
                {
                    goto lab13;
                }
                // call Step_1c, line 237
                if (!r_Step_1c())
                {
                    goto lab13;
                }
            } while (false);
            lab13:
            m_cursor = m_limit - v_14;
            m_cursor = m_limit_backward;                    // backwards, line 239
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 239
            // do, line 240
            v_15 = m_limit - m_cursor;
            do
            {
                // (, line 240
                // call Step_7, line 240
                if (!r_Step_7())
                {
                    goto lab14;
                }
                // set stemmed, line 240
                B_stemmed = true;
            } while (false);
            lab14:
            m_cursor = m_limit - v_15;
            // do, line 241
            v_16 = m_limit - m_cursor;
            do
            {
                // (, line 241
                // or, line 241
                do
                {
                    do
                    {
                        // bool test stemmed, line 241
                        if (!(B_stemmed))
                        {
                            goto lab17;
                        }
                        goto lab16;
                    } while (false);
                    lab17:
                    // bool test GE_removed, line 241
                    if (!(B_GE_removed))
                    {
                        goto lab15;
                    }
                } while (false);
                lab16:
                // call Step_6, line 241
                if (!r_Step_6())
                {
                    goto lab15;
                }
            } while (false);
            lab15:
            m_cursor = m_limit - v_16;
            m_cursor = m_limit_backward;                    // do, line 243
            v_18 = m_cursor;
            do
            {
                // (, line 243
                // bool test Y_found, line 243
                if (!(B_Y_found))
                {
                    goto lab18;
                }
                // repeat, line 243
                while (true)
                {
                    v_19 = m_cursor;
                    do
                    {
                        // (, line 243
                        // goto, line 243
                        while (true)
                        {
                            v_20 = m_cursor;
                            do
                            {
                                // (, line 243
                                // [, line 243
                                m_bra = m_cursor;
                                // literal, line 243
                                if (!(Eq_S(1, "Y")))
                                {
                                    goto lab22;
                                }
                                // ], line 243
                                m_ket = m_cursor;
                                m_cursor = v_20;
                                goto golab21;
                            } while (false);
                            lab22:
                            m_cursor = v_20;
                            if (m_cursor >= m_limit)
                            {
                                goto lab20;
                            }
                            m_cursor++;
                        }
                        golab21:
                        // <-, line 243
                        SliceFrom("y");
                        // LUCENENET NOTE: continue label is not supported directly in .NET,
                        // so we just need to add another goto to get to the end of the outer loop.
                        // See: http://stackoverflow.com/a/359449/181087

                        // Original code:
                        //continue replab19;

                        goto end_of_outer_loop_2;

                    } while (false);
                    lab20:
                    m_cursor = v_19;
                    goto replab19;
                    end_of_outer_loop_2: { }
                }
                replab19:;
            } while (false);
            lab18:
            m_cursor = v_18;
            return true;
        }

        public override bool Equals(object o)
        {
            return o is KpStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}
