﻿/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class SwedishStemmer : SnowballProgram
    {
        private readonly static SwedishStemmer methodObject = new SwedishStemmer();

        private readonly static Among[] a_0 = {
                    new Among ( "a", -1, 1, "", methodObject ),
                    new Among ( "arna", 0, 1, "", methodObject ),
                    new Among ( "erna", 0, 1, "", methodObject ),
                    new Among ( "heterna", 2, 1, "", methodObject ),
                    new Among ( "orna", 0, 1, "", methodObject ),
                    new Among ( "ad", -1, 1, "", methodObject ),
                    new Among ( "e", -1, 1, "", methodObject ),
                    new Among ( "ade", 6, 1, "", methodObject ),
                    new Among ( "ande", 6, 1, "", methodObject ),
                    new Among ( "arne", 6, 1, "", methodObject ),
                    new Among ( "are", 6, 1, "", methodObject ),
                    new Among ( "aste", 6, 1, "", methodObject ),
                    new Among ( "en", -1, 1, "", methodObject ),
                    new Among ( "anden", 12, 1, "", methodObject ),
                    new Among ( "aren", 12, 1, "", methodObject ),
                    new Among ( "heten", 12, 1, "", methodObject ),
                    new Among ( "ern", -1, 1, "", methodObject ),
                    new Among ( "ar", -1, 1, "", methodObject ),
                    new Among ( "er", -1, 1, "", methodObject ),
                    new Among ( "heter", 18, 1, "", methodObject ),
                    new Among ( "or", -1, 1, "", methodObject ),
                    new Among ( "s", -1, 2, "", methodObject ),
                    new Among ( "as", 21, 1, "", methodObject ),
                    new Among ( "arnas", 22, 1, "", methodObject ),
                    new Among ( "ernas", 22, 1, "", methodObject ),
                    new Among ( "ornas", 22, 1, "", methodObject ),
                    new Among ( "es", 21, 1, "", methodObject ),
                    new Among ( "ades", 26, 1, "", methodObject ),
                    new Among ( "andes", 26, 1, "", methodObject ),
                    new Among ( "ens", 21, 1, "", methodObject ),
                    new Among ( "arens", 29, 1, "", methodObject ),
                    new Among ( "hetens", 29, 1, "", methodObject ),
                    new Among ( "erns", 21, 1, "", methodObject ),
                    new Among ( "at", -1, 1, "", methodObject ),
                    new Among ( "andet", -1, 1, "", methodObject ),
                    new Among ( "het", -1, 1, "", methodObject ),
                    new Among ( "ast", -1, 1, "", methodObject )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "dd", -1, -1, "", methodObject ),
                    new Among ( "gd", -1, -1, "", methodObject ),
                    new Among ( "nn", -1, -1, "", methodObject ),
                    new Among ( "dt", -1, -1, "", methodObject ),
                    new Among ( "gt", -1, -1, "", methodObject ),
                    new Among ( "kt", -1, -1, "", methodObject ),
                    new Among ( "tt", -1, -1, "", methodObject )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "ig", -1, 1, "", methodObject ),
                    new Among ( "lig", 0, 1, "", methodObject ),
                    new Among ( "els", -1, 1, "", methodObject ),
                    new Among ( "fullt", -1, 3, "", methodObject ),
                    new Among ( "l\u00F6st", -1, 2, "", methodObject )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16, (char)1, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)24, (char)0, (char)32 };

        private static readonly char[] g_s_ending = { (char)119, (char)127, (char)149 };

        private int I_x;
        private int I_p1;

        private void copy_from(SwedishStemmer other)
        {
            I_x = other.I_x;
            I_p1 = other.I_p1;
            base.CopyFrom(other);
        }

        private bool r_mark_regions()
        {
            int v_1;
            int v_2;
            // (, line 26
            I_p1 = m_limit;
            // test, line 29
            v_1 = m_cursor;
            // (, line 29
            // hop, line 29
            {
                int c = m_cursor + 3;
                if (0 > c || c > m_limit)
                {
                    return false;
                }
                m_cursor = c;
            }
            // setmark x, line 29
            I_x = m_cursor;
            m_cursor = v_1;
            // goto, line 30
            while (true)
            {
                v_2 = m_cursor;
                do
                {
                    if (!(InGrouping(g_v, 97, 246)))
                    {
                        goto lab1;
                    }
                    m_cursor = v_2;
                    goto golab0;
                } while (false);
                lab1:
                m_cursor = v_2;
                if (m_cursor >= m_limit)
                {
                    return false;
                }
                m_cursor++;
            }
            golab0:
            // gopast, line 30
            while (true)
            {
                do
                {
                    if (!(OutGrouping(g_v, 97, 246)))
                    {
                        goto lab3;
                    }
                    goto golab2;
                } while (false);
                lab3:
                if (m_cursor >= m_limit)
                {
                    return false;
                }
                m_cursor++;
            }
            golab2:
            // setmark p1, line 30
            I_p1 = m_cursor;
            // try, line 31
            do
            {
                // (, line 31
                if (!(I_p1 < I_x))
                {
                    goto lab4;
                }
                I_p1 = I_x;
            } while (false);
            lab4:
            return true;
        }

        private bool r_main_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            // (, line 36
            // setlimit, line 37
            v_1 = m_limit - m_cursor;
            // tomark, line 37
            if (m_cursor < I_p1)
            {
                return false;
            }
            m_cursor = I_p1;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 37
            // [, line 37
            m_ket = m_cursor;
            // substring, line 37
            among_var = FindAmongB(a_0, 37);
            if (among_var == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            // ], line 37
            m_bra = m_cursor;
            m_limit_backward = v_2;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 44
                    // delete, line 44
                    SliceDel();
                    break;
                case 2:
                    // (, line 46
                    if (!(InGroupingB(g_s_ending, 98, 121)))
                    {
                        return false;
                    }
                    // delete, line 46
                    SliceDel();
                    break;
            }
            return true;
        }

        private bool r_consonant_pair()
        {
            int v_1;
            int v_2;
            int v_3;
            // setlimit, line 50
            v_1 = m_limit - m_cursor;
            // tomark, line 50
            if (m_cursor < I_p1)
            {
                return false;
            }
            m_cursor = I_p1;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 50
            // and, line 52
            v_3 = m_limit - m_cursor;
            // among, line 51
            if (FindAmongB(a_1, 7) == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            m_cursor = m_limit - v_3;
            // (, line 52
            // [, line 52
            m_ket = m_cursor;
            // next, line 52
            if (m_cursor <= m_limit_backward)
            {
                m_limit_backward = v_2;
                return false;
            }
            m_cursor--;
            // ], line 52
            m_bra = m_cursor;
            // delete, line 52
            SliceDel();
            m_limit_backward = v_2;
            return true;
        }

        private bool r_other_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            // setlimit, line 55
            v_1 = m_limit - m_cursor;
            // tomark, line 55
            if (m_cursor < I_p1)
            {
                return false;
            }
            m_cursor = I_p1;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 55
            // [, line 56
            m_ket = m_cursor;
            // substring, line 56
            among_var = FindAmongB(a_2, 5);
            if (among_var == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            // ], line 56
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    m_limit_backward = v_2;
                    return false;
                case 1:
                    // (, line 57
                    // delete, line 57
                    SliceDel();
                    break;
                case 2:
                    // (, line 58
                    // <-, line 58
                    SliceFrom("l\u00F6s");
                    break;
                case 3:
                    // (, line 59
                    // <-, line 59
                    SliceFrom("full");
                    break;
            }
            m_limit_backward = v_2;
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            // (, line 64
            // do, line 66
            v_1 = m_cursor;
            do
            {
                // call mark_regions, line 66
                if (!r_mark_regions())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = v_1;
            // backwards, line 67
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 67
            // do, line 68
            v_2 = m_limit - m_cursor;
            do
            {
                // call main_suffix, line 68
                if (!r_main_suffix())
                {
                    goto lab1;
                }
            } while (false);
            lab1:
            m_cursor = m_limit - v_2;
            // do, line 69
            v_3 = m_limit - m_cursor;
            do
            {
                // call consonant_pair, line 69
                if (!r_consonant_pair())
                {
                    goto lab2;
                }
            } while (false);
            lab2:
            m_cursor = m_limit - v_3;
            // do, line 70
            v_4 = m_limit - m_cursor;
            do
            {
                // call other_suffix, line 70
                if (!r_other_suffix())
                {
                    goto lab3;
                }
            } while (false);
            lab3:
            m_cursor = m_limit - v_4;
            m_cursor = m_limit_backward; return true;
        }

        public override bool Equals(object o)
        {
            return o is SwedishStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}
