/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.tools.InstallationProcessor;
import org.apache.uima.pear.util.FileUtil;

public class InstallationDescriptor
implements Serializable {
    private static final long serialVersionUID = 4884186903126810934L;
    public static final String PROPERTY_DELIMITER = "\n";
    public static final String VNS_SPECS = "VNS_SPECS";
    public static final String VNS_HOST = "VNS_HOST";
    public static final String VNS_PORT = "VNS_PORT";
    private File _insdFile = null;
    private Properties _osSpecs = new Properties();
    private Properties _toolkitsSpecs = new Properties();
    private Properties _frameworkSpecs = new Properties();
    private ComponentInfo _mainComponent = null;
    private Hashtable<String, ComponentInfo> _delegateComponents = new Hashtable();
    private ArrayList<ActionInfo> _installationActions = new ArrayList();

    protected static Properties addProperty(Properties props, String name, String value) {
        String curValue = props.getProperty(name);
        if (curValue == null) {
            props.setProperty(name, value.trim());
        } else {
            boolean alreadyThere = false;
            StringTokenizer curValueList = new StringTokenizer(curValue, PROPERTY_DELIMITER);
            while (curValueList.hasMoreTokens()) {
                String token = curValueList.nextToken().trim();
                if (!token.equalsIgnoreCase(value.trim())) continue;
                alreadyThere = true;
                break;
            }
            if (!alreadyThere) {
                String newValue = curValue + PROPERTY_DELIMITER + value.trim();
                props.setProperty(name, newValue);
            }
        }
        return props;
    }

    protected static Properties deleteProperty(Properties props, String name, String value) {
        String curValue = props.getProperty(name);
        if (curValue != null) {
            StringBuffer newBuffer = new StringBuffer();
            StringTokenizer curValueList = new StringTokenizer(curValue, PROPERTY_DELIMITER);
            while (curValueList.hasMoreTokens()) {
                String token = curValueList.nextToken().trim();
                if (token.length() <= 0 || token.equals(value)) continue;
                if (newBuffer.length() > 0) {
                    newBuffer.append(PROPERTY_DELIMITER);
                }
                newBuffer.append(token);
            }
            if (newBuffer.length() > 0) {
                props.setProperty(name, newBuffer.toString());
            } else {
                props.remove(name);
            }
        }
        return props;
    }

    protected static String getRelativePathForComponentObject(String absolutePath, ComponentInfo component) {
        String path = absolutePath;
        if (component.rootDirPath != null && path != null) {
            File rootDir = new File(component.rootDirPath);
            path = FileUtil.getRelativePath(rootDir, path);
        }
        return path;
    }

    public InstallationDescriptor() {
    }

    public InstallationDescriptor(File insdFile) {
        this._insdFile = insdFile;
    }

    public synchronized void addDelegateComponent(String id, String name) {
        String dlgId = id.trim();
        if (this._delegateComponents.get(dlgId) == null) {
            ComponentInfo compInfo = new ComponentInfo(dlgId);
            compInfo.name = name.trim();
            this._delegateComponents.put(dlgId, compInfo);
        }
    }

    public synchronized void addFrameworkSpec(String specName, String specValue) {
        InstallationDescriptor.addProperty(this._frameworkSpecs, specName, specValue);
    }

    public synchronized void addInstallationAction(ActionInfo action) {
        if (this._mainComponent != null && action.params != null) {
            ActionInfo mAction = new ActionInfo(action);
            Enumeration<Object> keys = mAction.params.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = mAction.params.getProperty(key);
                if (!key.equals("FILE") && !key.equals("REPLACE_WITH") && !key.equals("VAR_VALUE")) continue;
                if (this._mainComponent.rootDirPath != null) {
                    value = InstallationProcessor.substituteMainRootInString(value, this._mainComponent.rootDirPath);
                    mAction.params.setProperty(key, value);
                }
                for (Map.Entry<String, ComponentInfo> dlgEntry : this.getDelegateComponents().entrySet()) {
                    ComponentInfo dlgInfo = dlgEntry.getValue();
                    if (dlgInfo.rootDirPath == null) continue;
                    value = InstallationProcessor.substituteCompIdRootInString(value, dlgInfo.getId(), dlgInfo.rootDirPath);
                    mAction.params.setProperty(key, value);
                }
                value = mAction.params.getProperty(key);
                mAction.params.setProperty(key, value.replace('\\', '/'));
                if (this._mainComponent.rootDirPath == null || !key.equals("VAR_VALUE")) continue;
                value = mAction.params.getProperty(key);
                value = value.replace(';', File.pathSeparatorChar);
                mAction.params.setProperty(key, value);
            }
            this._installationActions.add(mAction);
        } else {
            this._installationActions.add(action);
        }
    }

    public synchronized void addOSSpec(String specName, String specValue) {
        InstallationDescriptor.addProperty(this._osSpecs, specName, specValue);
    }

    public synchronized void addToolkitsSpec(String specName, String specValue) {
        InstallationDescriptor.addProperty(this._toolkitsSpecs, specName, specValue);
    }

    public synchronized void clearDelegateComponents() {
        this._delegateComponents.clear();
    }

    public synchronized void clearFrameworkSpecs() {
        this._frameworkSpecs.clear();
    }

    public synchronized void clearInstallationActions() {
        this._installationActions.clear();
    }

    public synchronized void clearOSSpecs() {
        this._osSpecs.clear();
    }

    public synchronized void clearToolkitsSpecs() {
        this._toolkitsSpecs.clear();
    }

    public synchronized void deleteDelegateComponent(String id) {
        this._delegateComponents.remove(id);
    }

    public synchronized void deleteFrameworkSpec(String specName, String specValue) {
        InstallationDescriptor.deleteProperty(this._frameworkSpecs, specName, specValue);
    }

    public synchronized void deleteInstallationActions(String actionName) {
        Iterator<ActionInfo> actionList = this._installationActions.iterator();
        while (actionList.hasNext()) {
            ActionInfo action = actionList.next();
            if (!action.getName().equals(actionName)) continue;
            this._installationActions.remove(action);
            actionList = this._installationActions.iterator();
        }
    }

    public synchronized void deleteOSSpec(String specName, String specValue) {
        InstallationDescriptor.deleteProperty(this._osSpecs, specName, specValue);
    }

    public synchronized void deleteToolkitsSpec(String specName, String specValue) {
        InstallationDescriptor.deleteProperty(this._toolkitsSpecs, specName, specValue);
    }

    public Hashtable<String, ComponentInfo> getDelegateComponents() {
        return this._delegateComponents;
    }

    public Properties getFrameworkSpecs() {
        return this._frameworkSpecs;
    }

    public Collection<ActionInfo> getInstallationActions() {
        return this._installationActions;
    }

    public Collection<ActionInfo> getInstallationActions(String actionName) {
        ArrayList<ActionInfo> selActions = new ArrayList<ActionInfo>();
        for (ActionInfo actInfo : this.getInstallationActions()) {
            if (!actInfo.getName().equals(actionName)) continue;
            selActions.add(actInfo);
        }
        return selActions;
    }

    public synchronized File getInstallationDescriptorFile() {
        return this._insdFile;
    }

    public String getMainCasConsumerDesc() {
        return this.getMainCasConsumerDesc(false);
    }

    public synchronized String getMainCasConsumerDesc(boolean relativePath) {
        if (this._mainComponent != null) {
            return relativePath ? InstallationDescriptor.getRelativePathForComponentObject(this._mainComponent.casConsumerDescFilePath, this._mainComponent) : this._mainComponent.casConsumerDescFilePath;
        }
        return null;
    }

    public String getMainCasInitializerDesc() {
        return this.getMainCasInitializerDesc(false);
    }

    public synchronized String getMainCasInitializerDesc(boolean relativePath) {
        if (this._mainComponent != null) {
            return relativePath ? InstallationDescriptor.getRelativePathForComponentObject(this._mainComponent.casInitializerDescFilePath, this._mainComponent) : this._mainComponent.casInitializerDescFilePath;
        }
        return null;
    }

    public String getMainCollIteratorDesc() {
        return this.getMainCollIteratorDesc(false);
    }

    public synchronized String getMainCollIteratorDesc(boolean relativePath) {
        if (this._mainComponent != null) {
            return relativePath ? InstallationDescriptor.getRelativePathForComponentObject(this._mainComponent.collIteratorDescFilePath, this._mainComponent) : this._mainComponent.collIteratorDescFilePath;
        }
        return null;
    }

    public synchronized String getMainComponentDeployment() {
        return this._mainComponent != null ? this._mainComponent.deploymentType : null;
    }

    public String getMainComponentDesc() {
        return this.getMainComponentDesc(false);
    }

    public synchronized String getMainComponentDesc(boolean relativePath) {
        if (this._mainComponent != null) {
            if (this._mainComponent.descFilePath != null && this._mainComponent.descFilePath.length() > 0) {
                if (this._mainComponent.descFilePath.charAt(0) == '$') {
                    if (relativePath) {
                        int relPathIndex = this._mainComponent.descFilePath.indexOf(47) + 1;
                        return this._mainComponent.descFilePath.substring(relPathIndex);
                    }
                    return this._mainComponent.descFilePath;
                }
                return relativePath ? InstallationDescriptor.getRelativePathForComponentObject(this._mainComponent.descFilePath, this._mainComponent) : this._mainComponent.descFilePath;
            }
            return this._mainComponent.descFilePath;
        }
        return null;
    }

    public synchronized String getMainComponentId() {
        return this._mainComponent != null ? this._mainComponent.getId() : null;
    }

    public synchronized String getMainComponentName() {
        return this._mainComponent != null ? this._mainComponent.name : null;
    }

    public synchronized Properties getMainComponentNetworkParam(String paramName) {
        return this._mainComponent != null && this._mainComponent.networkParams != null ? this._mainComponent.networkParams.get(paramName) : null;
    }

    public synchronized Set<String> getMainComponentNetworkParamNames() {
        return this._mainComponent != null && this._mainComponent.networkParams != null ? this._mainComponent.networkParams.keySet() : null;
    }

    public synchronized Properties getMainComponentProps() {
        return this._mainComponent != null ? this._mainComponent.props : null;
    }

    public synchronized String getMainComponentRoot() {
        return this._mainComponent != null ? this._mainComponent.rootDirPath : null;
    }

    public synchronized ServiceInfo getMainComponentService() {
        return this._mainComponent != null ? this._mainComponent.serviceInfo : null;
    }

    public Properties getOSSpecs() {
        return this._osSpecs;
    }

    public Properties getToolkitsSpecs() {
        return this._toolkitsSpecs;
    }

    public synchronized void setInstallationDescriptorFile(File insdFile) {
        this._insdFile = insdFile;
    }

    public synchronized void setDelegateComponentDesc(String id, String descFilePath) {
        String dlgId = id.trim();
        ComponentInfo dCompInfo = this._delegateComponents.get(dlgId);
        if (dCompInfo != null) {
            dCompInfo.descFilePath = dCompInfo.rootDirPath == null ? descFilePath.trim().replace('\\', '/') : InstallationProcessor.substituteCompIdRootInString(dCompInfo.descFilePath, dlgId, dCompInfo.rootDirPath);
        }
    }

    public synchronized void setDelegateComponentName(String id, String name) {
        String dlgId = id.trim();
        ComponentInfo dCompInfo = this._delegateComponents.get(dlgId);
        if (dCompInfo != null) {
            dCompInfo.name = name.trim();
        }
    }

    public synchronized void setDelegateComponentProperty(String id, String propName, String propValue) {
        String dlgId = id.trim();
        ComponentInfo dCompInfo = this._delegateComponents.get(dlgId);
        if (dCompInfo != null) {
            if (dCompInfo.props == null) {
                dCompInfo.props = new Properties();
            }
            dCompInfo.props.setProperty(propName, propValue.trim());
        }
    }

    public synchronized void setDelegateComponentRoot(String id, String rootDirPath) {
        String dlgId = id.trim();
        ComponentInfo dCompInfo = this._delegateComponents.get(dlgId);
        if (dCompInfo != null) {
            dCompInfo.rootDirPath = rootDirPath.trim().replace('\\', '/');
            if (dCompInfo.descFilePath != null) {
                dCompInfo.descFilePath = InstallationProcessor.substituteCompIdRootInString(dCompInfo.descFilePath, dlgId, dCompInfo.rootDirPath);
            }
        }
        for (ActionInfo action : this.getInstallationActions()) {
            Enumeration<Object> keys = action.params.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = action.params.getProperty(key);
                if (!key.equals("FILE") && !key.equals("REPLACE_WITH") && !key.equals("VAR_VALUE")) continue;
                value = InstallationProcessor.substituteCompIdRootInString(value, dlgId, dCompInfo.rootDirPath);
                action.params.setProperty(key, value);
            }
        }
    }

    public synchronized void setMainCasConsumerDesc(String descFilePath) {
        if (this._mainComponent != null) {
            this._mainComponent.casConsumerDescFilePath = this._mainComponent.rootDirPath == null ? descFilePath.trim().replace('\\', '/') : InstallationProcessor.substituteMainRootInString(descFilePath, this._mainComponent.rootDirPath);
        }
    }

    public synchronized void setMainCasInitializerDesc(String descFilePath) {
        if (this._mainComponent != null) {
            this._mainComponent.casInitializerDescFilePath = this._mainComponent.rootDirPath == null ? descFilePath.trim().replace('\\', '/') : InstallationProcessor.substituteMainRootInString(descFilePath, this._mainComponent.rootDirPath);
        }
    }

    public synchronized void setMainCollIteratorDesc(String descFilePath) {
        if (this._mainComponent != null) {
            this._mainComponent.collIteratorDescFilePath = this._mainComponent.rootDirPath == null ? descFilePath.trim().replace('\\', '/') : InstallationProcessor.substituteMainRootInString(descFilePath, this._mainComponent.rootDirPath);
        }
    }

    public synchronized void setMainComponent(String id) {
        this.setMainComponent(id, "");
    }

    public synchronized void setMainComponent(String id, String name) {
        this._mainComponent = new ComponentInfo(id);
        this.setMainComponentName(name);
    }

    public synchronized void setMainComponentDeployment(String deplType) {
        if (this._mainComponent != null) {
            this._mainComponent.deploymentType = deplType;
        }
    }

    public synchronized void setMainComponentDesc(String descFilePath) {
        if (this._mainComponent != null) {
            this._mainComponent.descFilePath = this._mainComponent.rootDirPath == null ? descFilePath.trim().replace('\\', '/') : InstallationProcessor.substituteMainRootInString(descFilePath, this._mainComponent.rootDirPath);
        }
    }

    public synchronized void setMainComponentId(String id) {
        if (this._mainComponent != null) {
            this._mainComponent._id = id.trim();
        }
    }

    public synchronized void setMainComponentName(String name) {
        if (this._mainComponent != null) {
            this._mainComponent.name = name.trim();
        }
    }

    public synchronized void setMainComponentNetworkParam(String paramName, Properties paramSpecs) {
        if (this._mainComponent != null) {
            if (this._mainComponent.networkParams == null) {
                this._mainComponent.networkParams = new Hashtable();
            }
            this._mainComponent.networkParams.put(paramName, paramSpecs);
        }
    }

    public synchronized void setMainComponentProperty(String propNname, String propValue) {
        if (this._mainComponent != null) {
            if (this._mainComponent.props == null) {
                this._mainComponent.props = new Properties();
            }
            this._mainComponent.props.setProperty(propNname, propValue.trim());
        }
    }

    public synchronized void setMainComponentRoot(String rootDirPath) {
        if (this._mainComponent != null) {
            this._mainComponent.rootDirPath = rootDirPath.trim().replace('\\', '/');
            if (this._mainComponent.descFilePath != null) {
                this._mainComponent.descFilePath = InstallationProcessor.substituteMainRootInString(this._mainComponent.descFilePath, this._mainComponent.rootDirPath);
            }
            if (this._mainComponent.collIteratorDescFilePath != null) {
                this._mainComponent.collIteratorDescFilePath = InstallationProcessor.substituteMainRootInString(this._mainComponent.collIteratorDescFilePath, this._mainComponent.rootDirPath);
            }
            if (this._mainComponent.casInitializerDescFilePath != null) {
                this._mainComponent.casInitializerDescFilePath = InstallationProcessor.substituteMainRootInString(this._mainComponent.casInitializerDescFilePath, this._mainComponent.rootDirPath);
            }
            if (this._mainComponent.casConsumerDescFilePath != null) {
                this._mainComponent.casConsumerDescFilePath = InstallationProcessor.substituteMainRootInString(this._mainComponent.casConsumerDescFilePath, this._mainComponent.rootDirPath);
            }
            for (ActionInfo action : this.getInstallationActions()) {
                Enumeration<Object> keys = action.params.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = action.params.getProperty(key);
                    if (!key.equals("FILE") && !key.equals("REPLACE_WITH") && !key.equals("VAR_VALUE")) continue;
                    value = InstallationProcessor.substituteMainRootInString(value, this._mainComponent.rootDirPath);
                    action.params.setProperty(key, value);
                }
            }
        }
    }

    public synchronized void setMainComponentService(ServiceInfo serviceInfo) {
        if (this._mainComponent != null) {
            this._mainComponent.serviceInfo = serviceInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringWriter sWriter = new StringWriter();
        PrintWriter oWriter = null;
        try {
            oWriter = new PrintWriter(sWriter);
            InstallationDescriptorHandler.printInstallationDescriptor(this, oWriter);
            oWriter.flush();
        }
        catch (Exception exc) {
        }
        finally {
            if (oWriter != null) {
                try {
                    oWriter.close();
                }
                catch (Exception e) {}
            }
        }
        return sWriter.toString();
    }

    @Deprecated
    public synchronized void updateMainComponentId(String id) {
        this.setMainComponentId(id);
    }

    public static class ComponentInfo
    implements Serializable {
        private static final long serialVersionUID = 3269238133625161794L;
        private String _id;
        public String name = null;
        public String descFilePath = null;
        public String rootDirPath = null;
        public String deploymentType = "standard";
        public ServiceInfo serviceInfo = null;
        public Hashtable<String, Properties> networkParams = null;
        public String collIteratorDescFilePath = null;
        public String casInitializerDescFilePath = null;
        public String casConsumerDescFilePath = null;
        public Properties props = new Properties();

        public ComponentInfo(String id) {
            this._id = id;
        }

        public String getId() {
            return this._id;
        }
    }

    public static class ServiceInfo {
        private ArrayList<ArgInfo> _args = new ArrayList();
        public String command;
        public String workingDirPath;

        public synchronized void addArg(ArgInfo arg) {
            this._args.add(arg);
        }

        public Collection<ArgInfo> getArgs() {
            return this._args;
        }
    }

    public static class ArgInfo {
        public String value;
        public String comments;
    }

    public static class ActionInfo
    implements Serializable {
        private static final long serialVersionUID = -3459024334454685063L;
        public static final String FIND_AND_REPLACE_PATH_ACT = "find_and_replace_path";
        public static final String SET_ENV_VARIABLE_ACT = "set_env_variable";
        private String _name;
        public Properties params = new Properties();

        public ActionInfo(String name) {
            this._name = name;
        }

        protected ActionInfo(ActionInfo anAction) {
            this._name = anAction.getName();
            this.params = (Properties)anAction.params.clone();
        }

        public String getName() {
            return this._name;
        }
    }
}

