/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.marshaller;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.nuxeo.client.marshaller.SchemaFieldsDeserializer$$Lambda$1;
import org.nuxeo.client.objects.config.SchemaField;

public class SchemaFieldsDeserializer
extends StdDeserializer<Map<String, SchemaField>> {
    protected SchemaFieldsDeserializer() {
        super(Map.class);
    }

    public Map<String, SchemaField> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        TreeNode node = jp.readValueAsTree();
        return SchemaFieldsDeserializer.deserializeFields((ObjectNode)node);
    }

    protected static Map<String, SchemaField> deserializeFields(ObjectNode fields) {
        return SchemaFieldsDeserializer.deserializeFields(fields, SchemaFieldsDeserializer$$Lambda$1.lambdaFactory$());
    }

    protected static Map<String, SchemaField> deserializeFields(ObjectNode fields, Predicate<Map.Entry<String, JsonNode>> filter) {
        HashMap<String, SchemaField> complexFields = new HashMap<String, SchemaField>();
        Iterator iterator = fields.fields();
        while (iterator.hasNext()) {
            SchemaField complexField;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!filter.test(entry)) continue;
            String key = (String)entry.getKey();
            JsonNode jsonNode = (JsonNode)entry.getValue();
            if (jsonNode instanceof ValueNode) {
                String type = jsonNode.asText();
                complexField = new SchemaField(type);
            } else {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                String type = objectNode.get("type").asText();
                Map<String, SchemaField> subComplexFields = SchemaFieldsDeserializer.deserializeFields((ObjectNode)objectNode.get("fields"));
                complexField = new SchemaField(type, subComplexFields);
            }
            complexFields.put(key, complexField);
        }
        return complexFields;
    }

    static /* synthetic */ boolean lambda$deserializeFields$0(Map.Entry entry) {
        return true;
    }
}

