/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.directory;

import java.util.Objects;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.methods.DirectoryManagerAPI;
import org.nuxeo.client.objects.ConnectableEntity;
import org.nuxeo.client.objects.directory.DirectoryEntries;
import org.nuxeo.client.objects.directory.DirectoryEntry;

public class Directory
extends ConnectableEntity<DirectoryManagerAPI, Directory> {
    private String name;
    private String schema;
    private String idField;
    private String parent;

    public Directory() {
        super("directory", DirectoryManagerAPI.class);
    }

    public Directory(NuxeoClient nuxeoClient, String name) {
        super("directory", DirectoryManagerAPI.class, nuxeoClient);
        this.name = Objects.requireNonNull(name, "Directory name must not be null");
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getParent() {
        return this.parent;
    }

    public DirectoryEntries fetchEntries() {
        return this.fetchResponse(((DirectoryManagerAPI)this.api).fetchDirectoryEntries(this.name));
    }

    public DirectoryEntries fetchEntries(String currentPageIndex, String pageSize, String maxResults, String sortBy, String sortOrder) {
        return this.fetchResponse(((DirectoryManagerAPI)this.api).fetchDirectoryEntries(this.name, currentPageIndex, pageSize, maxResults, sortBy, sortOrder));
    }

    public DirectoryEntry createEntry(DirectoryEntry entry) {
        entry.setDirectoryName(this.name);
        return this.fetchResponse(((DirectoryManagerAPI)this.api).createDirectoryEntry(this.name, entry));
    }

    public DirectoryEntry fetchEntry(String entryId) {
        return this.fetchResponse(((DirectoryManagerAPI)this.api).fetchDirectoryEntry(this.name, entryId));
    }

    public DirectoryEntry updateEntry(DirectoryEntry entry) {
        entry.setDirectoryName(this.name);
        String entryId = Objects.requireNonNull(entry.getId(), "You have to give the entry id to your entry.");
        return this.fetchResponse(((DirectoryManagerAPI)this.api).updateDirectoryEntry(this.name, entryId, entry));
    }

    public void deleteEntry(String entryId) {
        this.fetchResponse(((DirectoryManagerAPI)this.api).deleteDirectoryEntry(this.name, entryId));
    }
}

