/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.date;

import com.epam.parso.date.SasTemporalConstants;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

final class SasTemporalUtils {
    private SasTemporalUtils() {
    }

    static String nChars(char character, int nTimes) {
        if (nTimes == 1) {
            return String.valueOf(character);
        }
        if (nTimes <= 30) {
            switch (character) {
                case ' ': {
                    return "                              ".substring(0, nTimes);
                }
                case '*': {
                    return "******************************".substring(0, nTimes);
                }
                case '0': {
                    return "000000000000000000000000000000".substring(0, nTimes);
                }
                case 'S': {
                    return "SSSSSSSSSSSSSSSSSSSSSSSSSSSSSS".substring(0, nTimes);
                }
            }
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < nTimes; ++i) {
            str.append(character);
        }
        return str.toString();
    }

    static double sasDaysToEpochSeconds(double sasDays) {
        return sasDays * 86400.0 - 3.156192E8;
    }

    static double sasSecondsToEpochSeconds(double sasSeconds) {
        return sasSeconds - 3.156192E8;
    }

    static Date sasDaysToDate(double sasDays) {
        return new Date((long)(SasTemporalUtils.sasDaysToEpochSeconds(sasDays) * 1000.0));
    }

    static Date sasSecondsToDate(double sasSeconds) {
        return new Date((long)(SasTemporalUtils.sasSecondsToEpochSeconds(sasSeconds) * 1000.0));
    }

    static LocalDate sasDaysToLocalDate(double sasDays) {
        return LocalDate.ofEpochDay((long)Math.floor(sasDays) - 3653L);
    }

    static BigDecimal roundSeconds(Double sasSeconds, int precision) {
        BigDecimal seconds = new BigDecimal(sasSeconds).setScale(precision, sasSeconds < 0.0 ? RoundingMode.HALF_DOWN : RoundingMode.HALF_UP);
        if (seconds.remainder(SasTemporalConstants.BIG_SECONDS_IN_DAY).compareTo(BigDecimal.ZERO) == 0 && seconds.doubleValue() > sasSeconds) {
            seconds = seconds.subtract(SasTemporalConstants.BIG_NANOSECOND_FRACTION).setScale(precision, RoundingMode.FLOOR);
        }
        return seconds;
    }

    static LocalDateTime sasSecondsToLocalDateTime(double sasSeconds, int precision) {
        BigDecimal bigSeconds = SasTemporalUtils.roundSeconds(sasSeconds, precision);
        BigDecimal nanosFraction = bigSeconds.remainder(BigDecimal.ONE);
        if (nanosFraction.compareTo(BigDecimal.ZERO) < 0) {
            nanosFraction = nanosFraction.add(BigDecimal.ONE);
        }
        return LocalDateTime.ofEpochSecond(bigSeconds.setScale(0, RoundingMode.FLOOR).longValue() - 315619200L, nanosFraction.multiply(SasTemporalConstants.BIG_NANOS_IN_SECOND).intValue(), ZoneOffset.UTC);
    }

    static DateTimeFormatter createDateTimeFormatterFromPattern(String datePattern) {
        return DateTimeFormatter.ofPattern(datePattern).withZone(ZoneOffset.UTC).withLocale(Locale.US);
    }

    static double sasLeapSecondsFix(double sasSeconds) {
        if (sasSeconds >= 6.43813056E10) {
            if (sasSeconds >= 1.906090272E11) {
                sasSeconds += 86400.0;
            }
            sasSeconds += 86400.0;
        }
        return sasSeconds;
    }

    static double sasLeapDaysFix(double sasDays) {
        if (sasDays >= 745154.0) {
            if (sasDays >= 2206123.0) {
                sasDays += 1.0;
            }
            sasDays += 1.0;
        }
        return sasDays;
    }
}

