/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.IntSupplier;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Numbers;

final class LinearlyDerivedVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = -2172866644024476121L;
    private final Vector base;
    private final double scale;
    private final double offset;

    LinearlyDerivedVector(Vector vector, double d, double d2) {
        this.base = vector;
        this.scale = d;
        this.offset = d2;
        assert (Double.isFinite(d) && d != 0.0) : d;
        assert (Double.isFinite(d2)) : d2;
    }

    public Class<Double> getElementType() {
        return Double.class;
    }

    @Override
    public boolean isSinglePrecision() {
        return false;
    }

    @Override
    public boolean isInteger() {
        if (this.scale == Math.floor(this.scale) && this.offset == Math.floor(this.offset) && this.base.isInteger()) {
            return true;
        }
        return super.isInteger();
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public boolean isEmptyOrNaN() {
        return this.base.isEmptyOrNaN();
    }

    @Override
    public boolean isNaN(int n) {
        return this.base.isNaN(n);
    }

    @Override
    public double doubleValue(int n) {
        return this.base.doubleValue(n) * this.scale + this.offset;
    }

    @Override
    public String stringValue(int n) {
        return Double.toString(this.doubleValue(n));
    }

    @Override
    public Number get(int n) {
        return this.doubleValue(n);
    }

    @Override
    public Number set(int n, Number number) {
        return this.convert(this.base.set(n, this.inverse(number)));
    }

    @Override
    public void fill(int n, int n2, Number number) {
        this.base.fill(n, n2, this.inverse(number));
    }

    @Override
    final int indexOf(int n, int n2, boolean bl) {
        return this.base.indexOf(n, n2, bl);
    }

    @Override
    public int[] repetitions(int ... nArray) {
        return this.base.repetitions(nArray);
    }

    @Override
    public Number increment(double d) {
        Number number = this.base.increment(d / this.scale);
        if (number != null && this.scale != 1.0) {
            number = number.doubleValue() * this.scale;
        }
        return number;
    }

    private Number convert(Number number) {
        if (number != null) {
            number = number.doubleValue() * this.scale + this.offset;
        }
        return number;
    }

    private Number inverse(Number number) {
        if (number != null) {
            number = (number.doubleValue() - this.offset) / this.scale;
        }
        return number;
    }

    private NumberRange<?> convert(NumberRange<?> numberRange) {
        if (numberRange != null) {
            Number number = (Number)numberRange.getMinValue();
            Number number2 = (Number)numberRange.getMaxValue();
            boolean bl = !Objects.equals(number, number = this.convert(number));
            Number number3 = number2;
            if (bl | !Objects.equals(number3, number2 = this.convert(number2))) {
                boolean bl2 = numberRange.isMinIncluded();
                boolean bl3 = numberRange.isMaxIncluded();
                if (this.scale < 0.0) {
                    Number number4 = number;
                    number = number2;
                    number2 = number4;
                    boolean bl4 = bl2;
                    bl2 = bl3;
                    bl3 = bl4;
                }
                numberRange = new NumberRange<Double>(Double.class, Numbers.cast(number, Double.class), bl2, Numbers.cast(number2, Double.class), bl3);
            }
        }
        return numberRange;
    }

    @Override
    public NumberRange<?> range() {
        return this.convert(this.base.range());
    }

    @Override
    final NumberRange<?> range(IntSupplier intSupplier, int n) {
        return this.convert(this.base.range(intSupplier, n));
    }

    @Override
    public Vector subSampling(int n, int n2, int n3) {
        return new LinearlyDerivedVector(this.base.subSampling(n, n2, n3), this.scale, this.offset);
    }

    @Override
    public Vector pick(int ... nArray) {
        return new LinearlyDerivedVector(this.base.pick(nArray), this.scale, this.offset);
    }

    @Override
    final Vector createConcatenate(Vector vector) {
        if (vector instanceof LinearlyDerivedVector) {
            LinearlyDerivedVector linearlyDerivedVector = (LinearlyDerivedVector)vector;
            if (linearlyDerivedVector.scale == this.scale && linearlyDerivedVector.offset == this.offset) {
                return new LinearlyDerivedVector(this.base.concatenate(linearlyDerivedVector.base), this.scale, this.offset);
            }
        }
        return super.createConcatenate(vector);
    }

    @Override
    final Vector createTransform(double d, double d2) {
        return this.base.transform(this.scale * d, this.offset * d + d2);
    }

    @Override
    public double[] doubleValues() {
        double[] dArray = this.base.doubleValues();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] * this.scale + this.offset;
        }
        return dArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LinearlyDerivedVector) {
            LinearlyDerivedVector linearlyDerivedVector = (LinearlyDerivedVector)object;
            if (linearlyDerivedVector.scale == this.scale && linearlyDerivedVector.offset == this.offset) {
                return this.base.equals(linearlyDerivedVector.base);
            }
        }
        return super.equals(object);
    }

    @Override
    boolean equals(int n, int n2, Vector vector, int n3) {
        if (vector instanceof LinearlyDerivedVector) {
            LinearlyDerivedVector linearlyDerivedVector = (LinearlyDerivedVector)vector;
            if (linearlyDerivedVector.scale == this.scale && linearlyDerivedVector.offset == this.offset) {
                return this.base.equals(n, n2, linearlyDerivedVector.base, n3);
            }
        }
        return super.equals(n, n2, vector, n3);
    }
}

