/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects;

import okhttp3.ResponseBody;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.methods.RepositoryAPI;
import org.nuxeo.client.objects.Document;
import org.nuxeo.client.objects.Documents;
import org.nuxeo.client.objects.RepositoryEntity;
import org.nuxeo.client.objects.acl.ACP;
import org.nuxeo.client.objects.audit.Audit;
import org.nuxeo.client.objects.blob.FileBlob;
import org.nuxeo.client.objects.workflow.Graph;
import org.nuxeo.client.objects.workflow.Workflow;
import org.nuxeo.client.objects.workflow.Workflows;
import retrofit2.Callback;

public class Repository
extends RepositoryEntity<RepositoryAPI, Repository> {
    public Repository(NuxeoClient nuxeoClient) {
        super("document", RepositoryAPI.class, nuxeoClient);
    }

    public Repository(NuxeoClient nuxeoClient, String repositoryName) {
        this(nuxeoClient);
        this.repositoryName = repositoryName;
    }

    public Document fetchDocumentRoot() {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentRoot());
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentRoot(this.repositoryName));
    }

    public void fetchDocumentRoot(Callback<Document> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentRoot(), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentRoot(this.repositoryName), callback);
        }
    }

    public Document fetchDocumentById(String documentId) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentById(documentId));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentById(documentId, this.repositoryName));
    }

    public Document createDocumentById(String parentId, Document document) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).createDocumentById(parentId, document));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).createDocumentById(parentId, document, this.repositoryName));
    }

    public Document updateDocument(Document document) {
        document.setProperties(document.getDirtyProperties());
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).updateDocument(document.getId(), document));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).updateDocument(document.getId(), document, this.repositoryName));
    }

    public void deleteDocument(Document document) {
        this.deleteDocument(document.getId());
    }

    public void deleteDocument(String docId) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).deleteDocument(docId));
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).deleteDocument(docId, this.repositoryName));
        }
    }

    public void fetchDocumentById(String documentId, Callback<Document> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentById(documentId), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentById(documentId, this.repositoryName), callback);
        }
    }

    public void createDocumentById(String parentId, Document document, Callback<Document> callback) {
        document.setProperties(document.getDirtyProperties());
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).createDocumentById(parentId, document), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).createDocumentById(parentId, document, this.repositoryName), callback);
        }
    }

    public void updateDocument(Document document, Callback<Document> callback) {
        document.setProperties(document.getDirtyProperties());
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).updateDocument(document.getId(), document), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).updateDocument(document.getId(), document, this.repositoryName), callback);
        }
    }

    public void deleteDocument(Document document, Callback<ResponseBody> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).deleteDocument(document.getId()), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).deleteDocument(document.getId(), this.repositoryName), callback);
        }
    }

    public Document fetchDocumentByPath(String documentPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentByPath(documentPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentByPath(documentPath, this.repositoryName));
    }

    public Document createDocumentByPath(String parentPath, Document document) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).createDocumentByPath(parentPath, document));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).createDocumentByPath(parentPath, document, this.repositoryName));
    }

    public void fetchDocumentByPath(String documentPath, Callback<Document> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentByPath(documentPath), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchDocumentByPath(documentPath, this.repositoryName), callback);
        }
    }

    public void createDocumentByPath(String parentPath, Document document, Callback<Document> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).createDocumentByPath(parentPath, document), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).createDocumentByPath(parentPath, document, this.repositoryName), callback);
        }
    }

    public Documents query(String query) {
        return this.fetchResponse(((RepositoryAPI)this.api).query(query));
    }

    public Documents query(String query, String pageSize, String currentPageIndex, String maxResults, String sortBy, String sortOrder, String queryParams) {
        return this.fetchResponse(((RepositoryAPI)this.api).query(query, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, queryParams));
    }

    public Documents queryByProvider(String providerName, String pageSize, String currentPageIndex, String maxResults, String sortBy, String sortOrder, String queryParams) {
        return this.fetchResponse(((RepositoryAPI)this.api).queryByProvider(providerName, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, queryParams));
    }

    public void query(String query, Callback<Documents> callback) {
        this.fetchResponse(((RepositoryAPI)this.api).query(query), callback);
    }

    public void query(String query, String pageSize, String currentPageIndex, String maxResults, String sortBy, String sortOrder, String queryParams, Callback<Documents> callback) {
        this.fetchResponse(((RepositoryAPI)this.api).query(query, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, queryParams), callback);
    }

    public void queryByProvider(String providerName, String pageSize, String currentPageIndex, String maxResults, String sortBy, String sortOrder, String queryParams, Callback<Documents> callback) {
        this.fetchResponse(((RepositoryAPI)this.api).queryByProvider(providerName, pageSize, currentPageIndex, maxResults, sortBy, sortOrder, queryParams), callback);
    }

    public Audit fetchAuditByPath(String documentPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchAuditByPath(documentPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchAuditByPath(documentPath, this.repositoryName));
    }

    public Audit fetchAuditById(String documentId) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchAuditById(documentId));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchAuditById(documentId, this.repositoryName));
    }

    public void fetchAuditByPath(String documentPath, Callback<Audit> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchAuditByPath(documentPath), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchAuditByPath(documentPath, this.repositoryName), callback);
        }
    }

    public void fetchAuditById(String documentId, Callback<Audit> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchAuditById(documentId), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchAuditById(documentId, this.repositoryName), callback);
        }
    }

    public ACP fetchACPByPath(String documentPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsByPath(documentPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsByPath(documentPath, this.repositoryName));
    }

    public ACP fetchACPById(String documentId) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsById(documentId));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsById(documentId, this.repositoryName));
    }

    public void fetchACPByPath(String documentPath, Callback<ACP> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsByPath(documentPath), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsByPath(documentPath, this.repositoryName), callback);
        }
    }

    public void fetchACPById(String documentId, Callback<ACP> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsById(documentId), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchPermissionsById(documentId, this.repositoryName), callback);
        }
    }

    public Documents fetchChildrenByPath(String parentPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenByPath(parentPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenByPath(parentPath, this.repositoryName));
    }

    public Documents fetchChildrenById(String parentId) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenById(parentId));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenById(parentId, this.repositoryName));
    }

    public void fetchChildrenByPath(String parentPath, Callback<Documents> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenByPath(parentPath), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenByPath(parentPath, this.repositoryName), callback);
        }
    }

    public void fetchChildrenById(String parentId, Callback<Documents> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenById(parentId), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchChildrenById(parentId, this.repositoryName), callback);
        }
    }

    public FileBlob fetchBlobByPath(String documentPath, String fieldPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchBlobByPath(documentPath, fieldPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchBlobByPath(documentPath, fieldPath, this.repositoryName));
    }

    public FileBlob fetchBlobById(String documentId, String fieldPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchBlobById(documentId, fieldPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchBlobById(documentId, fieldPath, this.repositoryName));
    }

    public void fetchBlobByPath(String documentPath, String fieldPath, Callback<FileBlob> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchBlobByPath(documentPath, fieldPath), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchBlobByPath(documentPath, fieldPath, this.repositoryName), callback);
        }
    }

    public void fetchBlobById(String documentId, String fieldPath, Callback<FileBlob> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchBlobById(documentId, fieldPath), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchBlobById(documentId, fieldPath, this.repositoryName), callback);
        }
    }

    public Workflow startWorkflowInstanceWithDocPath(String documentPath, Workflow workflow) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocPath(documentPath, workflow));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocPath(documentPath, workflow, this.repositoryName));
    }

    public Workflow startWorkflowInstanceWithDocId(String documentId, Workflow workflow) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocId(documentId, workflow));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocId(documentId, workflow, this.repositoryName));
    }

    public Workflows fetchWorkflowInstancesByDocId(String documentId) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstances(documentId));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstances(documentId, this.repositoryName));
    }

    public Workflows fetchWorkflowInstancesByDocPath(String documentPath) {
        if (this.repositoryName == null) {
            return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstancesByDocPath(documentPath));
        }
        return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstancesByDocPath(documentPath, this.repositoryName));
    }

    public Workflow fetchWorkflowInstance(String workflowInstanceId) {
        return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstance(workflowInstanceId));
    }

    public void cancelWorkflowInstance(String workflowInstanceId) {
        this.fetchResponse(((RepositoryAPI)this.api).cancelWorkflowInstance(workflowInstanceId));
    }

    public Graph fetchWorkflowInstanceGraph(String workflowInstanceId) {
        return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstanceGraph(workflowInstanceId));
    }

    public Graph fetchWorkflowModelGraph(String workflowModelName) {
        return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowModelGraph(workflowModelName));
    }

    public Workflow fetchWorkflowModel(String workflowModelName) {
        return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowModel(workflowModelName));
    }

    public Workflows fetchWorkflowModels() {
        return this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowModels());
    }

    public void startWorkflowInstanceWithDocPath(String documentPath, Workflow workflow, Callback<Workflow> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocPath(documentPath, workflow), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocPath(documentPath, workflow, this.repositoryName), callback);
        }
    }

    public void startWorkflowInstanceWithDocId(String documentId, Workflow workflow, Callback<Workflow> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocId(documentId, workflow), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).startWorkflowInstanceWithDocId(documentId, workflow, this.repositoryName), callback);
        }
    }

    public void fetchWorkflowInstancesByDocId(String documentId, Callback<Workflows> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstances(documentId), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstances(documentId, this.repositoryName), callback);
        }
    }

    public void fetchWorkflowInstancesByDocPath(String documentPath, Callback<Workflows> callback) {
        if (this.repositoryName == null) {
            this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstancesByDocPath(documentPath), callback);
        } else {
            this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstancesByDocPath(documentPath, this.repositoryName), callback);
        }
    }

    public void fetchWorkflowInstance(String workflowInstanceId, Callback<Workflow> callback) {
        this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstance(workflowInstanceId), callback);
    }

    public void deleteWorkflowInstance(String workflowInstanceId, Callback<ResponseBody> callback) {
    }

    public void fetchWorkflowInstanceGraph(String workflowInstanceId, Callback<Graph> callback) {
        this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowInstanceGraph(workflowInstanceId), callback);
    }

    public void fetchWorkflowModelGraph(String workflowModelName, Callback<Graph> callback) {
        this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowModelGraph(workflowModelName), callback);
    }

    public void fetchWorkflowModel(String workflowModelName, Callback<Workflow> callback) {
        this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowModel(workflowModelName), callback);
    }

    public void fetchWorkflowModels(Callback<Workflows> callback) {
        this.fetchResponse(((RepositoryAPI)this.api).fetchWorkflowModels(), callback);
    }
}

