/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import org.testng.IClass;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.ITestOrConfiguration;
import org.testng.internal.thread.IAtomicInteger;
import org.testng.internal.thread.ThreadUtil;

public abstract class BaseTestMethod
implements ITestNGMethod {
    protected ITestClass m_testClass;
    protected final transient Class m_methodClass;
    protected final transient Method m_method;
    protected String m_id = "";
    protected long m_date = System.currentTimeMillis();
    protected final transient IAnnotationFinder m_annotationFinder;
    protected String[] m_groups = new String[0];
    protected String[] m_groupsDependedUpon = new String[0];
    protected String[] m_methodsDependedUpon = new String[0];
    protected String[] m_beforeGroups = new String[0];
    protected String[] m_afterGroups = new String[0];
    private boolean m_isAlwaysRun;
    private final String m_signature;
    private final String m_methodName;
    private String m_missingGroup;
    private String m_description = null;
    protected IAtomicInteger m_currentInvocationCount = ThreadUtil.createAtomicInteger(0);
    private int m_parameterInvocationCount = 1;
    public static final Comparator DATE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            try {
                ITestNGMethod m1 = (ITestNGMethod)o1;
                ITestNGMethod m2 = (ITestNGMethod)o2;
                return (int)(m1.getDate() - m2.getDate());
            }
            catch (Exception ex) {
                return 0;
            }
        }
    };

    public BaseTestMethod(Method method, IAnnotationFinder annotationFinder) {
        this.m_methodClass = method.getDeclaringClass();
        this.m_method = method;
        this.m_methodName = this.m_method.getName();
        this.m_annotationFinder = annotationFinder;
        this.m_signature = this.initSignature();
    }

    public boolean isAlwaysRun() {
        return this.m_isAlwaysRun;
    }

    protected void setAlwaysRun(boolean alwaysRun) {
        this.m_isAlwaysRun = alwaysRun;
    }

    public Class getRealClass() {
        return this.m_methodClass;
    }

    public ITestClass getTestClass() {
        return this.m_testClass;
    }

    public void setTestClass(ITestClass tc) {
        assert (null != tc);
        if (!tc.getRealClass().equals(this.m_method.getDeclaringClass())) assert (this.m_method.getDeclaringClass().isAssignableFrom(tc.getRealClass())) : "\nMISMATCH : " + tc.getRealClass() + " " + this.m_method.getDeclaringClass();
        this.m_testClass = tc;
    }

    public int compareTo(Object o) {
        Class otherClass;
        int result = -2;
        Class thisClass = this.getRealClass();
        if (thisClass.isAssignableFrom(otherClass = ((ITestNGMethod)o).getRealClass())) {
            result = -1;
        } else if (otherClass.isAssignableFrom(thisClass)) {
            result = 1;
        } else if (this.equals(o)) {
            result = 0;
        }
        return result;
    }

    public Method getMethod() {
        return this.m_method;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public Object[] getInstances() {
        return this.m_testClass.getInstances(false);
    }

    public long[] getInstanceHashCodes() {
        return this.m_testClass.getInstanceHashCodes();
    }

    public String[] getGroups() {
        return this.m_groups;
    }

    public String[] getGroupsDependedUpon() {
        return this.m_groupsDependedUpon;
    }

    public String[] getMethodsDependedUpon() {
        return this.m_methodsDependedUpon;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isBeforeSuiteConfiguration() {
        return false;
    }

    public boolean isAfterSuiteConfiguration() {
        return false;
    }

    public boolean isBeforeTestConfiguration() {
        return false;
    }

    public boolean isAfterTestConfiguration() {
        return false;
    }

    public boolean isBeforeGroupsConfiguration() {
        return false;
    }

    public boolean isAfterGroupsConfiguration() {
        return false;
    }

    public boolean isBeforeClassConfiguration() {
        return false;
    }

    public boolean isAfterClassConfiguration() {
        return false;
    }

    public boolean isBeforeMethodConfiguration() {
        return false;
    }

    public boolean isAfterMethodConfiguration() {
        return false;
    }

    public long getTimeOut() {
        return 0L;
    }

    public int getInvocationCount() {
        return 1;
    }

    public void setInvocationCount(int counter) {
    }

    public int getSuccessPercentage() {
        return 100;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public long getDate() {
        return this.m_date;
    }

    public void setDate(long date) {
        this.m_date = date;
    }

    public boolean canRunFromClass(IClass testClass) {
        return this.m_methodClass.isAssignableFrom(testClass.getRealClass());
    }

    public boolean equals(Object obj) {
        try {
            BaseTestMethod other = (BaseTestMethod)obj;
            boolean isEqual = this.m_testClass == null ? other.m_testClass == null : this.m_testClass.getRealClass().equals(other.m_testClass.getRealClass());
            return isEqual && this.m_method.equals(other.m_method);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.m_method.hashCode();
    }

    protected void initGroups(Class annotationClass) {
        ITestOrConfiguration annotation = (ITestOrConfiguration)this.getAnnotationFinder().findAnnotation(this.getMethod(), annotationClass);
        ITestOrConfiguration classAnnotation = (ITestOrConfiguration)this.getAnnotationFinder().findAnnotation(this.getMethod().getDeclaringClass(), annotationClass);
        this.setGroups(this.getStringArray(null != annotation ? annotation.getGroups() : null, null != classAnnotation ? classAnnotation.getGroups() : null));
        annotation = (ITestOrConfiguration)this.getAnnotationFinder().findAnnotation(this.getMethod(), annotationClass);
        classAnnotation = (ITestOrConfiguration)this.getAnnotationFinder().findAnnotation(this.getMethod().getDeclaringClass(), annotationClass);
        this.setGroupsDependedUpon(this.getStringArray(null != annotation ? annotation.getDependsOnGroups() : null, null != classAnnotation ? classAnnotation.getDependsOnGroups() : null));
        String[] methodsDependedUpon = this.getStringArray(null != annotation ? annotation.getDependsOnMethods() : null, null != classAnnotation ? classAnnotation.getDependsOnMethods() : null);
        for (int i = 0; i < methodsDependedUpon.length; ++i) {
            String m = methodsDependedUpon[i];
            if (m.indexOf(".") >= 0) continue;
            methodsDependedUpon[i] = MethodHelper.calculateMethodCanonicalName(this.m_methodClass, methodsDependedUpon[i]);
        }
        this.setMethodsDependedUpon(methodsDependedUpon);
    }

    protected IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    protected IClass getIClass() {
        return this.m_testClass;
    }

    protected String getSignature() {
        return this.m_signature;
    }

    private String initSignature() {
        Method m = this.getMethod();
        String cls = m.getDeclaringClass().getName();
        StringBuffer result = new StringBuffer(cls + "." + m.getName() + "(");
        int i = 0;
        for (Class<?> p : m.getParameterTypes()) {
            if (i++ > 0) {
                result.append(", ");
            }
            result.append(p.getName());
        }
        result.append(")");
        return result.toString();
    }

    public String toString() {
        return this.getSignature();
    }

    protected String[] getStringArray(String[] methodArray, String[] classArray) {
        HashMap<String, String> vResult = new HashMap<String, String>();
        if (null != methodArray) {
            for (String m : methodArray) {
                vResult.put(m, m);
            }
        }
        if (null != classArray) {
            for (String m : classArray) {
                vResult.put(m, m);
            }
        }
        return vResult.values().toArray(new String[vResult.size()]);
    }

    protected void setGroups(String[] groups) {
        this.m_groups = groups;
    }

    protected void setGroupsDependedUpon(String[] groups) {
        this.m_groupsDependedUpon = groups;
    }

    protected void setMethodsDependedUpon(String[] methods) {
        this.m_methodsDependedUpon = methods;
    }

    public void addMethodDependedUpon(String method) {
        String[] newMethods = new String[this.m_methodsDependedUpon.length + 1];
        newMethods[0] = method;
        for (int i = 1; i < newMethods.length; ++i) {
            newMethods[i] = this.m_methodsDependedUpon[i - 1];
        }
        this.m_methodsDependedUpon = newMethods;
    }

    private static void ppp(String s) {
        System.out.println("[BaseTestMethod] " + s);
    }

    public String getMissingGroup() {
        return this.m_missingGroup;
    }

    public void setMissingGroup(String group) {
        this.m_missingGroup = group;
    }

    public int getThreadPoolSize() {
        return 0;
    }

    public void setThreadPoolSize(int threadPoolSize) {
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String[] getBeforeGroups() {
        return this.m_beforeGroups;
    }

    public String[] getAfterGroups() {
        return this.m_afterGroups;
    }

    public void incrementCurrentInvocationCount() {
        this.m_currentInvocationCount.incrementAndGet();
    }

    public int getCurrentInvocationCount() {
        return this.m_currentInvocationCount.get();
    }

    public void setParameterInvocationCount(int n) {
        this.m_parameterInvocationCount = n;
    }

    public int getParameterInvocationCount() {
        return this.m_parameterInvocationCount;
    }

    public abstract ITestNGMethod clone();
}

