/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.examples.maven;

import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="resolve-artifact", threadSafe=true)
public class ResolveArtifactMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveArtifactMojo.class);
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(property="resolver.artifactCoords", readonly=true)
    private String artifactCoords;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactResult result;
        DefaultArtifact artifact;
        try {
            artifact = new DefaultArtifact(this.artifactCoords);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.remoteRepos);
        LOGGER.info("Resolving artifact {} from {}", (Object)artifact, this.remoteRepos);
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        LOGGER.info("Resolved artifact {} to {} from {}", new Object[]{artifact, result.getArtifact().getFile(), result.getRepository()});
    }
}

