/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.threads.CloseableExecutorService;

public class SshThreadPoolExecutor
extends ThreadPoolExecutor
implements CloseableExecutorService {
    protected final DelegateCloseable closeable = new DelegateCloseable();

    public SshThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public SshThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public SshThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public SshThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    protected void terminated() {
        this.closeable.doCloseImmediately();
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown();
    }

    @Override
    public boolean isTerminating() {
        return super.isTerminating();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return super.awaitTermination(timeout, unit);
    }

    @Override
    public CloseFuture close(boolean immediately) {
        return this.closeable.close(immediately);
    }

    @Override
    public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
        this.closeable.addCloseFutureListener(listener);
    }

    @Override
    public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
        this.closeable.removeCloseFutureListener(listener);
    }

    @Override
    public boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this.closeable.isClosing();
    }

    protected class DelegateCloseable
    extends AbstractCloseable {
        protected DelegateCloseable() {
        }

        @Override
        protected CloseFuture doCloseGracefully() {
            SshThreadPoolExecutor.this.shutdown();
            return this.closeFuture;
        }

        @Override
        protected void doCloseImmediately() {
            SshThreadPoolExecutor.this.shutdownNow();
            super.doCloseImmediately();
        }

        protected void setClosed() {
            this.closeFuture.setClosed();
        }
    }
}

