/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileDetection {
    protected static final int SCAN_AHEAD = 64;

    public static DetectionResult detectContainer(InputStream stream) throws IOException {
        return FileDetection.detectContainer(stream, 0x100000);
    }

    public static DetectionResult detectContainer(InputStream stream, int bufferSize) throws IOException {
        if (stream == null) {
            return new DetectionResult();
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream, bufferSize);
        }
        stream.mark(64);
        byte[] buf = new byte[64];
        int read = stream.read(buf);
        stream.reset();
        if (read < 4) {
            return new DetectionResult(stream, ContainerType.UNKNOWN);
        }
        if ((buf[0] & 0x80) == 128) {
            return new DetectionResult(stream, ContainerType.PGP);
        }
        if (buf[0] == 45 && buf[1] == 45 && buf[2] == 45 && buf[3] == 45 && buf[4] == 45) {
            return new DetectionResult(stream, ContainerType.ASCII_ARMOR);
        }
        if (buf[8] == 75 && buf[9] == 66 && buf[10] == 88 && buf[11] == 102) {
            return new DetectionResult(stream, ContainerType.KEYBOX);
        }
        if (read == 64 && FileDetection.isAllArmor(buf)) {
            return new DetectionResult(stream, ContainerType.ASCII_ARMOR);
        }
        return new DetectionResult(stream, ContainerType.UNKNOWN);
    }

    protected static boolean isAllArmor(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            if (FileDetection.isArmorByte(buf[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean isArmorByte(byte b) {
        return b >= 65 && b <= 90 || b >= 97 && b <= 122 || b >= 48 && b <= 57 || b == 43 || b == 47;
    }

    public static class DetectionResult {
        public InputStream stream;
        public ContainerType type;

        public DetectionResult() {
            this(null, null);
        }

        public DetectionResult(InputStream stream, ContainerType type) {
            this.stream = stream != null ? stream : new ByteArrayInputStream(new byte[0]);
            this.type = type != null ? type : ContainerType.UNKNOWN;
        }
    }

    public static enum ContainerType {
        UNKNOWN,
        PGP,
        ASCII_ARMOR,
        KEYBOX;

    }
}

