/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.proxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.client.session.proxy.AuthenticationChallenge;
import org.apache.sshd.client.session.proxy.StatusLine;

public final class HttpParser {
    private HttpParser() {
    }

    public static StatusLine parseStatusLine(String line) throws ParseException {
        int resultCode;
        int firstBlank = line.indexOf(32);
        if (firstBlank < 0) {
            throw new ParseException();
        }
        int secondBlank = line.indexOf(32, firstBlank + 1);
        if (secondBlank < 0) {
            secondBlank = line.length();
        }
        try {
            resultCode = Integer.parseUnsignedInt(line.substring(firstBlank + 1, secondBlank));
        }
        catch (NumberFormatException e) {
            throw new ParseException(e);
        }
        String reason = "";
        if (secondBlank < line.length()) {
            reason = line.substring(secondBlank + 1);
        }
        return new StatusLine(line.substring(0, firstBlank), resultCode, reason);
    }

    public static List<AuthenticationChallenge> getAuthenticationHeaders(List<String> reply, String authenticationHeader) {
        String line;
        ArrayList<AuthenticationChallenge> challenges = new ArrayList<AuthenticationChallenge>();
        Iterator<String> lines = reply.iterator();
        lines.next();
        StringBuilder value = null;
        while (lines.hasNext() && !(line = lines.next()).isEmpty()) {
            int firstColon;
            if (Character.isWhitespace(line.charAt(0))) {
                if (value == null) continue;
                int i = HttpParser.skipWhiteSpace(line, 1);
                value.append(' ').append(line, i, line.length());
                continue;
            }
            if (value != null) {
                HttpParser.parseChallenges(challenges, value.toString());
                value = null;
            }
            if ((firstColon = line.indexOf(58)) <= 0 || !authenticationHeader.equalsIgnoreCase(line.substring(0, firstColon + 1))) continue;
            value = new StringBuilder(line.substring(firstColon + 1));
        }
        if (value != null) {
            HttpParser.parseChallenges(challenges, value.toString());
        }
        return challenges;
    }

    private static void parseChallenges(List<AuthenticationChallenge> challenges, String header) {
        int start;
        int end;
        int length = header.length();
        int i = 0;
        while (i < length && (end = HttpParser.scanToken(header, start = HttpParser.skipWhiteSpace(header, i))) > start) {
            AuthenticationChallenge challenge = new AuthenticationChallenge(header.substring(start, end));
            challenges.add(challenge);
            i = HttpParser.parseChallenge(challenge, header, end);
        }
    }

    private static int parseChallenge(AuthenticationChallenge challenge, String header, int from) {
        int length = header.length();
        boolean first = true;
        int start = from;
        while (start <= length) {
            int end = HttpParser.scanToken(header, start = HttpParser.skipWhiteSpace(header, start));
            if (end == start) {
                if (start < header.length() && header.charAt(start) == ',') {
                    return start + 1;
                }
                return start;
            }
            int next = HttpParser.skipWhiteSpace(header, end);
            if (next >= length || header.charAt(next) != '=') {
                if (first) {
                    challenge.setToken(header.substring(start, end));
                    if (next < length && header.charAt(next) == ',') {
                        ++next;
                    }
                    return next;
                }
                return start;
            }
            int nextStart = HttpParser.skipWhiteSpace(header, next + 1);
            if (nextStart >= length) {
                if (next == end) {
                    challenge.setToken(header.substring(start, end + 1));
                } else {
                    challenge.addArgument(header.substring(start, end), null);
                }
                return nextStart;
            }
            if (nextStart == end + 1 && header.charAt(nextStart) == '=') {
                for (end = nextStart + 1; end < length && header.charAt(end) == '='; ++end) {
                }
                challenge.setToken(header.substring(start, end));
                end = HttpParser.skipWhiteSpace(header, end);
                if (end < length && header.charAt(end) == ',') {
                    ++end;
                }
                return end;
            }
            if (header.charAt(nextStart) == ',') {
                if (next == end) {
                    challenge.setToken(header.substring(start, end + 1));
                    return nextStart + 1;
                }
                challenge.addArgument(header.substring(start, end), null);
                start = nextStart + 1;
            } else {
                if (header.charAt(nextStart) == '\"') {
                    int[] nextEnd = new int[]{nextStart + 1};
                    String value = HttpParser.scanQuotedString(header, nextStart + 1, nextEnd);
                    challenge.addArgument(header.substring(start, end), value);
                    start = nextEnd[0];
                } else {
                    int nextEnd = HttpParser.scanToken(header, nextStart);
                    challenge.addArgument(header.substring(start, end), header.substring(nextStart, nextEnd));
                    start = nextEnd;
                }
                start = HttpParser.skipWhiteSpace(header, start);
                if (start < length && header.charAt(start) == ',') {
                    ++start;
                }
            }
            first = false;
        }
        return length;
    }

    private static int skipWhiteSpace(String header, int i) {
        int length = header.length();
        while (i < length && Character.isWhitespace(header.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static String scanQuotedString(String header, int from, int[] to) {
        StringBuilder result = new StringBuilder();
        int length = header.length();
        boolean quoted = false;
        int i = from;
        while (i < length) {
            char c = header.charAt(i++);
            if (quoted) {
                result.append(c);
                quoted = false;
                continue;
            }
            if (c == '\\') {
                quoted = true;
                continue;
            }
            if (c == '\"') break;
            result.append(c);
        }
        to[0] = i;
        return result.toString();
    }

    private static int scanToken(String header, int from) {
        int length = header.length();
        int i = from;
        if (i < 0 || i > length) {
            throw new IndexOutOfBoundsException();
        }
        block3: while (i < length) {
            char c = header.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '^': 
                case '_': 
                case '`': 
                case '|': 
                case '~': {
                    ++i;
                    continue block3;
                }
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                ++i;
                continue;
            }
            return i;
        }
        return i;
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = -1634090143702048640L;

        public ParseException() {
        }

        public ParseException(Throwable cause) {
            super(cause);
        }
    }
}

