/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.KEM;
import org.apache.sshd.common.util.security.SecurityEntityFactory;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleAccessor;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleEdDSAAccessor;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleKEM;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleKEMAccessor;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastlePublicKeyFactory;

public class BouncyCastleSecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    public static final String PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final String FIPS_PROVIDER_CLASS = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    private static final String BCFIPS_PROVIDER_NAME = "BCFIPS";
    private static final String BC_PROVIDER_NAME = "BC";
    private final AtomicReference<Boolean> supportHolder = new AtomicReference<Object>(null);
    private final AtomicReference<String> allSupportHolder = new AtomicReference();
    private final AtomicReference<Boolean> edDSASupportHolder = new AtomicReference<Object>(null);
    private String providerClass;
    private String providerName;
    private boolean useName = true;

    public BouncyCastleSecurityProviderRegistrar() {
        super(BC_PROVIDER_NAME);
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public boolean isNamedProviderUsed() {
        return this.useName;
    }

    @Override
    public Provider getSecurityProvider() {
        try {
            return this.getOrCreateProvider(this.providerClass);
        }
        catch (ReflectiveOperationException t) {
            Throwable e = ExceptionUtils.peelException(t);
            this.log.error("getSecurityProvider({}) failed ({}) to instantiate {}: {}", new Object[]{this.getName(), e.getClass().getSimpleName(), this.providerClass, e.getMessage()});
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getDefaultSecurityEntitySupportValue(Class<?> entityType) {
        String allValue = this.allSupportHolder.get();
        if (GenericUtils.length(allValue) > 0) {
            return allValue;
        }
        String propName = this.getConfigurationPropertyName("supportAll");
        allValue = this.getStringProperty(propName, "all");
        if (GenericUtils.isEmpty(allValue)) {
            allValue = "none";
        }
        this.allSupportHolder.set(allValue);
        return allValue;
    }

    @Override
    public boolean isSecurityEntitySupported(Class<?> entityType, String name) {
        if (!this.isSupported()) {
            return false;
        }
        boolean supported = true;
        if (KeyPairGenerator.class.isAssignableFrom(entityType) || KeyFactory.class.isAssignableFrom(entityType)) {
            if ("Ed25519".equalsIgnoreCase(name)) {
                supported = this.isEdDSASupported();
            }
        } else if (Signature.class.isAssignableFrom(entityType)) {
            if ("Ed25519".equalsIgnoreCase(name)) {
                supported = this.isEdDSASupported();
            }
        } else if (KEM.class.isAssignableFrom(entityType)) {
            supported = BouncyCastleKEMAccessor.INSTANCE.isSupported();
            supported = supported && BouncyCastleKEM.INSTANCE.isSupported(name);
        }
        return supported && super.isSecurityEntitySupported(entityType, name);
    }

    @Override
    public SecurityEntityFactory getFactory() {
        if (this.isNamedProviderUsed()) {
            return new SecurityEntityFactory.Named(this.getProviderName()){

                @Override
                public KEM createKEM(String algorithm) throws GeneralSecurityException {
                    return BouncyCastleKEM.INSTANCE.get(algorithm);
                }
            };
        }
        return new SecurityEntityFactory.ByProvider(this.getSecurityProvider()){

            @Override
            public KEM createKEM(String algorithm) throws GeneralSecurityException {
                return BouncyCastleKEM.INSTANCE.get(algorithm);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        Boolean supported;
        AtomicReference<Boolean> atomicReference = this.supportHolder;
        synchronized (atomicReference) {
            supported = this.supportHolder.get();
            if (supported != null) {
                return supported;
            }
            boolean requireFips = SecurityUtils.isFipsMode();
            if (requireFips) {
                if (BouncyCastleAccessor.INSTANCE.getProviderClass(FIPS_PROVIDER_CLASS) == null) {
                    supported = Boolean.FALSE;
                } else {
                    this.providerClass = FIPS_PROVIDER_CLASS;
                    this.providerName = BCFIPS_PROVIDER_NAME;
                    supported = Boolean.TRUE;
                }
            } else {
                boolean haveBc;
                boolean fipsInstalled = Security.getProvider(BCFIPS_PROVIDER_NAME) != null;
                boolean bcInstalled = Security.getProvider(BC_PROVIDER_NAME) != null;
                boolean haveFips = BouncyCastleAccessor.INSTANCE.getProviderClass(FIPS_PROVIDER_CLASS) != null;
                boolean bl = haveBc = BouncyCastleAccessor.INSTANCE.getProviderClass(PROVIDER_CLASS) != null;
                if (fipsInstalled && haveFips) {
                    this.providerClass = FIPS_PROVIDER_CLASS;
                    this.providerName = BCFIPS_PROVIDER_NAME;
                    this.useName = true;
                    supported = Boolean.TRUE;
                } else if (bcInstalled && haveBc) {
                    this.providerClass = PROVIDER_CLASS;
                    this.providerName = BC_PROVIDER_NAME;
                    this.useName = true;
                    supported = Boolean.TRUE;
                } else if (haveFips) {
                    this.providerClass = FIPS_PROVIDER_CLASS;
                    this.providerName = BCFIPS_PROVIDER_NAME;
                    this.useName = false;
                    supported = Boolean.TRUE;
                } else if (haveBc) {
                    this.providerClass = PROVIDER_CLASS;
                    this.providerName = BC_PROVIDER_NAME;
                    supported = Boolean.TRUE;
                    this.useName = false;
                } else {
                    supported = Boolean.FALSE;
                }
            }
            this.supportHolder.set(supported);
        }
        return supported;
    }

    @Override
    protected Provider createProviderInstance(String providerClassName) throws ReflectiveOperationException {
        Provider result = BouncyCastleAccessor.INSTANCE.createProvider(providerClassName);
        if (result == null) {
            throw new ReflectiveOperationException("Cannot instantiate " + providerClassName);
        }
        return result;
    }

    @Override
    public PublicKey getPublicKey(PrivateKey key) {
        if (this.isEnabled() && this.isEdDSASupported() && key.getClass().getPackage().getName().startsWith("org.bouncycastle.")) {
            return BouncyCastlePublicKeyFactory.INSTANCE.getPublicKey(key);
        }
        return super.getPublicKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEdDSASupported() {
        if (!this.isSupported()) {
            return false;
        }
        AtomicReference<Boolean> atomicReference = this.edDSASupportHolder;
        synchronized (atomicReference) {
            Boolean edDSASupported = this.edDSASupportHolder.get();
            if (edDSASupported != null) {
                return edDSASupported;
            }
            edDSASupported = BouncyCastleEdDSAAccessor.INSTANCE.isSupported();
            this.edDSASupportHolder.set(edDSASupported);
            return edDSASupported;
        }
    }
}

