/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyCustomScopeEvent;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowHandlerFactory;
import javax.faces.flow.FlowNode;
import javax.faces.flow.MethodCallNode;
import javax.faces.flow.ReturnNode;
import javax.faces.flow.SwitchNode;
import javax.faces.flow.ViewNode;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.collections.Predicate;
import org.apache.myfaces.application.ApplicationFactoryImpl;
import org.apache.myfaces.application.BackwardsCompatibleNavigationHandlerWrapper;
import org.apache.myfaces.cdi.dependent.BeanEntry;
import org.apache.myfaces.component.visit.VisitContextFactoryImpl;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.ManagedBeanDestroyer;
import org.apache.myfaces.config.NamedEventManager;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.annotation.AnnotationConfigurator;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.ClientBehaviorRenderer;
import org.apache.myfaces.config.element.ComponentTagDeclaration;
import org.apache.myfaces.config.element.ContractMapping;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigData;
import org.apache.myfaces.config.element.FacesFlowCall;
import org.apache.myfaces.config.element.FacesFlowDefinition;
import org.apache.myfaces.config.element.FacesFlowMethodCall;
import org.apache.myfaces.config.element.FacesFlowMethodParameter;
import org.apache.myfaces.config.element.FacesFlowParameter;
import org.apache.myfaces.config.element.FacesFlowReturn;
import org.apache.myfaces.config.element.FacesFlowSwitch;
import org.apache.myfaces.config.element.FacesFlowView;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NamedEvent;
import org.apache.myfaces.config.element.NavigationCase;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.element.SystemEventListener;
import org.apache.myfaces.config.element.ViewPoolMapping;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.context.ExceptionHandlerFactoryImpl;
import org.apache.myfaces.context.ExternalContextFactoryImpl;
import org.apache.myfaces.context.FacesContextFactoryImpl;
import org.apache.myfaces.context.PartialViewContextFactoryImpl;
import org.apache.myfaces.context.servlet.ServletFlashFactoryImpl;
import org.apache.myfaces.el.DefaultPropertyResolver;
import org.apache.myfaces.el.VariableResolverImpl;
import org.apache.myfaces.flow.FlowCallNodeImpl;
import org.apache.myfaces.flow.FlowHandlerFactoryImpl;
import org.apache.myfaces.flow.FlowImpl;
import org.apache.myfaces.flow.MethodCallNodeImpl;
import org.apache.myfaces.flow.ParameterImpl;
import org.apache.myfaces.flow.ReturnNodeImpl;
import org.apache.myfaces.flow.SwitchCaseImpl;
import org.apache.myfaces.flow.SwitchNodeImpl;
import org.apache.myfaces.flow.ViewNodeImpl;
import org.apache.myfaces.flow.impl.AnnotatedFlowConfigurator;
import org.apache.myfaces.lifecycle.ClientWindowFactoryImpl;
import org.apache.myfaces.lifecycle.LifecycleFactoryImpl;
import org.apache.myfaces.renderkit.LazyRenderKit;
import org.apache.myfaces.renderkit.RenderKitFactoryImpl;
import org.apache.myfaces.renderkit.html.HtmlRenderKitImpl;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.LocaleUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.shared_impl.util.serial.DefaultSerialFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;
import org.apache.myfaces.spi.FacesConfigurationMerger;
import org.apache.myfaces.spi.FacesConfigurationMergerFactory;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.apache.myfaces.spi.ResourceLibraryContractsProvider;
import org.apache.myfaces.spi.ResourceLibraryContractsProviderFactory;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.NavigationUtils;
import org.apache.myfaces.view.ViewDeclarationLanguageFactoryImpl;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.impl.FaceletCacheFactoryImpl;
import org.apache.myfaces.view.facelets.tag.jsf.TagHandlerDelegateFactoryImpl;
import org.apache.myfaces.view.facelets.tag.ui.DebugPhaseListener;
import org.apache.myfaces.webapp.ManagedBeanDestroyerListener;

public class FacesConfigurator {
    private final Class<?>[] NO_PARAMETER_TYPES = new Class[0];
    private final Object[] NO_PARAMETERS = new Object[0];
    private static final Logger log = Logger.getLogger(FacesConfigurator.class.getName());
    private static final String DEFAULT_RENDER_KIT_CLASS = HtmlRenderKitImpl.class.getName();
    private static final String DEFAULT_APPLICATION_FACTORY = ApplicationFactoryImpl.class.getName();
    private static final String DEFAULT_EXTERNAL_CONTEXT_FACTORY = ExternalContextFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = FacesContextFactoryImpl.class.getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = LifecycleFactoryImpl.class.getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = RenderKitFactoryImpl.class.getName();
    private static final String DEFAULT_PARTIAL_VIEW_CONTEXT_FACTORY = PartialViewContextFactoryImpl.class.getName();
    private static final String DEFAULT_VISIT_CONTEXT_FACTORY = VisitContextFactoryImpl.class.getName();
    private static final String DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY = ViewDeclarationLanguageFactoryImpl.class.getName();
    private static final String DEFAULT_EXCEPTION_HANDLER_FACTORY = ExceptionHandlerFactoryImpl.class.getName();
    private static final String DEFAULT_TAG_HANDLER_DELEGATE_FACTORY = TagHandlerDelegateFactoryImpl.class.getName();
    private static final String DEFAULT_FACELET_CACHE_FACTORY = FaceletCacheFactoryImpl.class.getName();
    private static final String DEFAULT_FLASH_FACTORY = ServletFlashFactoryImpl.class.getName();
    private static final String DEFAULT_CLIENT_WINDOW_FACTORY = ClientWindowFactoryImpl.class.getName();
    private static final String DEFAULT_FLOW_FACTORY = FlowHandlerFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final String INJECTED_BEAN_STORAGE_KEY = "org.apache.myfaces.spi.BEAN_ENTRY_STORAGE";
    public static final String ENABLE_DEFAULT_WINDOW_MODE = "org.apache.myfaces.ENABLE_DEFAULT_WINDOW_MODE";
    private static final String PARAM_FACELETS_LIBRARIES_DEPRECATED = "facelets.LIBRARIES";
    private static final String[] PARAMS_FACELETS_LIBRARIES = new String[]{"javax.faces.FACELETS_LIBRARIES", "facelets.LIBRARIES"};
    private final ExternalContext _externalContext;
    private FacesContext _facesContext;
    private FacesConfigUnmarshaller<? extends FacesConfig> _unmarshaller;
    private FacesConfigData _dispenser;
    private AnnotationConfigurator _annotationConfigurator;
    private RuntimeConfig _runtimeConfig;
    private Application _application;
    private InjectionProvider _injectionProvider;
    private static long lastUpdate;

    public FacesConfigurator(ExternalContext externalContext) {
        if (externalContext == null) {
            throw new IllegalArgumentException("external context must not be null");
        }
        this._externalContext = externalContext;
        if (this._externalContext.getApplicationMap().get(INJECTED_BEAN_STORAGE_KEY) == null) {
            this._externalContext.getApplicationMap().put(INJECTED_BEAN_STORAGE_KEY, new CopyOnWriteArrayList());
        }
    }

    public void setUnmarshaller(FacesConfigUnmarshaller<? extends FacesConfig> unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller<? extends FacesConfig> getUnmarshaller() {
        if (this._unmarshaller == null) {
            this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        }
        return this._unmarshaller;
    }

    public void setDispenser(FacesConfigData dispenser) {
        this._dispenser = dispenser;
    }

    protected FacesConfigData getDispenser() {
        if (this._dispenser == null) {
            this._dispenser = new DigesterFacesConfigDispenserImpl();
        }
        return this._dispenser;
    }

    public void setAnnotationConfigurator(AnnotationConfigurator configurator) {
        this._annotationConfigurator = configurator;
    }

    protected AnnotationConfigurator getAnnotationConfigurator() {
        if (this._annotationConfigurator == null) {
            this._annotationConfigurator = new AnnotationConfigurator();
        }
        return this._annotationConfigurator;
    }

    private long getResourceLastModified(String resource) {
        try {
            URL url = this._externalContext.getResource(resource);
            if (url != null) {
                return this.getResourceLastModified(url);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read resource " + resource, e);
        }
        return 0L;
    }

    private long getResourceLastModified(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String externalForm = url.toExternalForm();
            File file = new File(externalForm.substring(5));
            return file.lastModified();
        }
        return this.getResourceLastModified(url.openConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getResourceLastModified(URLConnection connection) throws IOException {
        long modified;
        if (connection instanceof JarURLConnection) {
            URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
            URLConnection jarFileConnection = jarFileUrl.openConnection();
            try {
                modified = jarFileConnection.getLastModified();
            }
            finally {
                try {
                    jarFileConnection.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        modified = connection.getLastModified();
        return modified;
    }

    private long getLastModifiedTime() {
        Set<String> directoryPaths;
        long lastModified = 0L;
        long resModified = this.getResourceLastModified(DEFAULT_FACES_CONFIG);
        if (resModified > lastModified) {
            lastModified = resModified;
        }
        List<String> configFilesList = this.getConfigFilesList();
        int size = configFilesList.size();
        for (int i = 0; i < size; ++i) {
            String systemId = configFilesList.get(i);
            resModified = this.getResourceLastModified(systemId);
            if (resModified <= lastModified) continue;
            lastModified = resModified;
        }
        String faceletsFiles = WebConfigParamUtils.getStringInitParameter(this._externalContext, PARAMS_FACELETS_LIBRARIES);
        if (faceletsFiles != null) {
            for (String systemId : StringUtils.trim(faceletsFiles.split(";"))) {
                resModified = this.getResourceLastModified(systemId);
                if (resModified <= lastModified) continue;
                lastModified = resModified;
            }
        }
        if ((directoryPaths = this._externalContext.getResourcePaths("/")) != null) {
            List<String> contextSpecifiedList = configFilesList;
            for (String dirPath : directoryPaths) {
                if (dirPath.equals("/WEB-INF/")) {
                    Set<String> webDirectoryPaths = this._externalContext.getResourcePaths(dirPath);
                    for (String webDirPath : webDirectoryPaths) {
                        if (!webDirPath.endsWith("/") || webDirPath.equals("/WEB-INF/classes/")) continue;
                        String flowName = webDirPath.substring(9, webDirPath.length() - 1);
                        String filePath = webDirPath + flowName + "-flow.xml";
                        if (contextSpecifiedList.contains(filePath) || (resModified = this.getResourceLastModified(filePath)) <= lastModified) continue;
                        lastModified = resModified;
                    }
                    continue;
                }
                if (dirPath.startsWith("/META-INF") || !dirPath.endsWith("/")) continue;
                String flowName = dirPath.substring(1, dirPath.length() - 1);
                String filePath = dirPath + flowName + "-flow.xml";
                if (contextSpecifiedList.contains(filePath) || (resModified = this.getResourceLastModified(filePath)) <= lastModified) continue;
                lastModified = resModified;
            }
        }
        return lastModified;
    }

    public void update() {
        if (ContainerUtils.isRunningOnGoogleAppEngine(this._externalContext)) {
            return;
        }
        long refreshPeriod = MyfacesConfig.getCurrentInstance(this._externalContext).getConfigRefreshPeriod() * 1000L;
        if (refreshPeriod > 0L) {
            long ttl = lastUpdate + refreshPeriod;
            if (System.currentTimeMillis() > ttl && this.getLastModifiedTime() > ttl) {
                boolean purged = false;
                try {
                    purged = this.purgeConfiguration();
                }
                catch (NoSuchMethodException e) {
                    log.severe("Configuration objects do not support clean-up. Update aborted");
                    lastUpdate = System.currentTimeMillis();
                    return;
                }
                catch (IllegalAccessException e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                }
                if (purged) {
                    this.configure();
                    FacesContext facesContext = this.getFacesContext();
                    Application application = facesContext.getApplication();
                    application.publishEvent(facesContext, PostConstructApplicationEvent.class, Application.class, application);
                }
            }
        }
    }

    private boolean purgeConfiguration() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        Method appFactoryPurgeMethod = this.getPurgeMethod(applicationFactory, "purgeApplication", this.NO_PARAMETER_TYPES);
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        Method renderKitPurgeMethod = this.getPurgeMethod(renderKitFactory, "purgeRenderKit", this.NO_PARAMETER_TYPES);
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        Method lifecyclePurgeMethod = this.getPurgeMethod(lifecycleFactory, "purgeLifecycle", this.NO_PARAMETER_TYPES);
        FacesContext facesContext = this.getFacesContext();
        Method facesContextPurgeMethod = this.getPurgeMethod(facesContext, "purgeFacesContext", this.NO_PARAMETER_TYPES);
        if (appFactoryPurgeMethod != null && renderKitPurgeMethod != null && lifecyclePurgeMethod != null && facesContextPurgeMethod != null) {
            appFactoryPurgeMethod.invoke((Object)applicationFactory, this.NO_PARAMETERS);
            renderKitPurgeMethod.invoke((Object)renderKitFactory, this.NO_PARAMETERS);
            RuntimeConfig.getCurrentInstance(this._externalContext).purge();
            lifecyclePurgeMethod.invoke((Object)lifecycleFactory, this.NO_PARAMETERS);
            facesContextPurgeMethod.invoke((Object)facesContext, this.NO_PARAMETERS);
            this._externalContext.getApplicationMap().remove("org.apache.myfaces.lifecycle.first.request.processed");
            return true;
        }
        return false;
    }

    private Method getPurgeMethod(Object instance, String methodName, Class<?>[] parameters) {
        while (instance != null) {
            Method purgeMethod = null;
            try {
                purgeMethod = instance.getClass().getMethod(methodName, parameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (purgeMethod != null) {
                return purgeMethod;
            }
            if (!(instance instanceof FacesWrapper)) continue;
            instance = ((FacesWrapper)instance).getWrapped();
        }
        return null;
    }

    public void configure() throws FacesException {
        FacesConfigurationMerger facesConfigurationMerger = FacesConfigurationMergerFactory.getFacesConfigurationMergerFactory(this._externalContext).getFacesConfigurationMerger(this._externalContext);
        this.setDispenser(facesConfigurationMerger.getFacesConfigData(this._externalContext));
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.configureRuntimeConfig();
        this.configureLifecycle();
        this.handleSerialFactory();
        this.configureManagedBeanDestroyer();
        this.configureFlowHandler();
        this.configureProtectedViews();
        lastUpdate = System.currentTimeMillis();
    }

    private List<String> getConfigFilesList() {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.warning("/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void configureFactories() {
        FacesConfigData dispenser = this.getDispenser();
        this.setFactories("javax.faces.application.ApplicationFactory", dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.ExceptionHandlerFactory", dispenser.getExceptionHandlerFactoryIterator(), DEFAULT_EXCEPTION_HANDLER_FACTORY);
        this.setFactories("javax.faces.context.ExternalContextFactory", dispenser.getExternalContextFactoryIterator(), DEFAULT_EXTERNAL_CONTEXT_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.lifecycle.LifecycleFactory", dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("javax.faces.render.RenderKitFactory", dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
        this.setFactories("javax.faces.view.facelets.TagHandlerDelegateFactory", dispenser.getTagHandlerDelegateFactoryIterator(), DEFAULT_TAG_HANDLER_DELEGATE_FACTORY);
        this.setFactories("javax.faces.context.PartialViewContextFactory", dispenser.getPartialViewContextFactoryIterator(), DEFAULT_PARTIAL_VIEW_CONTEXT_FACTORY);
        this.setFactories("javax.faces.component.visit.VisitContextFactory", dispenser.getVisitContextFactoryIterator(), DEFAULT_VISIT_CONTEXT_FACTORY);
        this.setFactories("javax.faces.view.ViewDeclarationLanguageFactory", dispenser.getViewDeclarationLanguageFactoryIterator(), DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY);
        this.setFactories("javax.faces.view.facelets.FaceletCacheFactory", dispenser.getFaceletCacheFactoryIterator(), DEFAULT_FACELET_CACHE_FACTORY);
        this.setFactories("javax.faces.context.FlashFactory", dispenser.getFlashFactoryIterator(), DEFAULT_FLASH_FACTORY);
        this.setFactories("javax.faces.lifecycle.ClientWindowFactory", dispenser.getClientWindowFactoryIterator(), DEFAULT_CLIENT_WINDOW_FACTORY);
        this.setFactories("javax.faces.flow.FlowHandlerFactory", dispenser.getFlowHandlerFactoryIterator(), DEFAULT_FLOW_FACTORY);
    }

    private void setFactories(String factoryName, Collection<String> factories, String defaultFactory) {
        FactoryFinder.setFactory(factoryName, defaultFactory);
        for (String factory : factories) {
            if (factory.equals(defaultFactory)) continue;
            FactoryFinder.setFactory(factoryName, factory);
        }
    }

    private void configureApplication() {
        Application application = ((ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory")).getApplication();
        FacesConfigData dispenser = this.getDispenser();
        ActionListener actionListener = ClassUtils.buildApplicationObject(ActionListener.class, dispenser.getActionListenerIterator(), null);
        this._callInjectAndPostConstruct(actionListener);
        application.setActionListener(actionListener);
        if (dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(dispenser.getDefaultLocale()));
        }
        if (dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(dispenser.getDefaultRenderKitId());
        }
        if (dispenser.getMessageBundle() != null) {
            application.setMessageBundle(dispenser.getMessageBundle());
        }
        NavigationHandler navigationHandler = ClassUtils.buildApplicationObject(NavigationHandler.class, ConfigurableNavigationHandler.class, BackwardsCompatibleNavigationHandlerWrapper.class, dispenser.getNavigationHandlerIterator(), application.getNavigationHandler());
        this._callInjectAndPostConstruct(navigationHandler);
        application.setNavigationHandler(navigationHandler);
        StateManager stateManager = ClassUtils.buildApplicationObject(StateManager.class, dispenser.getStateManagerIterator(), application.getStateManager());
        this._callInjectAndPostConstruct(stateManager);
        application.setStateManager(stateManager);
        ResourceHandler resourceHandler = ClassUtils.buildApplicationObject(ResourceHandler.class, dispenser.getResourceHandlerIterator(), application.getResourceHandler());
        this._callInjectAndPostConstruct(resourceHandler);
        application.setResourceHandler(resourceHandler);
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String string : dispenser.getSupportedLocalesIterator()) {
            locales.add(LocaleUtils.toLocale(string));
        }
        application.setSupportedLocales(locales);
        application.setViewHandler(ClassUtils.buildApplicationObject(ViewHandler.class, dispenser.getViewHandlerIterator(), application.getViewHandler()));
        RuntimeConfig runtimeConfig = this.getRuntimeConfig();
        for (SystemEventListener systemEventListener : dispenser.getSystemEventListeners()) {
            try {
                Class eventClass = ClassUtils.classForName(systemEventListener.getSystemEventClass() != null ? systemEventListener.getSystemEventClass() : SystemEvent.class.getName());
                Iterator<Behavior> listener = (javax.faces.event.SystemEventListener)ClassUtils.newInstance(systemEventListener.getSystemEventListenerClass());
                this._callInjectAndPostConstruct(listener);
                runtimeConfig.addInjectedObject(listener);
                if (systemEventListener.getSourceClass() != null && systemEventListener.getSourceClass().length() > 0) {
                    application.subscribeToEvent(eventClass, ClassUtils.classForName(systemEventListener.getSourceClass()), (javax.faces.event.SystemEventListener)((Object)listener));
                    continue;
                }
                application.subscribeToEvent(eventClass, (javax.faces.event.SystemEventListener)((Object)listener));
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, "System event listener could not be initialized, reason:", e);
            }
        }
        for (Map.Entry<String, String> entry : dispenser.getComponentClassesByType().entrySet()) {
            application.addComponent(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : dispenser.getConverterClassesById().entrySet()) {
            application.addConverter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : dispenser.getConverterClassesByClass().entrySet()) {
            try {
                application.addConverter(ClassUtils.simpleClassForName(entry.getKey()), entry.getValue());
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Converter could not be added. Reason:", ex);
            }
        }
        for (Map.Entry<String, String> entry : dispenser.getValidatorClassesById().entrySet()) {
            application.addValidator(entry.getKey(), entry.getValue());
        }
        String string = this._externalContext.getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR");
        boolean defaultBeanValidatorDisabled = string != null && string.toLowerCase().equals("true");
        boolean beanValidatorInstalledProgrammatically = false;
        if (!defaultBeanValidatorDisabled && ExternalSpecifications.isBeanValidationAvailable()) {
            application.addDefaultValidatorId("javax.faces.Bean");
            beanValidatorInstalledProgrammatically = true;
        }
        for (String validatorId : dispenser.getDefaultValidatorIds()) {
            application.addDefaultValidatorId(validatorId);
        }
        if (!beanValidatorInstalledProgrammatically && application.getDefaultValidatorInfo().containsKey("javax.faces.Bean")) {
            if (!ExternalSpecifications.isBeanValidationAvailable()) {
                log.log(Level.WARNING, "The BeanValidator was installed as a default-validator from a faces-config file, but bean validation is not available on the classpath, thus it will not work!");
            } else if (defaultBeanValidatorDisabled) {
                log.log(Level.INFO, "The BeanValidator was disabled as a default-validator via the config parameter javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR in web.xml, but a faces-config file added it, thus it actually was installed as a default-validator.");
            }
        }
        for (Behavior behavior : dispenser.getBehaviors()) {
            application.addBehavior(behavior.getBehaviorId(), behavior.getBehaviorClass());
        }
        FlowHandlerFactory flowHandlerFactory = (FlowHandlerFactory)FactoryFinder.getFactory("javax.faces.flow.FlowHandlerFactory");
        FlowHandler flowHandler = flowHandlerFactory.createFlowHandler(this.getFacesContext());
        application.setFlowHandler(flowHandler);
        if (MyfacesConfig.getCurrentInstance(this._externalContext).isSupportJSPAndFacesEL()) {
            runtimeConfig.setPropertyResolverChainHead(ClassUtils.buildApplicationObject(PropertyResolver.class, dispenser.getPropertyResolverIterator(), new DefaultPropertyResolver()));
            runtimeConfig.setVariableResolverChainHead(ClassUtils.buildApplicationObject(VariableResolver.class, dispenser.getVariableResolverIterator(), new VariableResolverImpl()));
        }
        for (ContractMapping mapping : dispenser.getResourceLibraryContractMappings()) {
            if (mapping.getUrlPattern() != null) {
                String urlPattern = mapping.getUrlPattern();
                String[] contracts = StringUtils.trim(StringUtils.splitShortString(mapping.getContracts(), ' '));
                runtimeConfig.addContractMapping(urlPattern, contracts);
                continue;
            }
            List<String> urlMappingsList = mapping.getUrlPatternList();
            for (String urlPattern : urlMappingsList) {
                for (String contract : mapping.getContractList()) {
                    String[] contracts = StringUtils.trim(StringUtils.splitShortString(contract, ' '));
                    runtimeConfig.addContractMapping(urlPattern, contracts);
                }
            }
        }
        this.setApplication(application);
    }

    private void _callInjectAndPostConstruct(Object instance) {
        try {
            Object innerInstance;
            if (instance instanceof FacesWrapper && (innerInstance = ((FacesWrapper)instance).getWrapped()) != null) {
                this._callInjectAndPostConstruct(innerInstance);
            }
            List injectedBeanStorage = (List)this._externalContext.getApplicationMap().get(INJECTED_BEAN_STORAGE_KEY);
            Object creationMetaData = this.getInjectionProvider().inject(instance);
            injectedBeanStorage.add(new BeanEntry(instance, creationMetaData));
            this.getInjectionProvider().postConstruct(instance, creationMetaData);
        }
        catch (InjectionProviderException ex) {
            log.log(Level.INFO, "Exception on PreDestroy", ex);
        }
    }

    String getDefaultSourcClassForSystemEvent(Class systemEventClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constr : constructors = systemEventClass.getConstructors()) {
            Class<?>[] parms = constr.getParameterTypes();
            if (parms == null || parms.length != 1) continue;
            return parms[0].getName();
        }
        log.warning("The SystemEvent source type for " + systemEventClass.getName() + " could not be detected, either register it manually or use a constructor argument for auto detection, defaulting now to java.lang.Object");
        return "java.lang.Object";
    }

    protected RuntimeConfig getRuntimeConfig() {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        }
        return this._runtimeConfig;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this._runtimeConfig = runtimeConfig;
    }

    private void configureRuntimeConfig() {
        ArrayList<String> knownNamespaces;
        FacesConfigData dispenser;
        RuntimeConfig runtimeConfig;
        block33: {
            Object clazz;
            runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
            dispenser = this.getDispenser();
            knownNamespaces = new ArrayList<String>();
            for (ComponentTagDeclaration componentTagDeclaration : dispenser.getComponentTagDeclarations()) {
                runtimeConfig.addComponentTagDeclaration(componentTagDeclaration);
                if (componentTagDeclaration.getNamespace() == null) continue;
                knownNamespaces.add(componentTagDeclaration.getNamespace());
            }
            for (ManagedBean managedBean : dispenser.getManagedBeans()) {
                if (log.isLoggable(Level.WARNING) && runtimeConfig.getManagedBean(managedBean.getManagedBeanName()) != null) {
                    log.warning("More than one managed bean w/ the name of '" + managedBean.getManagedBeanName() + "' - only keeping the last ");
                }
                runtimeConfig.addManagedBean(managedBean.getManagedBeanName(), managedBean);
            }
            this.removePurgedBeansFromSessionAndApplication(runtimeConfig);
            for (NavigationRule navigationRule : dispenser.getNavigationRules()) {
                runtimeConfig.addNavigationRule(navigationRule);
            }
            for (String string : dispenser.getConverterConfigurationByClassName()) {
                runtimeConfig.addConverterConfiguration(string, this._dispenser.getConverterConfiguration(string));
            }
            for (ResourceBundle resourceBundle : dispenser.getResourceBundles()) {
                runtimeConfig.addResourceBundle(resourceBundle);
            }
            List injectedBeansAndMetaData = (List)this._externalContext.getApplicationMap().get(INJECTED_BEAN_STORAGE_KEY);
            for (String className : dispenser.getElResolvers()) {
                ELResolver elResolver = (ELResolver)ClassUtils.newInstance(className, ELResolver.class);
                try {
                    Object creationMetaData = this.getInjectionProvider().inject(elResolver);
                    injectedBeansAndMetaData.add(new BeanEntry(elResolver, creationMetaData));
                    this.getInjectionProvider().postConstruct(elResolver, creationMetaData);
                }
                catch (InjectionProviderException e) {
                    log.log(Level.SEVERE, "Error while injecting ELResolver", e);
                }
                runtimeConfig.addFacesConfigElResolver(elResolver);
            }
            runtimeConfig.setFacesVersion(dispenser.getFacesVersion());
            runtimeConfig.setNamedEventManager(new NamedEventManager());
            for (NamedEvent event : dispenser.getNamedEvents()) {
                try {
                    clazz = ClassUtils.classForName(event.getEventClass());
                    runtimeConfig.getNamedEventManager().addNamedEvent(event.getShortName(), (Class<? extends ComponentSystemEvent>)clazz);
                }
                catch (ClassNotFoundException e) {
                    log.log(Level.SEVERE, "Named event could not be initialized, reason:", e);
                }
            }
            String string = this._externalContext.getInitParameter("org.apache.myfaces.EL_RESOLVER_COMPARATOR");
            if (string != null && !"".equals(string)) {
                try {
                    Class clazz2 = ClassUtils.classForName(string);
                    Comparator comparator = (Comparator)ClassUtils.newInstance(clazz2);
                    runtimeConfig.setELResolverComparator(comparator);
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.log(Level.SEVERE, "Cannot instantiate EL Resolver Comparator " + string + " . Check org.apache.myfaces.EL_RESOLVER_COMPARATOR web config param. Initialization continues with no comparator used.", e);
                    }
                }
            } else {
                runtimeConfig.setELResolverComparator(null);
            }
            String elResolverPredicateClass = this._externalContext.getInitParameter("org.apache.myfaces.EL_RESOLVER_PREDICATE");
            if (elResolverPredicateClass != null && !"".equals(elResolverPredicateClass)) {
                try {
                    clazz = ClassUtils.classForName(elResolverPredicateClass);
                    Predicate elResolverPredicate = (Predicate)ClassUtils.newInstance(clazz);
                    runtimeConfig.setELResolverPredicate(elResolverPredicate);
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.SEVERE)) {
                        log.log(Level.SEVERE, "Cannot instantiate EL Resolver Comparator " + string + " . Check org.apache.myfaces.EL_RESOLVER_COMPARATOR web config param. Initialization continues with no comparator used.", e);
                    }
                }
            } else {
                runtimeConfig.setELResolverPredicate(null);
            }
            for (FaceletsProcessing faceletsProcessing : dispenser.getFaceletsProcessing()) {
                runtimeConfig.addFaceletProcessingConfiguration(faceletsProcessing.getFileExtension(), faceletsProcessing);
            }
            ResourceLibraryContractsProvider rlcp = ResourceLibraryContractsProviderFactory.getFacesConfigResourceProviderFactory(this._externalContext).createResourceLibraryContractsProvider(this._externalContext);
            try {
                runtimeConfig.setExternalContextResourceLibraryContracts(rlcp.getExternalContextResourceLibraryContracts(this._externalContext));
                runtimeConfig.setClassLoaderResourceLibraryContracts(rlcp.getClassloaderResourceLibraryContracts(this._externalContext));
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.SEVERE)) break block33;
                log.log(Level.SEVERE, "An error was found when scanning for resource library contracts", e);
            }
        }
        if (log.isLoggable(Level.INFO)) {
            for (List<String> list : runtimeConfig.getContractMappings().values()) {
                for (String contract : list) {
                    if (runtimeConfig.getResourceLibraryContracts().contains(contract)) continue;
                    log.log(Level.INFO, "Resource Library Contract " + contract + " was not found while scanning for available contracts.");
                }
            }
        }
        if (runtimeConfig.getContractMappings().isEmpty()) {
            String[] contracts = runtimeConfig.getResourceLibraryContracts().toArray(new String[runtimeConfig.getResourceLibraryContracts().size()]);
            runtimeConfig.addContractMapping("*", contracts);
        }
        for (String resourceResolver : dispenser.getResourceResolvers()) {
            runtimeConfig.addResourceResolver(resourceResolver);
        }
        for (FaceletTagLibrary faceletTagLibrary : dispenser.getTagLibraries()) {
            runtimeConfig.addFaceletTagLibrary(faceletTagLibrary);
            if (faceletTagLibrary.getNamespace() == null) continue;
            knownNamespaces.add(faceletTagLibrary.getNamespace());
        }
        knownNamespaces.add("http://xmlns.jcp.org/jsf/core");
        knownNamespaces.add("http://java.sun.com/jsf/core");
        knownNamespaces.add("http://xmlns.jcp.org/jsf/html");
        knownNamespaces.add("http://java.sun.com/jsf/html");
        knownNamespaces.add("http://xmlns.jcp.org/jsf/facelets");
        knownNamespaces.add("http://java.sun.com/jsf/facelets");
        knownNamespaces.add("http://xmlns.jcp.org/jsp/jstl/core");
        knownNamespaces.add("http://java.sun.com/jsp/jstl/core");
        knownNamespaces.add("http://java.sun.com/jstl/core");
        knownNamespaces.add("http://xmlns.jcp.org/jsp/jstl/functions");
        knownNamespaces.add("http://java.sun.com/jsp/jstl/functions");
        knownNamespaces.add("http://xmlns.jcp.org/jsf/composite");
        knownNamespaces.add("http://java.sun.com/jsf/composite");
        knownNamespaces.add("http://xmlns.jcp.org/jsf");
        knownNamespaces.add("http://java.sun.com/jsf");
        knownNamespaces.add("http://xmlns.jcp.org/jsf/passthrough");
        knownNamespaces.add("http://java.sun.com/jsf/passthrough");
        HashMap namespaceById = new HashMap();
        HashMap idByNamespace = new HashMap();
        Collections.sort(knownNamespaces);
        for (int i = 0; i < knownNamespaces.size(); ++i) {
            namespaceById.put(i, knownNamespaces.get(i));
            idByNamespace.put(knownNamespaces.get(i), i);
        }
        runtimeConfig.setNamespaceById(Collections.unmodifiableMap(namespaceById));
        runtimeConfig.setIdByNamespace(Collections.unmodifiableMap(idByNamespace));
        for (ViewPoolMapping viewPoolMapping : dispenser.getViewPoolMappings()) {
            runtimeConfig.addViewPoolMapping(viewPoolMapping);
        }
    }

    private void removePurgedBeansFromSessionAndApplication(RuntimeConfig runtimeConfig) {
        Map<String, ManagedBean> oldManagedBeans = runtimeConfig.getManagedBeansNotReaddedAfterPurge();
        if (oldManagedBeans != null) {
            for (Map.Entry<String, ManagedBean> entry : oldManagedBeans.entrySet()) {
                ManagedBean bean = entry.getValue();
                String scope = bean.getManagedBeanScope();
                if (scope != null && scope.equalsIgnoreCase("session")) {
                    this._externalContext.getSessionMap().remove(entry.getKey());
                    continue;
                }
                if (scope == null || !scope.equalsIgnoreCase("application")) continue;
                this._externalContext.getApplicationMap().remove(entry.getKey());
            }
        }
        runtimeConfig.resetManagedBeansNotReaddedAfterPurge();
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        FacesConfigData dispenser = this.getDispenser();
        for (String renderKitId : dispenser.getRenderKitIds()) {
            Collection<String> renderKitClass = dispenser.getRenderKitClasses(renderKitId);
            if (renderKitClass.isEmpty()) {
                renderKitClass = new ArrayList<String>(1);
                renderKitClass.add(DEFAULT_RENDER_KIT_CLASS);
            }
            RenderKit renderKit = ClassUtils.buildApplicationObject(RenderKit.class, renderKitClass, null);
            boolean lazyRenderKit = renderKit instanceof LazyRenderKit;
            for (Renderer element : dispenser.getRenderers(renderKitId)) {
                if (element.getRendererClass() != null) {
                    javax.faces.render.Renderer renderer;
                    if (lazyRenderKit) {
                        ((LazyRenderKit)((Object)renderKit)).addRenderer(element.getComponentFamily(), element.getRendererType(), element.getRendererClass());
                        continue;
                    }
                    try {
                        renderer = (javax.faces.render.Renderer)ClassUtils.newInstance(element.getRendererClass());
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, "failed to configure class " + element.getRendererClass(), e);
                        continue;
                    }
                    if (renderer != null) {
                        renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
                        continue;
                    }
                    log.log(Level.INFO, "Renderer instance cannot be created for " + element.getRendererClass() + ", ignoring..." + element.getRendererClass());
                    continue;
                }
                log.log(Level.INFO, "Renderer element with no rendererClass found, ignoring..." + element.getRendererClass());
            }
            Collection<ClientBehaviorRenderer> clientBehaviorRenderers = dispenser.getClientBehaviorRenderers(renderKitId);
            for (ClientBehaviorRenderer clientBehaviorRenderer : clientBehaviorRenderers) {
                try {
                    javax.faces.render.ClientBehaviorRenderer behaviorRenderer = (javax.faces.render.ClientBehaviorRenderer)ClassUtils.newInstance(clientBehaviorRenderer.getRendererClass());
                    renderKit.addClientBehaviorRenderer(clientBehaviorRenderer.getRendererType(), behaviorRenderer);
                }
                catch (Throwable e) {
                    if (!log.isLoggable(Level.SEVERE)) continue;
                    log.log(Level.SEVERE, "failed to configure client behavior renderer class " + clientBehaviorRenderer.getRendererClass(), e);
                }
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
        List injectedBeanStorage = (List)this._externalContext.getApplicationMap().get(INJECTED_BEAN_STORAGE_KEY);
        Iterator<String> it = lifecycleFactory.getLifecycleIds();
        while (it.hasNext()) {
            Lifecycle lifecycle = lifecycleFactory.getLifecycle(it.next());
            for (String listenerClassName : this.getDispenser().getLifecyclePhaseListeners()) {
                try {
                    PhaseListener listener = (PhaseListener)ClassUtils.newInstance(listenerClassName, PhaseListener.class);
                    Object creationMetaData = this.getInjectionProvider().inject(listener);
                    injectedBeanStorage.add(new BeanEntry(listener, creationMetaData));
                    this.getInjectionProvider().postConstruct(listener, creationMetaData);
                    lifecycle.addPhaseListener(listener);
                }
                catch (ClassCastException e) {
                    log.severe("Class " + listenerClassName + " does not implement PhaseListener");
                }
                catch (InjectionProviderException e) {
                    log.log(Level.SEVERE, "Error while injecting PhaseListener", e);
                }
            }
            FacesContext facesContext = this.getFacesContext();
            if (!facesContext.isProjectStage(ProjectStage.Development) || !MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isDebugPhaseListenerEnabled()) continue;
            lifecycle.addPhaseListener(new DebugPhaseListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerialFactory() {
        String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
        SerialFactory serialFactory = null;
        if (serialProvider == null) {
            serialFactory = new DefaultSerialFactory();
        } else {
            try {
                serialFactory = (SerialFactory)ClassUtils.newInstance(serialProvider);
            }
            catch (ClassCastException e) {
                log.log(Level.SEVERE, "Make sure '" + serialProvider + "' implements the correct interface", e);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", e);
            }
            finally {
                if (serialFactory == null) {
                    serialFactory = new DefaultSerialFactory();
                    log.severe("Using default serialization provider");
                }
            }
        }
        log.info("Serialization provider : " + serialFactory.getClass());
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }

    private void configureManagedBeanDestroyer() {
        FacesContext facesContext = this.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        Map<String, Object> applicationMap = externalContext.getApplicationMap();
        Application application = facesContext.getApplication();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        LifecycleProvider lifecycleProvider = LifecycleProviderFactory.getLifecycleProviderFactory(externalContext).getLifecycleProvider(externalContext);
        ManagedBeanDestroyer mbDestroyer = new ManagedBeanDestroyer(lifecycleProvider, runtimeConfig);
        application.subscribeToEvent(PreDestroyCustomScopeEvent.class, mbDestroyer);
        application.subscribeToEvent(PreDestroyViewMapEvent.class, mbDestroyer);
        ManagedBeanDestroyerListener listener = (ManagedBeanDestroyerListener)applicationMap.get("org.apache.myfaces.ManagedBeanDestroyerListener");
        if (listener != null) {
            listener.setManagedBeanDestroyer(mbDestroyer);
        } else {
            log.log(Level.SEVERE, "No ManagedBeanDestroyerListener instance found, thus @PreDestroy methods won't get called in every case. This instance needs to be published before configuration is started.");
        }
    }

    private void configureFlowHandler() {
        FacesContext facesContext = this.getFacesContext();
        Application application = this.getApplication();
        FacesConfigData dispenser = this.getDispenser();
        if (!dispenser.getFacesFlowDefinitions().isEmpty()) {
            FacesConfigurator.enableDefaultWindowMode(facesContext);
        }
        for (FacesFlowDefinition flowDefinition : dispenser.getFacesFlowDefinitions()) {
            FlowNode node;
            FlowImpl flow = new FlowImpl();
            flow.setId(flowDefinition.getId());
            flow.setDefiningDocumentId(flowDefinition.getDefiningDocumentId());
            flow.setStartNodeId(flowDefinition.getStartNode());
            if (!this.isEmptyString(flowDefinition.getInitializer())) {
                flow.setInitializer(application.getExpressionFactory().createMethodExpression(facesContext.getELContext(), flowDefinition.getInitializer(), null, (Class[])this.NO_PARAMETER_TYPES));
            }
            if (!this.isEmptyString(flowDefinition.getFinalizer())) {
                flow.setFinalizer(application.getExpressionFactory().createMethodExpression(facesContext.getELContext(), flowDefinition.getFinalizer(), null, (Class[])this.NO_PARAMETER_TYPES));
            }
            for (FacesFlowCall call : flowDefinition.getFlowCallList()) {
                node = new FlowCallNodeImpl(call.getId());
                if (call.getFlowReference() != null) {
                    ((FlowCallNodeImpl)node).setCalledFlowId(call.getFlowReference().getFlowId());
                    ((FlowCallNodeImpl)node).setCalledFlowDocumentId(call.getFlowReference().getFlowDocumentId());
                }
                for (FacesFlowParameter facesFlowParameter : call.getOutboundParameterList()) {
                    ((FlowCallNodeImpl)node).putOutboundParameter(facesFlowParameter.getName(), new ParameterImpl(facesFlowParameter.getName(), application.getExpressionFactory().createValueExpression(facesContext.getELContext(), facesFlowParameter.getValue(), Object.class)));
                }
                flow.putFlowCall(((FlowCallNodeImpl)node).getId(), (FlowCallNode)node);
            }
            for (FacesFlowMethodCall methodCall : flowDefinition.getMethodCallList()) {
                node = new MethodCallNodeImpl(methodCall.getId());
                if (!this.isEmptyString(methodCall.getMethod())) {
                    ((MethodCallNodeImpl)node).setMethodExpression(application.getExpressionFactory().createMethodExpression(facesContext.getELContext(), methodCall.getMethod(), null, (Class[])this.NO_PARAMETER_TYPES));
                }
                if (!this.isEmptyString(methodCall.getDefaultOutcome())) {
                    ((MethodCallNodeImpl)node).setOutcome(application.getExpressionFactory().createValueExpression(facesContext.getELContext(), methodCall.getDefaultOutcome(), Object.class));
                }
                for (FacesFlowMethodParameter facesFlowMethodParameter : methodCall.getParameterList()) {
                    ((MethodCallNodeImpl)node).addParameter(new ParameterImpl(facesFlowMethodParameter.getClassName(), application.getExpressionFactory().createValueExpression(facesContext.getELContext(), facesFlowMethodParameter.getValue(), Object.class)));
                }
                flow.addMethodCall((MethodCallNode)node);
            }
            for (FacesFlowParameter parameter : flowDefinition.getInboundParameterList()) {
                flow.putInboundParameter(parameter.getName(), new ParameterImpl(parameter.getName(), application.getExpressionFactory().createValueExpression(facesContext.getELContext(), parameter.getValue(), Object.class)));
            }
            for (NavigationRule rule : flowDefinition.getNavigationRuleList()) {
                flow.addNavigationCases(rule.getFromViewId(), NavigationUtils.convertNavigationCasesToAPI(rule));
            }
            for (FacesFlowSwitch flowSwitch : flowDefinition.getSwitchList()) {
                node = new SwitchNodeImpl(flowSwitch.getId());
                if (flowSwitch.getDefaultOutcome() != null && !this.isEmptyString(flowSwitch.getDefaultOutcome().getFromOutcome())) {
                    if (ELText.isLiteral(flowSwitch.getDefaultOutcome().getFromOutcome())) {
                        ((SwitchNodeImpl)node).setDefaultOutcome(flowSwitch.getDefaultOutcome().getFromOutcome());
                    } else {
                        ((SwitchNodeImpl)node).setDefaultOutcome(application.getExpressionFactory().createValueExpression(facesContext.getELContext(), flowSwitch.getDefaultOutcome().getFromOutcome(), Object.class));
                    }
                }
                for (NavigationCase navigationCase : flowSwitch.getNavigationCaseList()) {
                    SwitchCaseImpl nodeCase = new SwitchCaseImpl();
                    nodeCase.setFromOutcome(navigationCase.getFromOutcome());
                    if (!this.isEmptyString(navigationCase.getIf())) {
                        nodeCase.setCondition(application.getExpressionFactory().createValueExpression(facesContext.getELContext(), navigationCase.getIf(), Object.class));
                    }
                    ((SwitchNodeImpl)node).addCase(nodeCase);
                }
                flow.putSwitch(((SwitchNodeImpl)node).getId(), (SwitchNode)node);
            }
            for (FacesFlowView view : flowDefinition.getViewList()) {
                node = new ViewNodeImpl(view.getId(), view.getVdlDocument());
                flow.addView((ViewNode)node);
            }
            for (FacesFlowReturn flowReturn : flowDefinition.getReturnList()) {
                node = new ReturnNodeImpl(flowReturn.getId());
                if (flowReturn.getNavigationCase() != null && !this.isEmptyString(flowReturn.getNavigationCase().getFromOutcome())) {
                    if (ELText.isLiteral(flowReturn.getNavigationCase().getFromOutcome())) {
                        ((ReturnNodeImpl)node).setFromOutcome(flowReturn.getNavigationCase().getFromOutcome());
                    } else {
                        ((ReturnNodeImpl)node).setFromOutcome(application.getExpressionFactory().createValueExpression(facesContext.getELContext(), flowReturn.getNavigationCase().getFromOutcome(), Object.class));
                    }
                }
                flow.putReturn(((ReturnNodeImpl)node).getId(), (ReturnNode)node);
            }
            flow.freeze();
            application.getFlowHandler().addFlow(facesContext, flow);
        }
        AnnotatedFlowConfigurator.configureAnnotatedFlows(facesContext);
    }

    public static void enableDefaultWindowMode(FacesContext facesContext) {
        String windowMode;
        if (!FacesConfigurator.isEnableDefaultWindowMode(facesContext) && (windowMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "javax.faces.CLIENT_WINDOW_MODE", null)) == null) {
            String defaultWindowMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.DEFAULT_WINDOW_MODE", "url");
            log.info("The current configuration requires client window enabled, setting it to '" + defaultWindowMode + "'");
            facesContext.getExternalContext().getApplicationMap().put(ENABLE_DEFAULT_WINDOW_MODE, Boolean.TRUE);
        }
    }

    public static boolean isEnableDefaultWindowMode(FacesContext facesContext) {
        return Boolean.TRUE.equals(facesContext.getExternalContext().getApplicationMap().get(ENABLE_DEFAULT_WINDOW_MODE));
    }

    private boolean isEmptyString(String value) {
        if (value == null) {
            return true;
        }
        return value.length() <= 0;
    }

    public void configureProtectedViews() {
        Application application = this.getApplication();
        FacesConfigData dispenser = this.getDispenser();
        ViewHandler viewHandler = application.getViewHandler();
        for (String urlPattern : dispenser.getProtectedViewUrlPatterns()) {
            viewHandler.addProtectedView(urlPattern);
        }
    }

    protected InjectionProvider getInjectionProvider() {
        if (this._injectionProvider == null) {
            this._injectionProvider = InjectionProviderFactory.getInjectionProviderFactory(this._externalContext).getInjectionProvider(this._externalContext);
        }
        return this._injectionProvider;
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            this._facesContext = FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    protected Application getApplication() {
        if (this._application == null) {
            return this.getFacesContext().getApplication();
        }
        return this._application;
    }

    protected void setApplication(Application application) {
        this._application = application;
    }
}

