/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIGraphic;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlImageRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlImageRendererBase.class.getName());

    @Override
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIGraphic.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("img", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder && !behaviors.isEmpty()) {
            HtmlRendererUtils.writeIdAndName(writer, uiComponent, facesContext);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        String url = RendererUtils.getIconSrc(facesContext, uiComponent, "url");
        if (url != null) {
            writer.writeURIAttribute("src", url, "value");
        } else if (facesContext.isProjectStage(ProjectStage.Development) && log.isLoggable(Level.WARNING)) {
            log.warning("Component UIGraphic " + uiComponent.getClientId(facesContext) + " has no attribute url, value, name or attribute resolves to null. Path to component " + RendererUtils.getPathToComponent(uiComponent));
        }
        if (uiComponent.getAttributes().get("alt") == null && facesContext.isProjectStage(ProjectStage.Development) && log.isLoggable(Level.WARNING)) {
            log.warning("Component UIGraphic " + uiComponent.getClientId(facesContext) + " has no attribute alt or attribute resolves to null. Path to component " + RendererUtils.getPathToComponent(uiComponent));
        }
        if (uiComponent instanceof ClientBehaviorHolder) {
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderEventProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), CommonEventUtils.getCommonEventsMarked(uiComponent), uiComponent, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
                CommonPropertyUtils.renderCommonPassthroughPropertiesWithoutEvents(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
            CommonPropertyUtils.renderCommonPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        }
        writer.endElement("img");
    }
}

