/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.PropertyResolver;
import java.lang.reflect.Array;
import java.util.List;

public final class PropertyResolverImpl
extends PropertyResolver {
    public Object getValue(final Object base, final Object property) throws EvaluationException, jakarta.faces.el.PropertyNotFoundException {
        if (base == null) {
            return null;
        }
        if (property == null) {
            return null;
        }
        return this.invokeResolver(new ResolverInvoker<Object>(base, property){

            @Override
            public Object invoke(ELResolver resolver, ELContext context) {
                return PropertyResolverImpl.this.getELResolver().getValue(PropertyResolverImpl.this.getELContext(), base, property);
            }
        });
    }

    public Object getValue(Object base, int index) throws EvaluationException, jakarta.faces.el.PropertyNotFoundException {
        return this.getValue(base, (Object)index);
    }

    public void setValue(final Object base, final Object property, final Object newValue) throws EvaluationException, jakarta.faces.el.PropertyNotFoundException {
        if (base == null || property == null || this.isReadOnly(base, property)) {
            throw new jakarta.faces.el.PropertyNotFoundException();
        }
        this.invokeResolver(new ResolverInvoker<Object>(base, property){

            @Override
            public Object invoke(ELResolver resolver, ELContext context) {
                resolver.setValue(context, base, property, newValue);
                return null;
            }

            @Override
            String getMessage() {
                return super.getMessage() + " newValue: '" + newValue + "'";
            }
        });
    }

    public void setValue(Object base, int index, Object newValue) throws EvaluationException, jakarta.faces.el.PropertyNotFoundException {
        if (base == null) {
            throw new jakarta.faces.el.PropertyNotFoundException();
        }
        Class<?> baseType = base.getClass();
        if (base instanceof Object[]) {
            if (index < 0 || index >= ((Object[])base).length) {
                throw new jakarta.faces.el.PropertyNotFoundException();
            }
            this.setValue(base, (Object)index, newValue);
        } else if (base instanceof List) {
            if (index < 0 || index >= ((List)base).size()) {
                throw new jakarta.faces.el.PropertyNotFoundException();
            }
            this.setValue(base, (Object)index, newValue);
        } else if (baseType.isArray()) {
            if (index < 0 || index >= Array.getLength(base)) {
                throw new jakarta.faces.el.PropertyNotFoundException();
            }
            Array.set(base, index, this.getFacesContext().getApplication().getExpressionFactory().coerceToType(newValue, baseType.getComponentType()));
        } else {
            this.setValue(base, (Object)index, newValue);
        }
    }

    public boolean isReadOnly(final Object base, final Object property) {
        return this.invokeResolver(new ResolverInvoker<Boolean>(base, property){

            @Override
            public Boolean invoke(ELResolver resolver, ELContext context) {
                return PropertyResolverImpl.this.getELResolver().isReadOnly(PropertyResolverImpl.this.getELContext(), base, property);
            }
        });
    }

    public boolean isReadOnly(Object base, int index) {
        return this.isReadOnly(base, (Object)index);
    }

    public Class getType(final Object base, final Object property) {
        if (base == null || property == null) {
            throw new jakarta.faces.el.PropertyNotFoundException();
        }
        return (Class)this.invokeResolver(new ResolverInvoker<Class<?>>(base, property){

            @Override
            public Class<?> invoke(ELResolver resolver, ELContext context) {
                return resolver.getType(context, base, property);
            }
        });
    }

    public Class getType(Object base, int index) {
        if (base == null) {
            throw new jakarta.faces.el.PropertyNotFoundException();
        }
        if (base instanceof Object[] ? index < 0 || index >= ((Object[])base).length : base instanceof List && (index < 0 || index >= ((List)base).size())) {
            throw new jakarta.faces.el.PropertyNotFoundException();
        }
        return this.getType(base, (Object)index);
    }

    ELContext getELContext() {
        return this.getFacesContext().getELContext();
    }

    ELResolver getELResolver() {
        return this.getFacesContext().getApplication().getELResolver();
    }

    FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    <T> T invokeResolver(ResolverInvoker<T> invoker) throws EvaluationException, jakarta.faces.el.PropertyNotFoundException {
        try {
            return invoker.invoke(this.getELResolver(), this.getELContext());
        }
        catch (PropertyNotFoundException e) {
            throw new jakarta.faces.el.PropertyNotFoundException("property not found: " + invoker.getMessage() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (ELException e) {
            throw new EvaluationException("exception: " + invoker.getMessage() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("runtime exception: " + invoker.getMessage() + ": " + e.getMessage(), e);
        }
    }

    static abstract class ResolverInvoker<T> {
        private final Object _base;
        private final Object _property;

        ResolverInvoker(Object base, Object property) {
            this._base = base;
            this._property = property;
        }

        abstract T invoke(ELResolver var1, ELContext var2);

        String getMessage() {
            return "base: '" + this._base + "' property/index: '" + this._property + "'";
        }
    }
}

