/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import java.util.Locale;
import java.util.TimeZone;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.ConverterConfig;
import javax.faces.view.facelets.ConverterHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import org.apache.myfaces.tobago.convert.DateTimeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertDateTimeHandler
extends ConverterHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertDateTimeHandler.class);
    private final TagAttribute binding = this.getAttribute("binding");
    private final TagAttribute locale = this.getAttribute("locale");
    private final TagAttribute pattern = this.getAttribute("pattern");
    private final TagAttribute timeZone = this.getAttribute("timeZone");
    private final TagAttribute type = this.getAttribute("type");

    public ConvertDateTimeHandler(ConverterConfig config) {
        super(config);
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws ELException {
        if (parent instanceof ValueHolder) {
            if (ComponentHandler.isNew((UIComponent)parent)) {
                ValueHolder valueHolder = (ValueHolder)parent;
                Converter converter = null;
                ValueExpression valueExpression = null;
                if (this.binding != null) {
                    valueExpression = this.binding.getValueExpression(faceletContext, Converter.class);
                    converter = (Converter)valueExpression.getValue((ELContext)faceletContext);
                }
                if (converter == null) {
                    converter = FacesContext.getCurrentInstance().getApplication().createConverter("org.apache.myfaces.tobago.DateTime");
                    DateTimeConverter dtConverter = (DateTimeConverter)converter;
                    if (this.locale != null) {
                        Object localeObject = this.locale.getObject(faceletContext);
                        if (localeObject instanceof Locale) {
                            dtConverter.setLocale((Locale)localeObject);
                        } else {
                            LOG.warn("Could not set local.");
                        }
                    }
                    if (this.pattern != null) {
                        Object patternObject = this.pattern.getObject(faceletContext);
                        if (patternObject instanceof String) {
                            dtConverter.setPattern((String)patternObject);
                        } else {
                            LOG.warn("Could not set pattern.");
                        }
                    }
                    if (this.timeZone != null) {
                        Object timeZoneObject = this.timeZone.getObject(faceletContext);
                        if (timeZoneObject instanceof TimeZone) {
                            dtConverter.setTimeZone((TimeZone)timeZoneObject);
                        } else {
                            LOG.warn("Could not set time zone.");
                        }
                    }
                    if (this.type != null) {
                        Object typeObject = this.type.getObject(faceletContext);
                        if (typeObject instanceof String) {
                            dtConverter.setType((String)typeObject);
                        } else {
                            LOG.warn("Could not set type.");
                        }
                    }
                    if (valueExpression != null) {
                        valueExpression.setValue((ELContext)faceletContext, (Object)converter);
                    }
                }
                if (converter != null) {
                    valueHolder.setConverter(converter);
                }
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type ValueHolder, type is: " + parent);
        }
    }
}

