/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.io.IOException;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleRenderUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StyleRenderUtils.class);

    private StyleRenderUtils() {
    }

    public static void writeIdSelector(TobagoResponseWriter writer, String id) throws IOException {
        writer.writeText("#");
        char[] chars = id.toCharArray();
        int last = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c != ':') continue;
            writer.writeText(chars, last, i - last);
            writer.writeText("\\:");
            last = i + 1;
        }
        writer.writeText(chars, last, chars.length - last);
    }

    public static void writeSelector(TobagoResponseWriter writer, String selector) throws IOException {
        if (selector.contains("<")) {
            LOG.warn("Found invalid char < inside of style!");
            writer.write(selector.replaceAll("<", "&lt;"));
        } else {
            writer.write(selector);
        }
    }

    public static String encodeIdSelector(String clientId) {
        return "#" + clientId.replaceAll(":", "\\\\:");
    }
}

