/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.myfaces.tobago.internal.util.HtmlWriterHelper;
import org.apache.myfaces.tobago.internal.util.WriterHelper;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponseWriterBase;

public final class XmlResponseWriter
extends TobagoResponseWriterBase {
    private final WriterHelper helper;

    public XmlResponseWriter(Writer writer, String contentType, Charset charset) {
        super(writer, contentType, charset);
        this.helper = new HtmlWriterHelper(writer, charset);
    }

    @Override
    public void writeText(Object text, String property) throws IOException {
        this.closeOpenTag();
        String value = this.findValue(text, property);
        this.helper.writeText(value);
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        this.closeOpenTag();
        this.helper.writeText(text, offset, length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!Arrays.equals(cbuf, XML_VERSION_1_0_ENCODING_UTF_8_CHARS)) {
            super.write(cbuf, off, len);
        }
    }

    @Override
    protected void closeEmptyTag() throws IOException {
        this.getWriter().write("/>");
    }

    @Override
    protected void writerAttributeValue(String value, boolean escape) throws IOException {
        if (escape) {
            this.helper.writeAttributeValue(value);
        } else {
            this.getWriter().write(value);
        }
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer originalWriter) {
        return new XmlResponseWriter(originalWriter, this.getContentType(), Charset.forName(this.getCharacterEncoding()));
    }

    @Override
    public void startDocument() throws IOException {
    }

    @Override
    public void endDocument() throws IOException {
    }
}

