/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.xml.tools.java.generator;

import java.awt.event.*;
import java.beans.*;

/**
 * Should start a wizard traveling around panels.
 *
 * @author  pkuzel
 * @version
 */
public class SAXGeneratorCustomizer extends javax.swing.JPanel implements Customizer, ActionListener {

    /** Serial Version UID */
    private static final long serialVersionUID =9150516877346238338L;


    private SAXGeneratorModel model;
    private SAXGeneratorParsletPanel sAXGeneratorParsletPanel1;
    private SAXGeneratorMethodPanel sAXGeneratorMethodPanel1;
    private SAXGeneratorVersionPanel sAXGeneratorVersionPanel1;
    private SAXGeneratorFilePanel sAXGeneratorFilePanel1;

    /** Creates new form SAXGeneratorCustomizer */
    public SAXGeneratorCustomizer() {
        initComponents ();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.GridLayout(2, 2));
    }// </editor-fold>//GEN-END:initComponents

    public void setObject(java.lang.Object peer) {
        if ( not(peer instanceof SAXGeneratorModel) ) {
            throw new IllegalArgumentException("SAXGeneratorModel class expected.");  // NOI18N
        }        
        
        model = (SAXGeneratorModel) peer;
        
        sAXGeneratorParsletPanel1.setObject(model);
        sAXGeneratorMethodPanel1.setObject(model);  
        sAXGeneratorVersionPanel1.setObject(model);
        sAXGeneratorFilePanel1.setObject(model);
    }    

    private boolean not (boolean expr) {
        return ! expr;
    }
    
    public void addPropertyChangeListener(java.beans.PropertyChangeListener p1) {
    }
    
    public void removePropertyChangeListener(java.beans.PropertyChangeListener p1) {
    }
    
    public void actionPerformed(java.awt.event.ActionEvent e) {
        sAXGeneratorVersionPanel1.actionPerformed(e);
        sAXGeneratorFilePanel1.actionPerformed(e);

    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
