/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.SslContextBuilder;
import org.apache.nifi.security.ssl.StandardKeyManagerBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerBuilder;

public class StandardSslContextBuilder
implements SslContextBuilder {
    private static final String DEFAULT_PROTOCOL = "TLS";
    private String protocol = "TLS";
    private KeyManager keyManager;
    private KeyStore keyStore;
    private char[] keyPassword;
    private TrustManager trustManager;
    private KeyStore trustStore;

    @Override
    public SSLContext build() {
        SSLContext sslContext = this.getSslContext();
        SecureRandom secureRandom = new SecureRandom();
        KeyManager[] keyManagers = this.getKeyManagers();
        TrustManager[] trustManagers = this.getTrustManagers();
        try {
            sslContext.init(keyManagers, trustManagers, secureRandom);
        }
        catch (KeyManagementException e) {
            throw new BuilderConfigurationException("SSLContext initialization failed", e);
        }
        return sslContext;
    }

    public StandardSslContextBuilder protocol(String protocol) {
        this.protocol = Objects.requireNonNull(protocol, "Protocol required");
        return this;
    }

    public StandardSslContextBuilder keyManager(KeyManager keyManager) {
        this.keyManager = Objects.requireNonNull(keyManager, "Key Manager required");
        return this;
    }

    public StandardSslContextBuilder keyStore(KeyStore keyStore) {
        this.keyStore = Objects.requireNonNull(keyStore, "Key Store required");
        return this;
    }

    public StandardSslContextBuilder keyPassword(char[] keyPassword) {
        this.keyPassword = Objects.requireNonNull(keyPassword, "Key Password required");
        return this;
    }

    public StandardSslContextBuilder trustManager(TrustManager trustManager) {
        this.trustManager = Objects.requireNonNull(trustManager, "Trust Manager required");
        return this;
    }

    public StandardSslContextBuilder trustStore(KeyStore trustStore) {
        this.trustStore = Objects.requireNonNull(trustStore, "Trust Store required");
        return this;
    }

    private KeyManager[] getKeyManagers() {
        KeyManager[] keyManagers;
        if (this.keyStore == null) {
            keyManagers = this.keyManager == null ? null : new KeyManager[]{this.keyManager};
        } else {
            X509ExtendedKeyManager configuredKeyManager = new StandardKeyManagerBuilder().keyStore(this.keyStore).keyPassword(this.keyPassword).build();
            keyManagers = new KeyManager[]{configuredKeyManager};
        }
        return keyManagers;
    }

    private TrustManager[] getTrustManagers() {
        TrustManager[] trustManagers;
        if (this.trustStore == null) {
            trustManagers = this.trustManager == null ? null : new TrustManager[]{this.trustManager};
        } else {
            X509ExtendedTrustManager configuredTrustManager = new StandardTrustManagerBuilder().trustStore(this.trustStore).build();
            trustManagers = new TrustManager[]{configuredTrustManager};
        }
        return trustManagers;
    }

    private SSLContext getSslContext() {
        try {
            return SSLContext.getInstance(this.protocol);
        }
        catch (NoSuchAlgorithmException e) {
            String message = String.format("SSLContext creation failed with protocol [%s]", this.protocol);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

