/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.Path;

public final class FileStatusAdapter {
    private final long length;
    private final long diskConsumed;
    private final Path path;
    private final boolean isdir;
    private final short blockReplication;
    private final long blocksize;
    private final long modificationTime;
    private final long accessTime;
    private final short permission;
    private final String owner;
    private final String group;
    private final Path symlink;
    private final List<BlockLocation> blockLocations;
    private final boolean isEncrypted;
    private final boolean isErasureCoded;

    public FileStatusAdapter(long length, long diskConsumed, Path path, boolean isdir, short blockReplication, long blocksize, long modificationTime, long accessTime, short permission, String owner, String group, Path symlink, BlockLocation[] locations, boolean isEncrypted, boolean isErasureCoded) {
        this.length = length;
        this.diskConsumed = diskConsumed;
        this.path = path;
        this.isdir = isdir;
        this.blockReplication = blockReplication;
        this.blocksize = blocksize;
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
        this.permission = permission;
        this.owner = owner;
        this.group = group;
        this.symlink = symlink;
        this.blockLocations = new ArrayList<BlockLocation>(Arrays.asList(locations));
        this.isEncrypted = isEncrypted;
        this.isErasureCoded = isErasureCoded;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDir() {
        return this.isdir;
    }

    public boolean isFile() {
        return !this.isdir;
    }

    public short getBlockReplication() {
        return this.blockReplication;
    }

    public long getBlocksize() {
        return this.blocksize;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public short getPermission() {
        return this.permission;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public Path getSymlink() {
        return this.symlink;
    }

    public long getLength() {
        return this.length;
    }

    public long getDiskConsumed() {
        return this.diskConsumed;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isErasureCoded() {
        return this.isErasureCoded;
    }

    public BlockLocation[] getBlockLocations() {
        return this.blockLocations.toArray(new BlockLocation[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{").append("path=").append(this.path).append("; isDirectory=").append(this.isdir);
        if (this.isFile()) {
            sb.append("; length=").append(this.length).append("; diskConsumed= ").append(this.getDiskConsumed()).append("; blockReplication=").append(this.blockReplication).append("; blocksize=").append(this.blocksize);
        }
        sb.append("; accessTime=").append(this.accessTime).append("; owner=").append(this.owner).append("; group=").append(this.group).append("; permission=").append(this.permission).append("; isSymlink=").append(this.getSymlink()).append("}");
        return sb.toString();
    }
}

