/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.util.HashMap;
import java.util.Map;

public enum Statistic {
    OBJECTS_RENAMED("objects_renamed", "Total number of objects renamed within the object store."),
    OBJECTS_CREATED("objects_created", "Total number of objects created through the object store."),
    OBJECTS_DELETED("objects_deleted", "Total number of objects deleted from the object store."),
    OBJECTS_READ("objects_read", "Total number of objects read from the object store."),
    OBJECTS_QUERY("objects_query", "Total number of objects queried from the object store."),
    OBJECTS_LIST("objects_list", "Total number of object list query from the object store."),
    INVOCATION_COPY_FROM_LOCAL_FILE("op_copy_from_local_file", "Calls of copyFromLocalFile()"),
    INVOCATION_CREATE("op_create", "Calls of create()"),
    INVOCATION_CREATE_NON_RECURSIVE("op_create_non_recursive", "Calls of createNonRecursive()"),
    INVOCATION_DELETE("op_delete", "Calls of delete()"),
    INVOCATION_EXISTS("op_exists", "Calls of exists()"),
    INVOCATION_GET_FILE_CHECKSUM("op_get_file_checksum", "Calls of getFileChecksum()"),
    INVOCATION_GET_FILE_STATUS("op_get_file_status", "Calls of getFileStatus()"),
    INVOCATION_GLOB_STATUS("op_glob_status", "Calls of globStatus()"),
    INVOCATION_IS_DIRECTORY("op_is_directory", "Calls of isDirectory()"),
    INVOCATION_IS_FILE("op_is_file", "Calls of isFile()"),
    INVOCATION_LIST_FILES("op_list_files", "Calls of listFiles()"),
    INVOCATION_LIST_LOCATED_STATUS("op_list_located_status", "Calls of listLocatedStatus()"),
    INVOCATION_LIST_STATUS("op_list_status", "Calls of listStatus()"),
    INVOCATION_MKDIRS("op_mkdirs", "Calls of mkdirs()"),
    INVOCATION_OPEN("op_open", "Calls of open()"),
    INVOCATION_RENAME("op_rename", "Calls of rename()"),
    INVOCATION_SET_TIMES("op_set_times", "Calls of setTimes()"),
    INVOCATION_IS_FILE_CLOSED("op_is_file_closed", "Calls of isFileClosed()"),
    INVOCATION_RECOVER_LEASE("op_recover_lease", "Calls of recoverLease()"),
    INVOCATION_SET_SAFE_MODE("op_set_safe_mode", "Calls of setSafeMode()");

    private static final Map<String, Statistic> SYMBOL_MAP;
    private final String symbol;
    private final String description;

    private Statistic(String symbol, String description) {
        this.symbol = symbol;
        this.description = description;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static Statistic fromSymbol(String symbol) {
        return SYMBOL_MAP.get(symbol);
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.symbol;
    }

    static {
        SYMBOL_MAP = new HashMap<String, Statistic>(Statistic.values().length);
        for (Statistic stat : Statistic.values()) {
            SYMBOL_MAP.put(stat.getSymbol(), stat);
        }
    }
}

