/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.util.S3StorageType;

public final class S3Utils {
    public static String urlDecode(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
    }

    public static String urlEncode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
    }

    private S3Utils() {
    }

    public static ReplicationConfig resolveS3ClientSideReplicationConfig(String s3StorageTypeHeader, ReplicationConfig clientConfiguredReplConfig, ReplicationConfig bucketReplConfig) throws OS3Exception {
        boolean isECBucket;
        ReplicationConfig clientDeterminedReplConfig = null;
        S3StorageType s3StorageType = null;
        if (s3StorageTypeHeader != null && !s3StorageTypeHeader.equals("")) {
            s3StorageType = S3Utils.toS3StorageType(s3StorageTypeHeader);
        }
        boolean bl = isECBucket = bucketReplConfig != null && bucketReplConfig.getReplicationType() == HddsProtos.ReplicationType.EC;
        if (isECBucket) {
            clientDeterminedReplConfig = bucketReplConfig;
        } else {
            boolean isUserPassedReplicationInSupportedList = s3StorageType != null && (s3StorageType.getFactor().getValue() == ReplicationFactor.ONE.getValue() || s3StorageType.getFactor().getValue() == ReplicationFactor.THREE.getValue());
            clientDeterminedReplConfig = isUserPassedReplicationInSupportedList ? ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)ReplicationType.toProto((ReplicationType)s3StorageType.getType()), (HddsProtos.ReplicationFactor)ReplicationFactor.toProto((ReplicationFactor)s3StorageType.getFactor())) : clientConfiguredReplConfig;
        }
        return clientDeterminedReplConfig;
    }

    public static S3StorageType toS3StorageType(String storageType) throws OS3Exception {
        try {
            return S3StorageType.valueOf(storageType);
        }
        catch (IllegalArgumentException ex) {
            throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, storageType, ex);
        }
    }
}

